/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui.modwiki.moddata.displaycontent;

import com.brandon3055.brandonscore.client.gui.modulargui.IModularGui;
import com.brandon3055.brandonscore.client.gui.modulargui.MGuiElementBase;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.EnumAlignment;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.IMGuiListener;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiButtonSolid;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiHoverPopup;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiLabel;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiSlotRender;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiStackIcon;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiTextField;
import com.brandon3055.brandonscore.lib.StackReference;
import com.brandon3055.draconicevolution.client.gui.modwiki.GuiModWiki;
import com.brandon3055.draconicevolution.client.gui.modwiki.guielements.StackSelector;
import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.displaycontent.DisplayComponentBase;
import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.displaycontent.IDisplayComponentFactory;
import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.guidoctree.TreeBranchRoot;
import com.google.common.base.Predicate;
import java.util.LinkedList;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.TextFormatting;
import org.w3c.dom.Element;

public class DCStack
extends DisplayComponentBase {
    public static final String ATTRIB_SCALE = "scale";
    public static final String ATTRIB_TIP = "tooltip";
    public static final String ATTRIB_SLOT = "renderSlot";
    public MGuiStackIcon stackIcon;
    private MGuiElementBase iconBackground;
    public int scale = 100;
    public boolean toolTip = true;
    public boolean renderSlot = false;
    public String stackString;
    private StackSelector selector;

    public DCStack(GuiModWiki modularGui, String componentType, TreeBranchRoot branch) {
        super(modularGui, componentType, branch);
        this.ySize = 20;
        this.stackIcon = new MGuiStackIcon((IModularGui)modularGui, 0, 0, 18, 18, new StackReference("null"));
        this.addChild((MGuiElementBase)this.stackIcon);
        this.iconBackground = new MGuiSlotRender((IModularGui)modularGui);
        this.stackIcon.setBackground(this.iconBackground);
    }

    @Override
    public void setXSize(int xSize) {
        int size;
        super.setXSize(xSize);
        this.stackIcon.ySize = this.stackIcon.xSize = (size = Math.min(xSize - 4, (int)((double)this.scale / 100.0 * 18.0)));
        this.iconBackground.setEnabled(this.renderSlot);
        this.iconBackground.yPos = this.stackIcon.yPos;
        int xOffset = 0;
        switch (this.alignment) {
            case LEFT: {
                xOffset = 2;
                break;
            }
            case CENTER: {
                xOffset = xSize / 2 - size / 2;
                break;
            }
            case RIGHT: {
                xOffset = xSize - size - 2;
            }
        }
        this.stackIcon.xPos = this.xPos + xOffset;
        this.ySize = this.stackIcon.ySize;
        this.iconBackground.xPos = this.stackIcon.xPos;
        this.iconBackground.yPos = this.stackIcon.yPos;
    }

    @Override
    public LinkedList<MGuiElementBase> getEditControls() {
        LinkedList<MGuiElementBase> list = super.getEditControls();
        list.add((MGuiElementBase)new MGuiButtonSolid(this.modularGui, "TOGGLE_ALIGN", 0, 0, 26, 12, "Align"){

            public int getBorderColour(boolean hovering, boolean disabled) {
                return hovering ? -16711936 : -65536;
            }
        }.setListener((IMGuiListener)this).setToolTip(new String[]{"Toggle Horizontal Alignment"}));
        list.add((MGuiElementBase)new MGuiButtonSolid(this.modularGui, "SELECT_STACK", 0, 0, 56, 12, "Pick Stack"){

            public int getBorderColour(boolean hovering, boolean disabled) {
                return hovering ? -16711936 : -65536;
            }
        }.setListener((IMGuiListener)this).setToolTip(new String[]{"Select a stack from your inventory"}));
        String s = "Turn ToolTip: " + (this.toolTip ? "Off" : "On");
        list.add((MGuiElementBase)new MGuiButtonSolid(this.modularGui, "TOGGLE_TOOLTIP", 0, 0, this.fontRenderer.func_78256_a(s) + 4, 12, s){

            public int getBorderColour(boolean hovering, boolean disabled) {
                return hovering ? -16711936 : -65536;
            }
        }.setListener((IMGuiListener)this).setToolTip(new String[]{"Toggle item tool tip on or off"}));
        s = "Turn Slot: " + (this.toolTip ? "Off" : "On");
        list.add((MGuiElementBase)new MGuiButtonSolid(this.modularGui, "TOGGLE_SLOT", 0, 0, this.fontRenderer.func_78256_a(s) + 4, 12, s){

            public int getBorderColour(boolean hovering, boolean disabled) {
                return hovering ? -16711936 : -65536;
            }
        }.setListener((IMGuiListener)this).setToolTip(new String[]{"Toggle Slot Renderer on or off"}));
        list.add((MGuiElementBase)new MGuiLabel(this.modularGui, 0, 0, 30, 12, "Scale:").setAlignment(EnumAlignment.CENTER));
        MGuiTextField scaleField = new MGuiTextField(this.modularGui, 0, 0, 36, 12, this.fontRenderer).setListener((IMGuiListener)this).setMaxStringLength(2048).setText(String.valueOf(this.scale));
        scaleField.addChild((MGuiElementBase)new MGuiHoverPopup(this.modularGui, new String[]{"Set the stack scale (100 = normal stack size)", TextFormatting.GOLD + "The size of the image will be limited by both this and the width of the GUI.", TextFormatting.GOLD + "Whichever value is smaller will take priority.", TextFormatting.GREEN + "Will save as you type."}, (MGuiElementBase)scaleField));
        scaleField.setId("SCALE");
        scaleField.setValidator((Predicate)new Predicate<String>(){

            public boolean apply(@Nullable String input) {
                try {
                    Integer.parseInt(input);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return true;
            }
        });
        list.add((MGuiElementBase)scaleField);
        return list;
    }

    @Override
    public void onMGuiEvent(String eventString, MGuiElementBase eventElement) {
        super.onMGuiEvent(eventString, eventElement);
        if (eventElement.id.equals("SCALE") && eventString.equals("TEXT_FIELD_CHANGED") && eventElement instanceof MGuiTextField) {
            if (StringUtils.func_151246_b((String)((MGuiTextField)eventElement).getText())) {
                return;
            }
            int newScale = 1;
            try {
                newScale = Integer.parseInt(((MGuiTextField)eventElement).getText());
            }
            catch (Exception e) {
                // empty catch block
            }
            if (newScale < 30) {
                newScale = 30;
            }
            this.element.setAttribute(ATTRIB_SCALE, String.valueOf(newScale));
            int pos = ((MGuiTextField)eventElement).getCursorPosition();
            this.save();
            for (MGuiElementBase element : this.branch.guiWiki.contentWindow.editControls) {
                if (!(element instanceof MGuiTextField) || !element.id.equals("SCALE")) continue;
                ((MGuiTextField)element).setFocused(true);
                ((MGuiTextField)element).setCursorPosition(pos);
                break;
            }
        } else if (eventElement instanceof MGuiButtonSolid && ((MGuiButtonSolid)eventElement).buttonName.equals("TOGGLE_TOOLTIP")) {
            this.element.setAttribute(ATTRIB_TIP, String.valueOf(!this.toolTip));
            this.save();
        } else if (eventElement instanceof MGuiButtonSolid && ((MGuiButtonSolid)eventElement).buttonName.equals("TOGGLE_SLOT")) {
            this.element.setAttribute(ATTRIB_SLOT, String.valueOf(!this.renderSlot));
            this.save();
        } else if (eventElement instanceof MGuiButtonSolid && ((MGuiButtonSolid)eventElement).buttonName.equals("SELECT_STACK")) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            this.selector = new StackSelector(this.modularGui, this.list.xPos + this.list.leftPadding, this.list.yPos + this.list.topPadding, this.list.xSize - this.list.leftPadding - this.list.rightPadding, this.list.ySize - this.list.topPadding - this.list.bottomPadding);
            this.selector.setListener(this);
            LinkedList<ItemStack> stacks = new LinkedList<ItemStack>();
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (stack == null) continue;
                stacks.add(stack);
            }
            this.selector.setStacks(stacks);
            this.selector.addChild(new MGuiButtonSolid(this.modularGui, "CANCEL_PICK", this.selector.xPos + this.selector.xSize - 42, this.selector.yPos + this.selector.ySize - 22, 40, 20, "Cancel").setListener((IMGuiListener)this).setId("CANCEL_PICK"));
            this.selector.initElement();
            this.modularGui.getManager().add((MGuiElementBase)this.selector, 2);
        } else if (eventElement.id.equals("CANCEL_PICK") && this.selector != null) {
            this.modularGui.getManager().remove((MGuiElementBase)this.selector);
        } else if (eventString.equals("SELECTOR_PICK")) {
            boolean shouldSave = false;
            if (eventElement instanceof MGuiStackIcon) {
                StackReference reference = new StackReference(((MGuiStackIcon)eventElement).getStack());
                this.stackIcon.setStack(reference);
                this.element.setTextContent(reference.toString());
                shouldSave = true;
            }
            this.modularGui.getManager().remove((MGuiElementBase)this.selector);
            if (shouldSave) {
                this.save();
            }
        }
    }

    @Override
    public void onCreated() {
        this.element.setAttribute(ATTRIB_SCALE, "100");
        this.element.setAttribute(ATTRIB_TIP, "true");
        this.element.setAttribute(ATTRIB_SLOT, "true");
    }

    @Override
    public void loadFromXML(Element element) {
        super.loadFromXML(element);
        this.toolTip = !element.hasAttribute(ATTRIB_TIP) || Boolean.parseBoolean(element.getAttribute(ATTRIB_TIP));
        this.renderSlot = !element.hasAttribute(ATTRIB_SLOT) || Boolean.parseBoolean(element.getAttribute(ATTRIB_SLOT));
        this.stackString = element.getTextContent();
        StackReference ref = StackReference.fromString((String)this.stackString);
        if (ref == null) {
            ref = new StackReference("null");
        }
        this.stackIcon.setStack(ref);
        this.stackIcon.setToolTip(this.toolTip);
        this.iconBackground.setEnabled(this.renderSlot);
        try {
            this.scale = Integer.parseInt(element.getAttribute(ATTRIB_SCALE));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.scale < 30) {
            this.scale = 30;
        }
    }

    public static class Factory
    implements IDisplayComponentFactory {
        @Override
        public DisplayComponentBase createNewInstance(GuiModWiki guiWiki, TreeBranchRoot branch) {
            DCStack component = new DCStack(guiWiki, this.getID(), branch);
            component.setWorldAndResolution(guiWiki.field_146297_k, guiWiki.screenWidth(), guiWiki.screenHeight());
            return component;
        }

        @Override
        public String getID() {
            return "stack";
        }
    }
}

