/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui.modwiki.swing;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import net.minecraft.util.text.TextFormatting;

public class UIEditTextArea
extends JFrame
implements ActionListener {
    public volatile String text;
    public volatile boolean hasChanged = false;
    public volatile boolean isFinished = false;
    private JPanel contentPane;
    private JPanel buttonPane;
    private JButton finishButton;
    private JButton insertButton;
    private JComboBox styleSelector;
    private JTextArea textArea;
    public volatile int linkTimer = 20;

    public UIEditTextArea(String text) {
        this.text = text;
        this.setupUI();
        this.textArea.setText(text);
        for (TextFormatting format : TextFormatting.values()) {
            this.styleSelector.addItem(format);
        }
        this.styleSelector.setMaximumRowCount(20);
        this.setTitle("Edit Text");
        this.setDefaultCloseOperation(2);
        this.insertButton.addActionListener(this);
        this.textArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                UIEditTextArea.this.text = UIEditTextArea.this.textArea.getText();
                UIEditTextArea.this.hasChanged = true;
            }
        });
        this.styleSelector.addActionListener(this);
        this.finishButton.addActionListener(this);
        Thread timeout = new Thread(){

            @Override
            public void run() {
                while (UIEditTextArea.this.linkTimer > 0) {
                    --UIEditTextArea.this.linkTimer;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                UIEditTextArea.this.dispose();
            }
        };
        timeout.setDaemon(true);
        timeout.start();
    }

    private void setupUI() {
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new GridLayoutManager(2, 1, new Insets(10, 10, 10, 10), -1, -1));
        this.contentPane.setPreferredSize(new Dimension(600, 400));
        this.contentPane.putClientProperty("html.disable", Boolean.FALSE);
        this.buttonPane = new JPanel();
        this.buttonPane.setLayout(new GridLayoutManager(1, 5, new Insets(0, 0, 0, 0), -1, -1));
        this.contentPane.add((Component)this.buttonPane, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 1, null, null, null, 0, false));
        this.finishButton = new JButton();
        this.finishButton.setText("Finish");
        this.buttonPane.add((Component)this.finishButton, new GridConstraints(0, 4, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        this.buttonPane.add((Component)spacer1, new GridConstraints(0, 3, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        this.insertButton = new JButton();
        this.insertButton.setText("Repeat Formatting");
        this.buttonPane.add((Component)this.insertButton, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.styleSelector = new JComboBox();
        this.styleSelector.setRenderer(new CustomCellRenderer());
        this.buttonPane.add((Component)this.styleSelector, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null, 0, false));
        JLabel label1 = new JLabel();
        label1.setText("Add Format Code: ");
        this.buttonPane.add((Component)label1, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JScrollPane scrollPane1 = new JScrollPane();
        this.contentPane.add((Component)scrollPane1, new GridConstraints(0, 0, 1, 1, 0, 3, 5, 5, null, null, null, 0, false));
        this.textArea = new JTextArea();
        scrollPane1.setViewportView(this.textArea);
        this.setContentPane(this.contentPane);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("Finish")) {
            this.isFinished = true;
            this.dispose();
        } else if (command.equals("Repeat Formatting") || command.equals("comboBoxChanged")) {
            this.textArea.insert(this.styleSelector.getSelectedItem().toString(), this.textArea.getCaretPosition());
            this.text = this.textArea.getText();
            this.hasChanged = true;
        }
    }

    private class CustomCellRenderer
    extends JButton
    implements ListCellRenderer {
        boolean b = false;

        public CustomCellRenderer() {
            this.setOpaque(true);
        }

        @Override
        public void setBackground(Color bg) {
            if (!this.b) {
                return;
            }
            super.setBackground(bg);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.b = true;
            if (value instanceof TextFormatting) {
                switch ((TextFormatting)value) {
                    case BLACK: {
                        this.setBackground(new Color(0));
                        break;
                    }
                    case DARK_BLUE: {
                        this.setBackground(new Color(170));
                        break;
                    }
                    case DARK_GREEN: {
                        this.setBackground(new Color(43520));
                        break;
                    }
                    case DARK_AQUA: {
                        this.setBackground(new Color(43690));
                        break;
                    }
                    case DARK_RED: {
                        this.setBackground(new Color(0xAA0000));
                        break;
                    }
                    case DARK_PURPLE: {
                        this.setBackground(new Color(0xAA00AA));
                        break;
                    }
                    case GOLD: {
                        this.setBackground(new Color(0xFFAA00));
                        break;
                    }
                    case GRAY: {
                        this.setBackground(new Color(0xAAAAAA));
                        break;
                    }
                    case DARK_GRAY: {
                        this.setBackground(new Color(0x555555));
                        break;
                    }
                    case BLUE: {
                        this.setBackground(new Color(0x5555FF));
                        break;
                    }
                    case GREEN: {
                        this.setBackground(new Color(0x55FF55));
                        break;
                    }
                    case AQUA: {
                        this.setBackground(new Color(0x55FFFF));
                        break;
                    }
                    case RED: {
                        this.setBackground(new Color(0xFF5555));
                        break;
                    }
                    case LIGHT_PURPLE: {
                        this.setBackground(new Color(0xFF55FF));
                        break;
                    }
                    case YELLOW: {
                        this.setBackground(new Color(0xFFFF55));
                        break;
                    }
                    case WHITE: {
                        this.setBackground(new Color(0xFFFFFF));
                        break;
                    }
                    default: {
                        this.setBackground(new Color(0xFFFFFF));
                    }
                }
                this.setText(((TextFormatting)value).func_96297_d());
            } else {
                this.setText(value.toString());
            }
            this.b = false;
            return this;
        }
    }
}

