/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.handler;

import codechicken.lib.colour.ColourRGBA;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.util.TransformUtils;
import com.brandon3055.brandonscore.lib.PairKV;
import com.brandon3055.brandonscore.utils.DataUtils;
import com.brandon3055.brandonscore.utils.ModelUtils;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.DEFeatures;
import com.brandon3055.draconicevolution.api.itemconfig.ToolConfigHelper;
import com.brandon3055.draconicevolution.client.handler.HudHandler;
import com.brandon3055.draconicevolution.helpers.ResourceHelperDE;
import com.brandon3055.draconicevolution.items.armor.DraconicArmor;
import com.brandon3055.draconicevolution.items.armor.WyvernArmor;
import com.brandon3055.draconicevolution.items.tools.CreativeExchanger;
import com.brandon3055.draconicevolution.items.tools.MiningToolBase;
import com.brandon3055.draconicevolution.utils.ITickableTimeout;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;

public class ClientEventHandler {
    public static Map<EntityPlayer, DataUtils.XZPair<Float, Integer>> playerShieldStatus = new HashMap<EntityPlayer, DataUtils.XZPair<Float, Integer>>();
    public static int elapsedTicks;
    private static float previousFOB;
    public static float previousSensitivity;
    public static boolean bowZoom;
    public static boolean lastTickBowZoom;
    public static int tickSet;
    public static float energyCrystalAlphaValue;
    public static float energyCrystalAlphaTarget;
    public static boolean playerHoldingWrench;
    public static Minecraft mc;
    private static Random rand;
    public static IBakedModel shieldModel;
    private static boolean isJEIInstalled;
    public static final List<ITickableTimeout> tickableList;

    public ClientEventHandler() {
        isJEIInstalled = Loader.isModLoaded((String)"JEI");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTickable(ITickableTimeout tickable) {
        List<ITickableTimeout> list = tickableList;
        synchronized (list) {
            tickableList.add(tickable);
        }
    }

    @SubscribeEvent
    public void renderGameOverlay(RenderGameOverlayEvent.Post event) {
        HudHandler.drawHUD(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void tickEnd(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.type != TickEvent.Type.CLIENT || event.side != Side.CLIENT) {
            return;
        }
        ++elapsedTicks;
        List<ITickableTimeout> list = tickableList;
        synchronized (list) {
            ArrayList<ITickableTimeout> toRemove = new ArrayList<ITickableTimeout>();
            for (int i = 0; i < tickableList.size(); ++i) {
                ITickableTimeout timeout = tickableList.get(i);
                if (timeout.getTimeOut() > 10) {
                    toRemove.add(timeout);
                    continue;
                }
                timeout.tick();
            }
            for (ITickableTimeout timeout : toRemove) {
                tickableList.remove(timeout);
            }
        }
        HudHandler.clientTick();
        Iterator<Map.Entry<EntityPlayer, DataUtils.XZPair<Float, Integer>>> i = playerShieldStatus.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<EntityPlayer, DataUtils.XZPair<Float, Integer>> entry = i.next();
            if (elapsedTicks - (Integer)entry.getValue().getValue() <= 5) continue;
            i.remove();
        }
        if (mc == null) {
            mc = Minecraft.func_71410_x();
        } else if (ClientEventHandler.mc.field_71441_e != null) {
            if (bowZoom && !lastTickBowZoom) {
                previousSensitivity = Minecraft.func_71410_x().field_71474_y.field_74341_c;
                Minecraft.func_71410_x().field_71474_y.field_74341_c = previousSensitivity / 3.0f;
            } else if (!bowZoom && lastTickBowZoom) {
                Minecraft.func_71410_x().field_71474_y.field_74341_c = previousSensitivity;
            }
            lastTickBowZoom = bowZoom;
            if (elapsedTicks - tickSet > 10) {
                bowZoom = false;
            }
            if (energyCrystalAlphaValue < energyCrystalAlphaTarget) {
                energyCrystalAlphaValue += 0.01f;
            }
            if (energyCrystalAlphaValue > energyCrystalAlphaTarget) {
                energyCrystalAlphaValue -= 0.01f;
            }
            if (Math.abs(energyCrystalAlphaTarget - energyCrystalAlphaValue) <= 0.02f) {
                energyCrystalAlphaTarget = rand.nextFloat();
            }
        }
    }

    @SubscribeEvent
    public void fovUpdate(FOVUpdateEvent event) {
    }

    @SubscribeEvent
    public void renderPlayerEvent(RenderPlayerEvent.Post event) {
        if (playerShieldStatus.containsKey(event.getEntityPlayer())) {
            if (shieldModel == null) {
                try {
                    shieldModel = OBJLoader.INSTANCE.loadModel(ResourceHelperDE.getResource("models/armor/shield_sphere.obj")).bake((IModelState)TransformUtils.DEFAULT_BLOCK, DefaultVertexFormats.field_176600_a, TextureUtils.bakedTextureGetter);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179129_p();
            GlStateManager.func_179118_c();
            GlStateManager.func_179147_l();
            GlStateManager.func_179140_f();
            float p = ((Float)playerShieldStatus.get(event.getEntityPlayer()).getKey()).floatValue();
            EntityPlayerSP viewingPlayer = Minecraft.func_71410_x().field_71439_g;
            int i = 5 - (elapsedTicks - (Integer)playerShieldStatus.get(event.getEntityPlayer()).getValue());
            if (viewingPlayer != event.getEntityPlayer()) {
                double translationXLT = event.getEntityPlayer().field_70169_q - viewingPlayer.field_70169_q;
                double translationYLT = event.getEntityPlayer().field_70167_r - viewingPlayer.field_70167_r;
                double translationZLT = event.getEntityPlayer().field_70166_s - viewingPlayer.field_70166_s;
                double translationX = translationXLT + (event.getEntityPlayer().field_70165_t - viewingPlayer.field_70165_t - translationXLT) * (double)event.getPartialRenderTick();
                double translationY = translationYLT + (event.getEntityPlayer().field_70163_u - viewingPlayer.field_70163_u - translationYLT) * (double)event.getPartialRenderTick();
                double translationZ = translationZLT + (event.getEntityPlayer().field_70161_v - viewingPlayer.field_70161_v - translationZLT) * (double)event.getPartialRenderTick();
                GlStateManager.func_179137_b((double)translationX, (double)(translationY + 1.1), (double)translationZ);
            } else {
                GlStateManager.func_179137_b((double)0.0, (double)1.15, (double)0.0);
            }
            GlStateManager.func_179139_a((double)1.0, (double)1.5, (double)1.0);
            GlStateManager.func_179144_i((int)Minecraft.func_71410_x().func_147117_R().func_110552_b());
            ModelUtils.renderQuadsARGB((List)shieldModel.func_188616_a(null, null, 0L), (int)new ColourRGBA(1.0 - (double)p, 0.0, (double)p, (double)i / 5.0).argb());
            GlStateManager.func_179089_o();
            GlStateManager.func_179141_d();
            GlStateManager.func_179084_k();
            GlStateManager.func_179145_e();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179121_F();
        }
    }

    @SubscribeEvent
    public void renderArmorEvent(RenderPlayerEvent.SetArmorModel event) {
        if (event.isCanceled()) {
            return;
        }
        if (event.getStack() != null && (event.getStack().func_77973_b() instanceof DraconicArmor || event.getStack().func_77973_b() instanceof WyvernArmor)) {
            ItemArmor itemarmor = (ItemArmor)event.getStack().func_77973_b();
            event.setResult(1);
        }
    }

    @SubscribeEvent
    public void guiOpenEvent(GuiOpenEvent event) {
        if (event.getGui() instanceof GuiMainMenu && rand.nextInt(150) == 0) {
            try {
                String s = rand.nextBoolean() ? "Icosahedrons proudly brought to you by CCL!!!" : Utils.addCommas((long)Long.MAX_VALUE) + " RF!!!!";
                ReflectionHelper.setPrivateValue(GuiMainMenu.class, (Object)((GuiMainMenu)event.getGui()), (Object)s, (String[])new String[]{"splashText", "field_110353_x"});
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    public void renderWorldEvent(RenderWorldLastEvent event) {
        if (event.isCanceled()) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        World world = player.func_130014_f_();
        ItemStack stack = player.func_184614_ca();
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71476_x == null || mc.field_71476_x.field_72313_a != RayTraceResult.Type.BLOCK) {
            return;
        }
        if (stack != null && stack.func_77973_b() == DEFeatures.creativeExchanger) {
            List<BlockPos> blocks = CreativeExchanger.getBlocksToReplace(stack, mc.field_71476_x.func_178782_a(), world, mc.field_71476_x.field_178784_b);
            Tessellator tessellator = Tessellator.func_178181_a();
            VertexBuffer buffer = tessellator.func_178180_c();
            double offsetX = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)event.getPartialTicks();
            double offsetY = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)event.getPartialTicks();
            double offsetZ = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)event.getPartialTicks();
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_187441_d((float)2.0f);
            GlStateManager.func_179090_x();
            for (BlockPos block : blocks) {
                if (world.func_175623_d(block)) continue;
                double renderX = (double)block.func_177958_n() - offsetX;
                double renderY = (double)block.func_177956_o() - offsetY;
                double renderZ = (double)block.func_177952_p() - offsetZ;
                AxisAlignedBB boundingBox = new AxisAlignedBB(renderX, renderY, renderZ, renderX + 1.0, renderY + 1.0, renderZ + 1.0).func_72314_b(0.001, 0.001, 0.001);
                float colour = 1.0f;
                if (!world.func_180495_p(block.func_177972_a(mc.field_71476_x.field_178784_b)).func_177230_c().func_176200_f((IBlockAccess)world, block.func_177972_a(mc.field_71476_x.field_178784_b))) {
                    GlStateManager.func_179097_i();
                    colour = 0.2f;
                }
                buffer.func_181668_a(3, DefaultVertexFormats.field_181706_f);
                buffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72339_c).func_181666_a(colour, colour, colour, colour).func_181675_d();
                buffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72339_c).func_181666_a(colour, colour, colour, colour).func_181675_d();
                buffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72334_f).func_181666_a(colour, colour, colour, colour).func_181675_d();
                buffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72334_f).func_181666_a(colour, colour, colour, colour).func_181675_d();
                buffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72339_c).func_181666_a(colour, colour, colour, colour).func_181675_d();
                tessellator.func_78381_a();
                buffer.func_181668_a(3, DefaultVertexFormats.field_181706_f);
                buffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72339_c).func_181666_a(colour, colour, colour, colour).func_181675_d();
                buffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72339_c).func_181666_a(colour, colour, colour, colour).func_181675_d();
                buffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72334_f).func_181666_a(colour, colour, colour, colour).func_181675_d();
                buffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72334_f).func_181666_a(colour, colour, colour, colour).func_181675_d();
                buffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72339_c).func_181666_a(colour, colour, colour, colour).func_181675_d();
                tessellator.func_78381_a();
                buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
                buffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72339_c).func_181666_a(colour, colour, colour, colour).func_181675_d();
                buffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72339_c).func_181666_a(colour, colour, colour, colour).func_181675_d();
                buffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72339_c).func_181666_a(colour, colour, colour, colour).func_181675_d();
                buffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72339_c).func_181666_a(colour, colour, colour, colour).func_181675_d();
                buffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72334_f).func_181666_a(colour, colour, colour, colour).func_181675_d();
                buffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72334_f).func_181666_a(colour, colour, colour, colour).func_181675_d();
                buffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72334_f).func_181666_a(colour, colour, colour, colour).func_181675_d();
                buffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72334_f).func_181666_a(colour, colour, colour, colour).func_181675_d();
                tessellator.func_78381_a();
                if (world.func_180495_p(block.func_177972_a(mc.field_71476_x.field_178784_b)).func_177230_c().func_176200_f((IBlockAccess)world, block.func_177972_a(mc.field_71476_x.field_178784_b))) continue;
                GlStateManager.func_179126_j();
            }
            GlStateManager.func_179098_w();
            GlStateManager.func_179084_k();
        }
        if (stack == null || !(stack.func_77973_b() instanceof MiningToolBase) || !ToolConfigHelper.getBooleanField("showDigAOE", stack)) {
            return;
        }
        BlockPos pos = mc.field_71476_x.func_178782_a();
        IBlockState state = world.func_180495_p(pos);
        MiningToolBase tool = (MiningToolBase)stack.func_77973_b();
        if (!tool.isToolEffective(stack, state)) {
            return;
        }
        this.renderMiningAOE(world, stack, pos, player, event.getPartialTicks());
    }

    private void renderMiningAOE(World world, ItemStack stack, BlockPos pos, EntityPlayerSP player, float partialTicks) {
        MiningToolBase tool = (MiningToolBase)stack.func_77973_b();
        PairKV<BlockPos, BlockPos> aoe = tool.getMiningArea(pos, (EntityPlayer)player, tool.getDigAOE(stack), tool.getDigDepth(stack));
        ArrayList blocks = Lists.newArrayList((Iterable)BlockPos.func_177980_a((BlockPos)((BlockPos)aoe.getKey()), (BlockPos)((BlockPos)aoe.getValue())));
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer buffer = tessellator.func_178180_c();
        double offsetX = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)partialTicks;
        double offsetY = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)partialTicks;
        double offsetZ = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)partialTicks;
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_187441_d((float)2.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179097_i();
        buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        for (BlockPos block : blocks) {
            float alpha;
            IBlockState state = world.func_180495_p(block);
            if (!tool.isToolEffective(stack, state)) continue;
            double renderX = (double)block.func_177958_n() - offsetX;
            double renderY = (double)block.func_177956_o() - offsetY;
            double renderZ = (double)block.func_177952_p() - offsetZ;
            AxisAlignedBB box = new AxisAlignedBB(renderX, renderY, renderZ, renderX + 1.0, renderY + 1.0, renderZ + 1.0).func_186664_h(0.49);
            double rDist = Utils.getDistanceSq((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)block.func_177958_n(), (double)block.func_177956_o(), (double)block.func_177952_p());
            float colour = 1.0f - (float)rDist / 100.0f;
            if (colour < 0.1f) {
                colour = 0.1f;
            }
            if ((double)(alpha = colour) < 0.15) {
                alpha = 0.15f;
            }
            float r = 0.0f;
            float g = 1.0f;
            float b = 1.0f;
            buffer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72339_c).func_181666_a(r * colour, g * colour, b * colour, alpha).func_181675_d();
            buffer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72334_f).func_181666_a(r * colour, g * colour, b * colour, alpha).func_181675_d();
            buffer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72339_c).func_181666_a(r * colour, g * colour, b * colour, alpha).func_181675_d();
            buffer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72334_f).func_181666_a(r * colour, g * colour, b * colour, alpha).func_181675_d();
            buffer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72334_f).func_181666_a(r * colour, g * colour, b * colour, alpha).func_181675_d();
            buffer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72339_c).func_181666_a(r * colour, g * colour, b * colour, alpha).func_181675_d();
            buffer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72334_f).func_181666_a(r * colour, g * colour, b * colour, alpha).func_181675_d();
            buffer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72339_c).func_181666_a(r * colour, g * colour, b * colour, alpha).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179126_j();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    static {
        previousFOB = 0.0f;
        previousSensitivity = 0.0f;
        bowZoom = false;
        lastTickBowZoom = false;
        tickSet = 0;
        energyCrystalAlphaValue = 0.0f;
        energyCrystalAlphaTarget = 0.0f;
        playerHoldingWrench = false;
        rand = new Random();
        shieldModel = null;
        tickableList = Collections.synchronizedList(new ArrayList());
    }
}

