/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.handler;

import com.brandon3055.brandonscore.client.utils.GuiHelper;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.api.IHudDisplay;
import com.brandon3055.draconicevolution.client.gui.toolconfig.GuiHudConfig;
import com.brandon3055.draconicevolution.handlers.CustomArmorHandler;
import com.brandon3055.draconicevolution.helpers.ResourceHelperDE;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

public class HudHandler {
    private static List<String> hudList = null;
    private static List<String> ltHudList = null;
    private static float toolTipFadeOut = 0.0f;
    private static float armorStatsFadeOut = 0.0f;
    private static boolean showShieldHud = false;
    private static int shieldPercentCharge = 0;
    private static float shieldPoints = 0.0f;
    private static float maxShieldPoints = 0.0f;
    private static float shieldEntropy = 0.0f;
    private static int rfCharge = 0;
    private static long rfTotal = 0L;
    private static int width;
    private static int height;

    public static void drawHUD(RenderGameOverlayEvent.Post event) {
        int y;
        int x;
        Minecraft mc = Minecraft.func_71410_x();
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL || mc.field_71474_y.field_74330_P || mc.field_71462_r instanceof GuiChat) {
            return;
        }
        ScaledResolution resolution = event.getResolution();
        width = resolution.func_78326_a();
        height = resolution.func_78328_b();
        FontRenderer fontRenderer = mc.field_71466_p;
        if (DEConfig.hudSettings[10] == 1 && hudList != null && toolTipFadeOut > 0.0f) {
            x = (int)((float)DEConfig.hudSettings[0] / 1000.0f * (float)width);
            y = (int)((float)DEConfig.hudSettings[1] / 1000.0f * (float)height);
            GuiHelper.drawHoveringTextScaled(hudList, (int)x, (int)y, (FontRenderer)fontRenderer, (float)(toolTipFadeOut > 1.0f ? 1.0f : toolTipFadeOut), (double)((double)DEConfig.hudSettings[4] / 100.0), (int)width, (int)height);
            GlStateManager.func_179140_f();
        }
        if (DEConfig.hudSettings[11] == 1 && showShieldHud) {
            x = (int)((float)DEConfig.hudSettings[2] / 1000.0f * (float)width);
            y = (int)((float)DEConfig.hudSettings[3] / 1000.0f * (float)height);
            HudHandler.drawArmorHUD(x, y, DEConfig.hudSettings[8] == 1, (double)DEConfig.hudSettings[5] / 100.0);
        }
    }

    public static void clientTick() {
        CustomArmorHandler.ArmorSummery summery;
        if (DEConfig.hudSettings[6] > 0 && toolTipFadeOut > 1.0f - (float)DEConfig.hudSettings[6] * 0.25f) {
            toolTipFadeOut -= 0.1f;
        }
        if (!(hudList == null || ltHudList != null && hudList.equals(ltHudList))) {
            toolTipFadeOut = 5.0f;
        }
        if (DEConfig.hudSettings[7] > 0 && armorStatsFadeOut > 1.0f - (float)DEConfig.hudSettings[7] * 0.25f && (armorStatsFadeOut -= 0.1f) < 0.0f) {
            armorStatsFadeOut = 0.0f;
        }
        ltHudList = hudList;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc == null || mc.field_71439_g == null) {
            return;
        }
        hudList = new ArrayList<String>();
        if (mc.field_71462_r != null) {
            if (mc.field_71462_r instanceof GuiHudConfig) {
                hudList.add(I18n.func_135052_a((String)"info.de.hudDisplayConfigTxt1.txt", (Object[])new Object[0]));
                hudList.add("");
                hudList.add("");
                hudList.add("");
                hudList.add(I18n.func_135052_a((String)"info.de.hudDisplayConfigTxt3.txt", (Object[])new Object[0]));
                toolTipFadeOut = 1.0f;
                armorStatsFadeOut = 1.0f;
            }
        } else {
            RayTraceResult traceResult = mc.field_71439_g.func_174822_a(5.0, 0.0f);
            IBlockState state = null;
            if (traceResult != null && traceResult.field_72313_a == RayTraceResult.Type.BLOCK) {
                state = mc.field_71441_e.func_180495_p(traceResult.func_178782_a());
            }
            if (state != null && state.func_177230_c() instanceof IHudDisplay) {
                ((IHudDisplay)state.func_177230_c()).addDisplayData(null, (World)mc.field_71441_e, traceResult.func_178782_a(), hudList);
            } else {
                ItemStack stack = mc.field_71439_g.func_184614_ca();
                if (stack == null || !(stack.func_77973_b() instanceof IHudDisplay)) {
                    stack = mc.field_71439_g.func_184592_cb();
                }
                if (stack != null && stack.func_77973_b() instanceof IHudDisplay) {
                    ((IHudDisplay)stack.func_77973_b()).addDisplayData(stack, (World)mc.field_71441_e, null, hudList);
                }
            }
        }
        if ((summery = new CustomArmorHandler.ArmorSummery().getSummery((EntityPlayer)mc.field_71439_g)) == null) {
            showShieldHud = false;
            return;
        }
        boolean bl = showShieldHud = armorStatsFadeOut > 0.0f;
        if (maxShieldPoints != summery.maxProtectionPoints || shieldPoints != summery.protectionPoints || shieldEntropy != summery.entropy || rfTotal != summery.totalEnergyStored) {
            armorStatsFadeOut = 5.0f;
        }
        maxShieldPoints = summery.maxProtectionPoints;
        shieldPoints = summery.protectionPoints;
        shieldPercentCharge = (int)((double)(summery.protectionPoints / summery.maxProtectionPoints) * 100.0);
        shieldEntropy = summery.entropy;
        rfCharge = (int)((double)summery.totalEnergyStored / Math.max((double)summery.maxTotalEnergyStorage, 1.0) * 100.0);
        rfTotal = summery.totalEnergyStored;
    }

    private static void drawArmorHUD(int x, int y, boolean rotated, double scale) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        ResourceHelperDE.bindTexture("textures/gui/hud.png");
        GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
        GlStateManager.func_179139_a((double)scale, (double)scale, (double)1.0);
        GlStateManager.func_179109_b((float)(-x), (float)(-y), (float)0.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)Math.min(armorStatsFadeOut, 1.0f));
        if (rotated) {
            GuiHelper.drawTexturedRect((double)(x - 15), (double)(y + 1), (double)14.0, (double)16.0, (int)2, (int)0, (int)13, (int)15, (double)0.0, (double)0.0078125);
            GlStateManager.func_179109_b((float)(x += 104), (float)y, (float)0.0f);
            GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)0.0f, (float)-1.0f);
            GlStateManager.func_179109_b((float)(-x), (float)(-y), (float)0.0f);
        } else {
            GuiHelper.drawTexturedRect((double)(x + 1), (double)(y + 105), (double)15.0, (double)17.0, (int)2, (int)0, (int)13, (int)15, (double)0.0, (double)0.0078125);
        }
        GuiHelper.drawTexturedRect((double)x, (double)y, (double)17.0, (double)104.0, (int)0, (int)15, (int)17, (int)104, (double)0.0, (double)0.0078125);
        GuiHelper.drawTexturedRect((double)(x + 2), (double)(y + 2 + (100 - shieldPercentCharge)), (double)7.0, (double)shieldPercentCharge, (int)17, (int)(100 - shieldPercentCharge), (int)7, (int)shieldPercentCharge, (double)0.0, (double)0.0078125);
        GuiHelper.drawTexturedRect((double)(x + 10), (double)(y + 2 + 100 - (int)shieldEntropy), (double)2.0, (double)((int)shieldEntropy), (int)25, (int)(100 - (int)shieldEntropy), (int)2, (int)((int)shieldEntropy), (double)0.0, (double)0.0078125);
        GuiHelper.drawTexturedRect((double)(x + 13), (double)(y + 2 + 100 - rfCharge), (double)2.0, (double)rfCharge, (int)28, (int)(100 - rfCharge), (int)2, (int)rfCharge, (double)0.0, (double)0.0078125);
        if (DEConfig.hudSettings[9] == 1) {
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
            if (rotated) {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)-1.0f);
            }
            GlStateManager.func_179109_b((float)(-x), (float)(-y), (float)0.0f);
            String shield = Math.round(shieldPoints) + "/" + (int)maxShieldPoints;
            String entropy = "EN: " + (int)shieldEntropy + "%";
            String energy = "RF: " + Utils.formatNumber((long)rfTotal);
            float fade = Math.min(armorStatsFadeOut, 1.0f);
            if (!rotated) {
                fontRenderer.func_175063_a(shield, (float)(x + 18), (float)(y + 74), (int)(fade * 240.0f) + 16 << 24 | 0xFFFFFF);
                fontRenderer.func_175063_a(energy, (float)(x + 18), (float)(y + 84), (int)(fade * 240.0f) + 16 << 24 | 0xFFFFFF);
                fontRenderer.func_175063_a(entropy, (float)(x + 18), (float)(y + 94), (int)(fade * 240.0f) + 16 << 24 | 0xFFFFFF);
            } else {
                fontRenderer.func_78276_b(shield, x - 52 - fontRenderer.func_78256_a(shield) / 2, y + 2, (int)(fade * 240.0f) + 16 << 24 | 0xFF);
                fontRenderer.func_175063_a(entropy, (float)(x - fontRenderer.func_78256_a(entropy)), (float)(y + 18), (int)(fade * 240.0f) + 16 << 24 | 0xFFFFFF);
                fontRenderer.func_175063_a(energy, (float)(x - 102), (float)(y + 18), (int)(fade * 240.0f) + 16 << 24 | 0xFFFFFF);
            }
        }
        ResourceHelperDE.bindTexture(ResourceHelperDE.getResourceRAW("minecraft:textures/gui/icons.png"));
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179118_c();
        GlStateManager.func_179121_F();
    }
}

