/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.tile;

import com.brandon3055.brandonscore.client.render.TESRBase;
import com.brandon3055.brandonscore.lib.Vec3I;
import com.brandon3055.brandonscore.network.wrappers.SyncableVec3I;
import com.brandon3055.brandonscore.utils.ModelUtils;
import com.brandon3055.draconicevolution.DEFeatures;
import com.brandon3055.draconicevolution.blocks.machines.EnergyStorageCore;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyStorageCore;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.brandon3055.draconicevolution.helpers.ResourceHelperDE;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;

public class RenderTileEnergyStorageCore
extends TESRBase<TileEnergyStorageCore> {
    private static final double[] SCALES = new double[]{1.1, 1.7, 2.3, 3.6, 5.5, 7.1, 8.6, 10.2};

    public void renderTileEntityAt(TileEnergyStorageCore te, double x, double y, double z, float partialTicks, int destroyStage) {
        if (te.buildGuide.value && MinecraftForgeClient.getRenderPass() == 1) {
            GlStateManager.func_179144_i((int)Minecraft.func_71410_x().func_147117_R().func_110552_b());
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            te.coreStructure.renderTier(te.tier.value);
            GlStateManager.func_179121_F();
        }
        if (!te.active.value) {
            return;
        }
        float rotation = ((float)ClientEventHandler.elapsedTicks + partialTicks) / 2.0f;
        float brightness = (float)Math.abs(Math.sin((float)ClientEventHandler.elapsedTicks / 100.0f) * 100.0);
        double scale = SCALES[te.tier.value - 1];
        double colour = 1.0 - (double)te.getExtendedStorage() / (double)te.getExtendedCapacity();
        float red = 1.0f;
        float green = (float)colour * 0.3f;
        float blue = (float)colour * 0.7f;
        if (te.tier.value == 8) {
            red = 1.0f;
            green = 0.28f;
            blue = 0.05f;
        }
        GlStateManager.func_179144_i((int)Minecraft.func_71410_x().func_147117_R().func_110552_b());
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        if (MinecraftForgeClient.getRenderPass() == 0) {
            GlStateManager.func_179089_o();
            GlStateManager.func_179084_k();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179094_E();
            this.translateScaleTranslate(0.5, scale, scale, scale);
            this.setLighting(80.0f + brightness);
            this.translateRotateTranslate(0.5, rotation, 0.0f, 1.0f, 0.5f);
            List innerQuads = ModelUtils.getModelQuads((IBlockState)DEFeatures.energyStorageCore.func_176223_P().func_177226_a((IProperty)EnergyStorageCore.RENDER_TYPE, (Comparable)Integer.valueOf(1)));
            ModelUtils.renderQuadsRGB((List)innerQuads, (float)red, (float)green, (float)blue);
            GlStateManager.func_179121_F();
            this.setLighting(200.0f);
            this.renderStabilizers(te, false, partialTicks);
        } else {
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            this.setLighting(200.0f);
            this.renderStabilizers(te, true, partialTicks);
            this.translateScaleTranslate(0.5, scale, scale, scale);
            this.translateRotateTranslate(0.5, rotation * 0.5f, 0.0f, -1.0f, -0.5f);
            List outerQuads = ModelUtils.getModelQuads((IBlockState)DEFeatures.energyStorageCore.func_176223_P().func_177226_a((IProperty)EnergyStorageCore.RENDER_TYPE, (Comparable)Integer.valueOf(2)));
            if (te.tier.value == 8) {
                ModelUtils.renderQuadsRGB((List)outerQuads, (float)0.95f, (float)0.45f, (float)0.0f);
            } else {
                ModelUtils.renderQuadsRGB((List)outerQuads, (float)0.2f, (float)1.0f, (float)1.0f);
            }
        }
        GlStateManager.func_179098_w();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179084_k();
        this.resetLighting();
        GlStateManager.func_179121_F();
    }

    public void renderTileEntityFast(TileEnergyStorageCore te, double x, double y, double z, float partialTicks, int destroyStage, VertexBuffer buffer) {
        super.renderTileEntityFast((TileEntity)te, x, y, z, partialTicks, destroyStage, buffer);
    }

    private void renderStabilizers(TileEnergyStorageCore te, boolean renderStage, float partialTick) {
        if (!te.stabilizersOK.value) {
            return;
        }
        for (SyncableVec3I vec3I : te.stabOffsets) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)((double)(-vec3I.vec.x) + 0.5), (double)((double)(-vec3I.vec.y) + 0.5), (double)((double)(-vec3I.vec.z) + 0.5));
            EnumFacing facing = EnumFacing.func_176737_a((float)vec3I.vec.x, (float)vec3I.vec.y, (float)vec3I.vec.z);
            if (facing.func_176740_k() == EnumFacing.Axis.X || facing.func_176740_k() == EnumFacing.Axis.Y) {
                GlStateManager.func_179114_b((float)-90.0f, (float)(-facing.func_96559_d()), (float)facing.func_82601_c(), (float)0.0f);
            } else if (facing == EnumFacing.SOUTH) {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            this.renderStabilizerBeam(te, vec3I.vec, renderStage, partialTick);
            if (te.tier.value >= 5) {
                GlStateManager.func_179152_a((float)1.2f, (float)0.5f, (float)1.2f);
            } else {
                GlStateManager.func_179139_a((double)0.45, (double)0.45, (double)0.45);
            }
            this.renderStabilizer(renderStage, partialTick);
            GlStateManager.func_179121_F();
        }
    }

    private void renderStabilizer(boolean renderStage, float partialTick) {
        IBakedModel bakedModel = ModelUtils.loadBakedModel((ResourceLocation)ResourceHelperDE.getResource("block/obj_models/stabilizer_sphere.obj"));
        List listQuads = bakedModel.func_188616_a(DEFeatures.energyStorageCore.func_176223_P(), null, 0L);
        GlStateManager.func_179144_i((int)Minecraft.func_71410_x().func_147117_R().func_110552_b());
        if (!renderStage) {
            GlStateManager.func_179152_a((float)0.9f, (float)0.9f, (float)0.9f);
            GlStateManager.func_179114_b((float)((float)ClientEventHandler.elapsedTicks + partialTick), (float)0.0f, (float)-1.0f, (float)0.0f);
            ModelUtils.renderQuadsARGB((List)listQuads, (int)-16711681);
        } else {
            GlStateManager.func_179114_b((float)(((float)ClientEventHandler.elapsedTicks + partialTick) * 0.5f), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)1.1f, (float)1.1f, (float)1.1f);
            ModelUtils.renderQuadsARGB((List)listQuads, (int)0x5000FFFF);
        }
    }

    private void renderStabilizerBeam(TileEnergyStorageCore te, Vec3I vec, boolean renderStage, float partialTick) {
        ResourceHelperDE.bindTexture("textures/models/stabilizer_beam.png");
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexBuffer = tessellator.func_178180_c();
        GL11.glPushMatrix();
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        double beamLength = (double)Math.abs(vec.x + vec.y + vec.z) - 0.5;
        float time = (float)ClientEventHandler.elapsedTicks + partialTick;
        double rotation = (double)time * 0.025 * -1.5;
        float beamMotion = -time * 0.2f - (float)MathHelper.func_76141_d((float)(-time * 0.1f));
        if (!renderStage) {
            double scale = 0.2;
            double d7 = 0.5 + Math.cos(rotation + 2.356194490192345) * scale;
            double d9 = 0.5 + Math.sin(rotation + 2.356194490192345) * scale;
            double d11 = 0.5 + Math.cos(rotation + 0.7853981633974483) * scale;
            double d13 = 0.5 + Math.sin(rotation + 0.7853981633974483) * scale;
            double d15 = 0.5 + Math.cos(rotation + 3.9269908169872414) * scale;
            double d17 = 0.5 + Math.sin(rotation + 3.9269908169872414) * scale;
            double d19 = 0.5 + Math.cos(rotation + 5.497787143782138) * scale;
            double d21 = 0.5 + Math.sin(rotation + 5.497787143782138) * scale;
            double texXMin = 0.0;
            double texXMax = 1.0;
            double d28 = -1.0f + beamMotion;
            double texHeight = beamLength * (0.5 / scale) + d28;
            if (te.tier.value >= 5) {
                GlStateManager.func_179139_a((double)3.5, (double)1.0, (double)3.5);
            }
            GlStateManager.func_179137_b((double)-0.5, (double)0.0, (double)-0.5);
            vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            vertexBuffer.func_181662_b(d7, beamLength, d9).func_187315_a(texXMax, texHeight).func_181675_d();
            vertexBuffer.func_181662_b(d7, 0.0, d9).func_187315_a(texXMax, d28).func_181675_d();
            vertexBuffer.func_181662_b(d11, 0.0, d13).func_187315_a(texXMin, d28).func_181675_d();
            vertexBuffer.func_181662_b(d11, beamLength, d13).func_187315_a(texXMin, texHeight).func_181675_d();
            vertexBuffer.func_181662_b(d19, beamLength, d21).func_187315_a(texXMax, texHeight).func_181675_d();
            vertexBuffer.func_181662_b(d19, 0.0, d21).func_187315_a(texXMax, d28).func_181675_d();
            vertexBuffer.func_181662_b(d15, 0.0, d17).func_187315_a(texXMin, d28).func_181675_d();
            vertexBuffer.func_181662_b(d15, beamLength, d17).func_187315_a(texXMin, texHeight).func_181675_d();
            vertexBuffer.func_181662_b(d11, beamLength, d13).func_187315_a(texXMax, texHeight).func_181675_d();
            vertexBuffer.func_181662_b(d11, 0.0, d13).func_187315_a(texXMax, d28).func_181675_d();
            vertexBuffer.func_181662_b(d19, 0.0, d21).func_187315_a(texXMin, d28).func_181675_d();
            vertexBuffer.func_181662_b(d19, beamLength, d21).func_187315_a(texXMin, texHeight).func_181675_d();
            vertexBuffer.func_181662_b(d15, beamLength, d17).func_187315_a(texXMax, texHeight).func_181675_d();
            vertexBuffer.func_181662_b(d15, 0.0, d17).func_187315_a(texXMax, d28).func_181675_d();
            vertexBuffer.func_181662_b(d7, 0.0, d9).func_187315_a(texXMin, d28).func_181675_d();
            vertexBuffer.func_181662_b(d7, beamLength, d9).func_187315_a(texXMin, texHeight).func_181675_d();
            d7 = 0.5 + Math.cos((rotation += (double)0.77f) + 2.356194490192345) * scale;
            d9 = 0.5 + Math.sin(rotation + 2.356194490192345) * scale;
            d11 = 0.5 + Math.cos(rotation + 0.7853981633974483) * scale;
            d13 = 0.5 + Math.sin(rotation + 0.7853981633974483) * scale;
            d15 = 0.5 + Math.cos(rotation + 3.9269908169872414) * scale;
            d17 = 0.5 + Math.sin(rotation + 3.9269908169872414) * scale;
            d19 = 0.5 + Math.cos(rotation + 5.497787143782138) * scale;
            d21 = 0.5 + Math.sin(rotation + 5.497787143782138) * scale;
            d28 = -1.0f + beamMotion * 1.0f;
            texHeight = beamLength * (0.5 / scale) + d28;
            vertexBuffer.func_181662_b(d7, beamLength, d9).func_187315_a(texXMax, texHeight).func_181675_d();
            vertexBuffer.func_181662_b(d7, 0.0, d9).func_187315_a(texXMax, d28).func_181675_d();
            vertexBuffer.func_181662_b(d11, 0.0, d13).func_187315_a(texXMin, d28).func_181675_d();
            vertexBuffer.func_181662_b(d11, beamLength, d13).func_187315_a(texXMin, texHeight).func_181675_d();
            vertexBuffer.func_181662_b(d19, beamLength, d21).func_187315_a(texXMax, texHeight).func_181675_d();
            vertexBuffer.func_181662_b(d19, 0.0, d21).func_187315_a(texXMax, d28).func_181675_d();
            vertexBuffer.func_181662_b(d15, 0.0, d17).func_187315_a(texXMin, d28).func_181675_d();
            vertexBuffer.func_181662_b(d15, beamLength, d17).func_187315_a(texXMin, texHeight).func_181675_d();
            vertexBuffer.func_181662_b(d11, beamLength, d13).func_187315_a(texXMax, texHeight).func_181675_d();
            vertexBuffer.func_181662_b(d11, 0.0, d13).func_187315_a(texXMax, d28).func_181675_d();
            vertexBuffer.func_181662_b(d19, 0.0, d21).func_187315_a(texXMin, d28).func_181675_d();
            vertexBuffer.func_181662_b(d19, beamLength, d21).func_187315_a(texXMin, texHeight).func_181675_d();
            vertexBuffer.func_181662_b(d15, beamLength, d17).func_187315_a(texXMax, texHeight).func_181675_d();
            vertexBuffer.func_181662_b(d15, 0.0, d17).func_187315_a(texXMax, d28).func_181675_d();
            vertexBuffer.func_181662_b(d7, 0.0, d9).func_187315_a(texXMin, d28).func_181675_d();
            vertexBuffer.func_181662_b(d7, beamLength, d9).func_187315_a(texXMin, texHeight).func_181675_d();
        } else {
            int i;
            GlStateManager.func_179114_b((float)90.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)45.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)0.4);
            GlStateManager.func_179132_a((boolean)true);
            int sides = 4;
            float enlarge = 0.35f;
            if (te.tier.value >= 5) {
                sides = 12;
                enlarge = 0.5f + (float)(te.tier.value - 5) * 0.1f;
                GlStateManager.func_179114_b((float)(((float)ClientEventHandler.elapsedTicks + partialTick) * 0.6f), (float)0.0f, (float)0.0f, (float)-1.0f);
                GlStateManager.func_179139_a((double)3.5, (double)3.5, (double)1.0);
            }
            vertexBuffer.func_181668_a(5, DefaultVertexFormats.field_181709_i);
            for (i = 0; i < 4; ++i) {
                vertexBuffer.func_178972_a(i + 1, 255, 255, 255, 32);
            }
            for (i = 0; i <= sides; ++i) {
                float verX = MathHelper.func_76126_a((float)((float)(i % sides) * (float)Math.PI * 2.0f / (float)sides)) * 1.0f;
                float verY = MathHelper.func_76134_b((float)((float)(i % sides) * (float)Math.PI * 2.0f / (float)sides)) * 1.0f;
                vertexBuffer.func_181662_b((double)(verX * 0.35f), (double)(verY * 0.35f), 0.0).func_187315_a((double)i, (double)(beamMotion * 2.0f)).func_181669_b(255, 255, 255, 32).func_181675_d();
                vertexBuffer.func_181662_b((double)verX * (double)enlarge, (double)verY * (double)enlarge, beamLength).func_187315_a((double)i, beamLength + (double)(beamMotion * 2.0f)).func_181669_b(255, 255, 255, 32).func_181675_d();
            }
            GlStateManager.func_179132_a((boolean)false);
        }
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
    }

    public boolean isGlobalRenderer(TileEnergyStorageCore p_188185_1_) {
        return true;
    }
}

