/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.handlers;

import cofh.api.energy.IEnergyContainerItem;
import com.brandon3055.draconicevolution.DEFeatures;
import com.brandon3055.draconicevolution.api.itemconfig.ToolConfigHelper;
import com.brandon3055.draconicevolution.api.itemupgrade.UpgradeHelper;
import com.brandon3055.draconicevolution.entity.EntityCustomArrow;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class BowHandler {
    public static ActionResult<ItemStack> onBowRightClick(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        BowProperties properties = new BowProperties(stack, player);
        if (properties.canFire()) {
            ActionResult ret = ForgeEventFactory.onArrowNock((ItemStack)stack, (World)world, (EntityPlayer)player, (EnumHand)hand, (boolean)true);
            if (ret != null) {
                return ret;
            }
            player.func_184598_c(hand);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public static void onBowUsingTick(ItemStack stack, EntityPlayer player, int count) {
        BowProperties properties = new BowProperties(stack, player);
        int j = 72000 - count;
        if (properties.autoFire && j >= properties.getDrawTicks()) {
            player.func_184597_cx();
        }
    }

    public static void onPlayerStoppedUsingBow(ItemStack stack, World world, EntityPlayer player, int timeLeft) {
        BowProperties properties = new BowProperties(stack, player);
        if (!properties.canFire() || !(stack.func_77973_b() instanceof IEnergyContainerItem)) {
            return;
        }
        int charge = stack.func_77988_m() - timeLeft;
        if ((charge = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)world, (EntityPlayer)player, (int)charge, (boolean)true)) < 0) {
            return;
        }
        float drawArrowSpeedModifier = Math.min((float)charge / (float)properties.getDrawTicks(), 1.0f);
        if ((double)drawArrowSpeedModifier < 0.1) {
            return;
        }
        float velocity = properties.arrowSpeed * drawArrowSpeedModifier * 3.0f;
        EntityCustomArrow customArrow = new EntityCustomArrow(properties, world, (EntityLivingBase)player);
        customArrow.func_184547_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, velocity, 1.0f);
        customArrow.bowProperties = properties;
        if (drawArrowSpeedModifier == 1.0f) {
            customArrow.func_70243_d(true);
        }
        customArrow.field_70251_a = properties.consumeArrowAndEnergy() ? EntityArrow.PickupStatus.ALLOWED : EntityArrow.PickupStatus.CREATIVE_ONLY;
        if (!world.field_72995_K) {
            world.func_72838_d((Entity)customArrow);
        }
        world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 1.0f, 1.0f / (world.field_73012_v.nextFloat() * 0.4f + 1.2f) + (drawArrowSpeedModifier + velocity / 40.0f) * 0.5f);
    }

    public static void enderShot(ItemStack stack, World world, EntityPlayer player, int count, Random itemRand, float pullSpeedModifier, float speedModifier, float soundPitchModifier, int minRelease) {
    }

    public static class BowProperties {
        public ItemStack bow;
        public EntityPlayer player;
        public float arrowDamage = 0.0f;
        public float arrowSpeed = 0.0f;
        public float explosionPower = 0.0f;
        public float shockWavePower = 0.0f;
        public float zoomModifier = 0.0f;
        private int drawTimeReduction = 0;
        public boolean autoFire = false;
        public boolean energyBolt = false;
        public String cantFireMessage = null;

        public BowProperties() {
            this.bow = new ItemStack((Item)DEFeatures.wyvernBow);
            this.player = null;
        }

        public BowProperties(ItemStack bow, EntityPlayer player) {
            this.bow = bow;
            this.player = player;
            this.updateValues();
        }

        public int calculateEnergyCost() {
            this.updateValues();
            double rfCost = 80.0;
            rfCost *= (double)(1.0f + this.arrowDamage);
            rfCost *= (double)((1.0f + this.arrowSpeed) * (1.0f + this.arrowSpeed) * (1.0f + this.arrowSpeed));
            rfCost *= (double)(1.0f + this.explosionPower * 20.0f);
            rfCost *= (double)(1.0f + this.shockWavePower * 10.0f);
            if (this.energyBolt) {
                rfCost *= 30.0;
            }
            return (int)rfCost;
        }

        public boolean canFire() {
            this.updateValues();
            ItemStack ammo = new ItemStack(Items.field_151032_g);
            if (this.player == null) {
                return false;
            }
            if (!(this.bow.func_77973_b() instanceof IEnergyContainerItem)) {
                this.cantFireMessage = "[Error] This bow is not a valid energy container (This is a bug, Please report on the Draconic Evolution github)";
                return false;
            }
            if (!this.energyBolt && this.shockWavePower > 0.0f) {
                this.cantFireMessage = "msg.de.shockWaveForEnergyBoltsOnly.txt";
                return false;
            }
            if (this.energyBolt && this.explosionPower > 0.0f) {
                this.cantFireMessage = "msg.de.explosiveNotForEnergyBolts.txt";
                return false;
            }
            if (this.calculateEnergyCost() > ((IEnergyContainerItem)this.bow.func_77973_b()).getEnergyStored(this.bow) && !this.player.field_71075_bZ.field_75098_d) {
                this.cantFireMessage = "msg.de.insufficientPowerToFire.txt";
                return false;
            }
            if (!(this.energyBolt || this.player.field_71071_by.func_70431_c(ammo) || EnchantmentHelper.func_77506_a((Enchantment)Enchantment.func_180305_b((String)"infinity"), (ItemStack)this.bow) != 0 || this.player.field_71075_bZ.field_75098_d)) {
                this.cantFireMessage = "msg.de.outOfArrows.txt";
                return false;
            }
            this.cantFireMessage = null;
            return true;
        }

        private void updateValues() {
            this.arrowDamage = (float)ToolConfigHelper.getDoubleField("bowArrowDamage", this.bow);
            this.arrowSpeed = 1.0f + (float)ToolConfigHelper.getIntegerField("bowArrowSpeedModifier", this.bow) / 100.0f;
            this.explosionPower = (float)ToolConfigHelper.getDoubleField("bowExplosionPower", this.bow);
            this.shockWavePower = (float)ToolConfigHelper.getDoubleField("bowShockPower", this.bow);
            this.drawTimeReduction = UpgradeHelper.getUpgradeLevel(this.bow, "drawSpeed");
            this.zoomModifier = (float)ToolConfigHelper.getIntegerField("bowZoomModifier", this.bow) / 100.0f;
            this.autoFire = ToolConfigHelper.getBooleanField("bowAutoFire", this.bow);
            this.energyBolt = ToolConfigHelper.getBooleanField("bowFireArrow", this.bow);
        }

        public int getDrawTicks() {
            return Math.max(62 - this.drawTimeReduction * 20, 1);
        }

        public boolean consumeArrowAndEnergy() {
            if (!this.player.field_71075_bZ.field_75098_d) {
                ((IEnergyContainerItem)this.bow.func_77973_b()).extractEnergy(this.bow, this.calculateEnergyCost(), false);
            }
            if (!this.energyBolt && EnchantmentHelper.func_77506_a((Enchantment)Enchantment.func_180305_b((String)"infinity"), (ItemStack)this.bow) == 0 && !this.player.field_71075_bZ.field_75098_d) {
                this.player.field_71071_by.func_184437_d(new ItemStack(Items.field_151032_g));
                return true;
            }
            return false;
        }

        public void writeToNBT(NBTTagCompound compound) {
            compound.func_74776_a("ArrowDamage", this.arrowDamage);
            compound.func_74776_a("ArrowExplosive", this.explosionPower);
            compound.func_74776_a("ArrowShock", this.shockWavePower);
            compound.func_74757_a("ArrowEnergy", this.energyBolt);
        }

        public void readFromNBT(NBTTagCompound compound) {
            this.arrowDamage = compound.func_74760_g("ArrowDamage");
            this.explosionPower = compound.func_74760_g("ArrowExplosive");
            this.shockWavePower = compound.func_74760_g("ArrowShock");
            this.energyBolt = compound.func_74767_n("ArrowEnergy");
        }
    }
}

