/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.handlers;

import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.utils.ItemNBTHelper;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.integration.ModHelper;
import com.brandon3055.draconicevolution.items.armor.DraconicArmor;
import com.brandon3055.draconicevolution.items.armor.ICustomArmor;
import com.brandon3055.draconicevolution.network.PacketShieldHit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class CustomArmorHandler {
    public static final UUID WALK_SPEED_UUID = UUID.fromString("0ea6ce8e-d2e8-11e5-ab30-625662870761");
    private static final DamageSource ADMIN_KILL = new DamageSource("administrative.kill").func_76359_i().func_76348_h().func_151518_m();
    public static Map<EntityPlayer, Boolean> playersWithFlight = new WeakHashMap<EntityPlayer, Boolean>();
    public static List<String> playersWithUphillStep = new ArrayList<String>();

    @SubscribeEvent
    public void onPlayerHurt(LivingHurtEvent event) {
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onPlayerAttacked(LivingAttackEvent event) {
        if (!(event.getEntityLiving() instanceof EntityPlayer) || event.isCanceled()) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        ArmorSummery summery = new ArmorSummery().getSummery(player);
        float hitAmount = ModHelper.applyModDamageAdjustments(summery, event);
        if (CustomArmorHandler.applyArmorDamageBlocking(event, summery)) {
            return;
        }
        if (summery == null || summery.protectionPoints <= 0.0f || event.getSource() == ADMIN_KILL) {
            return;
        }
        event.setCanceled(true);
        if (hitAmount == Float.MAX_VALUE && !event.getSource().field_76373_n.equals(CustomArmorHandler.ADMIN_KILL.field_76373_n)) {
            player.func_70097_a(ADMIN_KILL, Float.MAX_VALUE);
            return;
        }
        if ((float)player.field_70172_ad > (float)player.field_70771_an / 2.0f) {
            return;
        }
        float newEntropy = Math.min(summery.entropy + 1.0f + hitAmount / 20.0f, 100.0f);
        float totalAbsorbed = 0.0f;
        int remainingPoints = 0;
        for (int i = 0; i < summery.allocation.length; ++i) {
            if (summery.allocation[i] == 0.0f) continue;
            ItemStack armorPeace = summery.armorStacks[i];
            float dmgShear = summery.allocation[i] / summery.protectionPoints;
            float dmg = dmgShear * hitAmount;
            float absorbed = Math.min(dmg, summery.allocation[i]);
            totalAbsorbed += absorbed;
            int n = i;
            summery.allocation[n] = summery.allocation[n] - absorbed;
            remainingPoints = (int)((float)remainingPoints + summery.allocation[i]);
            ItemNBTHelper.setFloat((ItemStack)armorPeace, (String)"ProtectionPoints", (float)summery.allocation[i]);
            ItemNBTHelper.setFloat((ItemStack)armorPeace, (String)"ShieldEntropy", (float)newEntropy);
        }
        DraconicEvolution.network.sendToAllAround((IMessage)new PacketShieldHit(player, (float)remainingPoints / summery.maxProtectionPoints), new NetworkRegistry.TargetPoint(player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 64.0));
        if (remainingPoints > 0) {
            player.field_70172_ad = 20;
        } else if (hitAmount - totalAbsorbed > 0.0f) {
            player.func_70097_a(event.getSource(), hitAmount - totalAbsorbed);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onPlayerDeath(LivingDeathEvent event) {
        int i;
        if (!(event.getEntityLiving() instanceof EntityPlayer) || event.isCanceled()) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        ArmorSummery summery = new ArmorSummery().getSummery(player);
        if (summery == null || event.getSource() == ADMIN_KILL) {
            return;
        }
        if (summery.protectionPoints > 500.0f) {
            event.setCanceled(true);
            event.getEntityLiving().func_70606_j(10.0f);
            return;
        }
        if (!summery.hasDraconic) {
            return;
        }
        int[] charge = new int[summery.armorStacks.length];
        int totalCharge = 0;
        for (i = 0; i < summery.armorStacks.length; ++i) {
            if (summery.armorStacks[i] == null) continue;
            charge[i] = ((ICustomArmor)summery.armorStacks[i].func_77973_b()).getEnergyStored(summery.armorStacks[i]);
            totalCharge += charge[i];
        }
        if (totalCharge < 10000000) {
            return;
        }
        for (i = 0; i < summery.armorStacks.length; ++i) {
            if (summery.armorStacks[i] == null) continue;
            ((ICustomArmor)summery.armorStacks[i].func_77973_b()).modifyEnergy(summery.armorStacks[i], -((int)((double)charge[i] / (double)totalCharge * 1.0E7)));
        }
        player.func_146105_b(new TextComponentTranslation("msg.de.shieldDepleted.txt", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_RED)));
        event.setCanceled(true);
        player.func_70606_j(1.0f);
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        ArmorSummery summery = new ArmorSummery().getSummery(player);
        CustomArmorHandler.tickShield(summery, player);
        CustomArmorHandler.tickArmorEffects(summery, player);
    }

    public static void tickShield(ArmorSummery summery, EntityPlayer player) {
        if (summery == null || (double)(summery.maxProtectionPoints - summery.protectionPoints) < 0.01 && summery.entropy == 0.0f || player.field_70170_p.field_72995_K) {
            return;
        }
        float totalPointsToAdd = Math.min(summery.maxProtectionPoints - summery.protectionPoints, summery.maxProtectionPoints / 60.0f);
        totalPointsToAdd *= 1.0f - summery.entropy / 100.0f;
        if ((totalPointsToAdd = Math.min(totalPointsToAdd, (float)(summery.totalEnergyStored / 1000L))) < 0.0f) {
            totalPointsToAdd = 0.0f;
        }
        summery.entropy -= summery.meanRecoveryPoints / 100.0f;
        if (summery.entropy < 0.0f) {
            summery.entropy = 0.0f;
        }
        for (int i = 0; i < summery.armorStacks.length; ++i) {
            ItemStack stack = summery.armorStacks[i];
            if (stack == null || summery.totalEnergyStored <= 0L) continue;
            float maxForPeace = ((ICustomArmor)stack.func_77973_b()).getProtectionPoints(stack);
            int energyAmount = ((ICustomArmor)summery.armorStacks[i].func_77973_b()).getEnergyPerProtectionPoint();
            ((ICustomArmor)stack.func_77973_b()).modifyEnergy(stack, -((int)((double)summery.energyAllocation[i] / (double)summery.totalEnergyStored * (double)(totalPointsToAdd * (float)energyAmount))));
            float pointsForPeace = summery.pointsDown[i] / Math.max(1.0f, summery.maxProtectionPoints - summery.protectionPoints) * totalPointsToAdd;
            int n = i;
            summery.allocation[n] = summery.allocation[n] + pointsForPeace;
            if (summery.allocation[i] > maxForPeace || maxForPeace - summery.allocation[i] < 0.1f) {
                summery.allocation[i] = maxForPeace;
            }
            ItemNBTHelper.setFloat((ItemStack)stack, (String)"ProtectionPoints", (float)summery.allocation[i]);
            if (player.field_70172_ad > 0) continue;
            ItemNBTHelper.setFloat((ItemStack)stack, (String)"ShieldEntropy", (float)summery.entropy);
        }
    }

    public static void tickArmorEffects(ArmorSummery summery, EntityPlayer player) {
        if (DEConfig.enableFlight) {
            if (summery != null && summery.flight[0]) {
                playersWithFlight.put(player, true);
                player.field_71075_bZ.field_75101_c = true;
                if (summery.flight[1]) {
                    player.field_71075_bZ.field_75100_b = true;
                }
                if (player.field_70170_p.field_72995_K) {
                    CustomArmorHandler.setPlayerFlySpeed(player, 0.05f + 0.05f * summery.flightSpeedModifier);
                }
                if (!player.field_70122_E && player.field_71075_bZ.field_75100_b && player.field_70181_x != 0.0 && summery.flightVModifier > 0.0f) {
                    if (BrandonsCore.proxy.isJumpKeyDown() && !BrandonsCore.proxy.isSneakKeyDown()) {
                        player.field_70181_x = 0.225f * summery.flightVModifier;
                    }
                    if (BrandonsCore.proxy.isSneakKeyDown() && !BrandonsCore.proxy.isJumpKeyDown()) {
                        player.field_70181_x = -0.225f * summery.flightVModifier;
                    }
                }
                if (summery.flight[2] && player.field_70701_bs == 0.0f && player.field_70702_br == 0.0f && player.field_71075_bZ.field_75100_b) {
                    player.field_70159_w *= 0.5;
                    player.field_70179_y *= 0.5;
                }
            } else {
                if (!playersWithFlight.containsKey(player)) {
                    playersWithFlight.put(player, false);
                }
                if (playersWithFlight.get(player).booleanValue() && !player.field_70170_p.field_72995_K) {
                    playersWithFlight.put(player, false);
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.field_71075_bZ.field_75101_c = false;
                        player.field_71075_bZ.field_75100_b = false;
                        player.func_71016_p();
                    }
                }
                if (player.field_70170_p.field_72995_K && playersWithFlight.get(player).booleanValue()) {
                    playersWithFlight.put(player, false);
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.field_71075_bZ.field_75101_c = false;
                        player.field_71075_bZ.field_75100_b = false;
                    }
                    CustomArmorHandler.setPlayerFlySpeed(player, 0.05f);
                }
            }
        }
        IAttribute speedAttr = SharedMonsterAttributes.field_111263_d;
        if (summery != null && summery.speedModifier > 0.0f) {
            double value = summery.speedModifier;
            if (player.func_110148_a(speedAttr).func_111127_a(WALK_SPEED_UUID) == null) {
                player.func_110148_a(speedAttr).func_111121_a(new AttributeModifier(WALK_SPEED_UUID, speedAttr.func_111108_a(), value, 1));
            } else if (player.func_110148_a(speedAttr).func_111127_a(WALK_SPEED_UUID).func_111164_d() != value) {
                player.func_110148_a(speedAttr).func_111124_b(player.func_110148_a(speedAttr).func_111127_a(WALK_SPEED_UUID));
                player.func_110148_a(speedAttr).func_111121_a(new AttributeModifier(WALK_SPEED_UUID, speedAttr.func_111108_a(), value, 1));
            }
            if (!player.field_70122_E && player.func_184187_bx() == null) {
                player.field_70747_aH = 0.02f + 0.02f * summery.speedModifier;
            }
        } else if (player.func_110148_a(speedAttr).func_111127_a(WALK_SPEED_UUID) != null) {
            player.func_110148_a(speedAttr).func_111124_b(player.func_110148_a(speedAttr).func_111127_a(WALK_SPEED_UUID));
        }
        if (summery != null && player.field_70170_p.field_72995_K) {
            boolean highStepListed = playersWithUphillStep.contains(player.getDisplayNameString()) && player.field_70138_W >= 1.0f;
            boolean hasHighStep = summery.hasHillStep;
            if (hasHighStep && !highStepListed) {
                playersWithUphillStep.add(player.getDisplayNameString());
                player.field_70138_W = 1.0f;
            }
            if (!hasHighStep && highStepListed) {
                playersWithUphillStep.remove(player.getDisplayNameString());
                player.field_70138_W = 0.5f;
            }
        }
    }

    private static void setPlayerFlySpeed(EntityPlayer player, float speed) {
        player.field_71075_bZ.func_75092_a(speed);
    }

    private static boolean applyArmorDamageBlocking(LivingAttackEvent event, ArmorSummery summery) {
        if (summery == null) {
            return false;
        }
        if (event.getSource().func_76347_k() && summery.fireResistance >= 1.0f) {
            event.setCanceled(true);
            event.getEntityLiving().func_70066_B();
            return true;
        }
        if (event.getSource().field_76373_n.equals("fall") && summery.jumpModifier > 0.0f) {
            if (event.getAmount() < summery.jumpModifier * 5.0f) {
                event.setCanceled(true);
            }
            return true;
        }
        if ((event.getSource().field_76373_n.equals("inWall") || event.getSource().field_76373_n.equals("drown")) && summery.armorStacks[3] != null) {
            if (event.getAmount() <= 2.0f) {
                event.setCanceled(true);
            }
            return true;
        }
        return false;
    }

    public static class ArmorSummery {
        public float maxProtectionPoints = 0.0f;
        public float protectionPoints = 0.0f;
        public int peaces = 0;
        public float[] allocation;
        public float[] pointsDown;
        public ItemStack[] armorStacks;
        public float entropy = 0.0f;
        public float meanRecoveryPoints = 0.0f;
        public long totalEnergyStored = 0L;
        public long maxTotalEnergyStorage = 0L;
        public int[] energyAllocation;
        public boolean[] flight = new boolean[]{false, false, false};
        public float flightVModifier = 0.0f;
        public float speedModifier = 0.0f;
        public float jumpModifier = 0.0f;
        public float fireResistance = 0.0f;
        public float flightSpeedModifier = 0.0f;
        public boolean hasHillStep = false;
        public boolean hasDraconic = false;

        public ArmorSummery getSummery(EntityPlayer player) {
            ItemStack[] armorSlots = player.field_71071_by.field_70460_b;
            float totalEntropy = 0.0f;
            float totalRecoveryPoints = 0.0f;
            this.allocation = new float[armorSlots.length];
            this.armorStacks = new ItemStack[armorSlots.length];
            this.pointsDown = new float[armorSlots.length];
            this.energyAllocation = new int[armorSlots.length];
            block5: for (int i = 0; i < armorSlots.length; ++i) {
                ItemStack stack = armorSlots[i];
                if (stack == null || !(stack.func_77973_b() instanceof ICustomArmor)) continue;
                ICustomArmor armor = (ICustomArmor)stack.func_77973_b();
                ++this.peaces;
                this.allocation[i] = ItemNBTHelper.getFloat((ItemStack)stack, (String)"ProtectionPoints", (float)0.0f);
                this.protectionPoints += this.allocation[i];
                totalEntropy += ItemNBTHelper.getFloat((ItemStack)stack, (String)"ShieldEntropy", (float)0.0f);
                this.armorStacks[i] = stack;
                totalRecoveryPoints += armor.getRecoveryRate(stack);
                float maxPoints = armor.getProtectionPoints(stack);
                this.pointsDown[i] = maxPoints - this.allocation[i];
                this.maxProtectionPoints += maxPoints;
                this.energyAllocation[i] = armor.getEnergyStored(stack);
                this.totalEnergyStored += (long)this.energyAllocation[i];
                this.maxTotalEnergyStorage += (long)armor.getMaxEnergyStored(stack);
                if (stack.func_77973_b() instanceof DraconicArmor) {
                    this.hasDraconic = true;
                }
                this.fireResistance += armor.getFireResistance(stack);
                switch (i) {
                    case 2: {
                        this.flight = armor.hasFlight(stack);
                        if (!this.flight[0]) continue block5;
                        this.flightVModifier = armor.getFlightVModifier(stack, player);
                        this.flightSpeedModifier = armor.getFlightSpeedModifier(stack, player);
                        continue block5;
                    }
                    case 1: {
                        this.speedModifier = armor.getSpeedModifier(stack, player);
                        continue block5;
                    }
                    case 0: {
                        this.hasHillStep = armor.hasHillStep(stack, player);
                        this.jumpModifier = armor.getJumpModifier(stack, player);
                    }
                }
            }
            if (this.peaces == 0) {
                return null;
            }
            this.entropy = totalEntropy / (float)this.peaces;
            this.meanRecoveryPoints = totalRecoveryPoints / (float)this.peaces;
            return this;
        }
    }
}

