/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.integration.jei;

import com.brandon3055.brandonscore.client.utils.GuiHelper;
import com.brandon3055.draconicevolution.api.fusioncrafting.IFusionRecipe;
import com.brandon3055.draconicevolution.helpers.ResourceHelperDE;
import com.brandon3055.draconicevolution.integration.jei.FusionRecipeWrapper;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;

public class FusionRecipeCategory
extends BlankRecipeCategory {
    private final IDrawable background;
    private final String localizedName;
    private int xSize = 164;
    private int ySize = 111;
    private IFusionRecipe recipeCache = null;

    public FusionRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(ResourceHelperDE.getResource("textures/gui/jei_fusion_background.png"), 0, 0, this.xSize, this.ySize);
        this.localizedName = I18n.func_135052_a((String)"gui.de.fusionCraftingCore.name", (Object[])new Object[0]);
    }

    @Nonnull
    public String getUid() {
        return "DraconicEvolution.Fusion";
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayout recipeLayout, IRecipeWrapper recipeWrapper, IIngredients ingredients) {
        if (!(recipeWrapper instanceof FusionRecipeWrapper)) {
            return;
        }
        FusionRecipeWrapper recipe = (FusionRecipeWrapper)recipeWrapper;
        this.recipeCache = recipe.recipe;
        IGuiItemStackGroup stackGroup = recipeLayout.getItemStacks();
        stackGroup.init(0, true, this.xSize / 2 - 9, this.ySize / 2 - 9 - 23);
        stackGroup.init(1, false, this.xSize / 2 - 9, this.ySize / 2 - 9 + 23);
        int centerX = this.xSize / 2;
        int centerY = this.ySize / 2;
        for (int i = 0; i < recipe.recipe.getRecipeIngredients().size(); ++i) {
            int yPos;
            int sideIndex;
            int ySize;
            int xPos;
            boolean isLeft = i % 2 == 0;
            boolean isOdd = recipe.recipe.getRecipeIngredients().size() % 2 == 1;
            int sideCount = recipe.recipe.getRecipeIngredients().size() / 2;
            if (isOdd && !isLeft) {
                --sideCount;
            }
            if (isLeft) {
                xPos = centerX - 65;
                ySize = 80 / Math.max(sideCount - (isOdd ? 0 : 1), 1);
                sideIndex = i / 2;
                if (!(sideCount > 1 || isOdd && recipe.recipe.getRecipeIngredients().size() != 1)) {
                    sideIndex = 1;
                    ySize = 40;
                }
                yPos = centerY - 40 + sideIndex * ySize;
            } else {
                xPos = centerX + 63;
                ySize = 80 / Math.max(sideCount - (isOdd ? 0 : 1), 1);
                sideIndex = i / 2;
                if (isOdd) {
                    ++sideCount;
                }
                if (sideCount <= 1) {
                    sideIndex = 1;
                    ySize = 40;
                }
                yPos = centerY - 40 + sideIndex * ySize;
            }
            stackGroup.init(i + 2, true, xPos - 8, yPos - 8);
        }
        stackGroup.set(ingredients);
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        GuiHelper.drawBorderedRect((int)8, (int)6, (int)20, (int)100, (int)1, (int)-16777216, (int)-5635841);
        GuiHelper.drawBorderedRect((int)(this.xSize - 28), (int)6, (int)20, (int)100, (int)1, (int)-16777216, (int)-5635841);
        GuiHelper.drawBorderedRect((int)(this.xSize / 2 - 10), (int)22, (int)20, (int)66, (int)1, (int)-16777216, (int)-16711681);
    }
}

