/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.tools;

import com.brandon3055.draconicevolution.api.itemconfig.DoubleConfigField;
import com.brandon3055.draconicevolution.api.itemconfig.IItemConfigField;
import com.brandon3055.draconicevolution.api.itemconfig.ItemConfigFieldRegistry;
import com.brandon3055.draconicevolution.api.itemconfig.ToolConfigHelper;
import com.brandon3055.draconicevolution.api.itemupgrade.UpgradeHelper;
import com.brandon3055.draconicevolution.items.tools.IAOEWeapon;
import com.brandon3055.draconicevolution.items.tools.MiningToolBase;
import com.brandon3055.draconicevolution.items.tools.ToolStats;
import java.util.List;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;

public class DraconicStaffOfPower
extends MiningToolBase
implements IAOEWeapon {
    public DraconicStaffOfPower() {
        super(ToolStats.DRA_STAFF_ATTACK_DAMAGE, ToolStats.DRA_STAFF_ATTACK_SPEED, PICKAXE_OVERRIDES);
        this.baseMiningSpeed = (float)ToolStats.DRA_STAFF_MINING_SPEED;
        this.baseAOE = ToolStats.BASE_DRACONIC_MINING_AOE + 1;
        this.setEnergyStats(ToolStats.DRACONIC_BASE_CAPACITY * 3, 16000000, 0);
        this.setHarvestLevel("pickaxe", 10);
        this.setHarvestLevel("axe", 10);
        this.setHarvestLevel("shovel", 10);
    }

    @Override
    public List<String> getValidUpgrades(ItemStack stack) {
        List<String> list = super.getValidUpgrades(stack);
        list.add("attackDmg");
        list.add("attackAOE");
        return list;
    }

    @Override
    public int getMaxUpgradeLevel(ItemStack stack, String upgrade) {
        return 3;
    }

    @Override
    public int getToolTier(ItemStack stack) {
        return 2;
    }

    @Override
    public boolean checkEnchantTypeValid(EnumEnchantmentType type) {
        return super.checkEnchantTypeValid(type) || type == EnumEnchantmentType.WEAPON;
    }

    @Override
    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        return super.onBlockStartBreak(itemstack, pos, player);
    }

    protected double getMaxAttackAOE(ItemStack stack) {
        int level = UpgradeHelper.getUpgradeLevel(stack, "attackAOE");
        if (level == 0) {
            return 3.0;
        }
        if (level == 1) {
            return 4.0;
        }
        if (level == 2) {
            return 6.0;
        }
        if (level == 3) {
            return 9.0;
        }
        if (level == 4) {
            return 15.0;
        }
        return 0.0;
    }

    @Override
    public ItemConfigFieldRegistry getFields(ItemStack stack, ItemConfigFieldRegistry registry) {
        registry.register(stack, new DoubleConfigField("attackAOE", this.getMaxAttackAOE(stack), 0.0, this.getMaxAttackAOE(stack), "config.field.attackAOE.description", IItemConfigField.EnumControlType.SLIDER));
        return super.getFields(stack, registry);
    }

    @Override
    public double getWeaponAOE(ItemStack stack) {
        return ToolConfigHelper.getDoubleField("attackAOE", stack);
    }
}

