/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.tools;

import codechicken.lib.model.ModelRegistryHelper;
import codechicken.lib.model.SimpleOverrideBakedModel;
import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.api.IFOVModifierItem;
import com.brandon3055.brandonscore.config.Feature;
import com.brandon3055.brandonscore.utils.InfoHelper;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.api.itemconfig.BooleanConfigField;
import com.brandon3055.draconicevolution.api.itemconfig.DoubleConfigField;
import com.brandon3055.draconicevolution.api.itemconfig.IItemConfigField;
import com.brandon3055.draconicevolution.api.itemconfig.IntegerConfigField;
import com.brandon3055.draconicevolution.api.itemconfig.ItemConfigFieldRegistry;
import com.brandon3055.draconicevolution.api.itemconfig.ToolConfigHelper;
import com.brandon3055.draconicevolution.api.itemupgrade.UpgradeHelper;
import com.brandon3055.draconicevolution.client.model.tool.BowModelOverrideList;
import com.brandon3055.draconicevolution.handlers.BowHandler;
import com.brandon3055.draconicevolution.items.tools.ToolBase;
import com.brandon3055.draconicevolution.items.tools.ToolStats;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WyvernBow
extends ToolBase
implements IFOVModifierItem {
    public WyvernBow(float attackDamage, float attackSpeed) {
        super(attackDamage, attackSpeed);
    }

    public WyvernBow() {
        super(1.0, 0.0);
        this.setEnergyStats(ToolStats.WYVERN_BASE_CAPACITY, 512000, 0);
    }

    private ItemStack findAmmo(EntityPlayer player) {
        if (this.isArrow(player.func_184586_b(EnumHand.OFF_HAND))) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (this.isArrow(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!this.isArrow(itemstack)) continue;
            return itemstack;
        }
        return null;
    }

    protected boolean isArrow(@Nullable ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof ItemArrow;
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase entityLiving, int timeLeft) {
        if (entityLiving instanceof EntityPlayer) {
            BowHandler.onPlayerStoppedUsingBow(stack, world, (EntityPlayer)entityLiving, timeLeft);
        }
    }

    public static float getArrowVelocity(int charge) {
        float f = (float)charge / 20.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        return BowHandler.onBowRightClick(stack, world, player, hand);
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase entityLivingBase, int count) {
        if (entityLivingBase instanceof EntityPlayer) {
            BowHandler.onBowUsingTick(stack, (EntityPlayer)entityLivingBase, count);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerRenderer(Feature feature) {
        this.modelLocation = new ModelResourceLocation("draconicevolution:" + feature.registryName(), "inventory");
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)this.modelLocation);
        ModelRegistryHelper.register((ModelResourceLocation)new ModelResourceLocation("draconicevolution:" + feature.registryName(), "inventory"), (IBakedModel)new SimpleOverrideBakedModel((ItemOverrideList)new BowModelOverrideList()));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addDisplayData(@Nullable ItemStack stack, World world, @Nullable BlockPos pos, List<String> displayList) {
        super.addDisplayData(stack, world, pos, displayList);
        if (BrandonsCore.proxy.getClientPlayer() != null) {
            BowHandler.BowProperties properties = new BowHandler.BowProperties(stack, BrandonsCore.proxy.getClientPlayer());
            displayList.add(InfoHelper.ITC() + I18n.func_135052_a((String)"gui.de.rfPerShot.txt", (Object[])new Object[0]) + ": " + InfoHelper.HITC() + Utils.addCommas((int)properties.calculateEnergyCost()));
            if (!properties.canFire() && properties.cantFireMessage != null) {
                displayList.add(TextFormatting.DARK_RED + I18n.func_135052_a((String)properties.cantFireMessage, (Object[])new Object[0]));
            }
        }
    }

    @Override
    public ItemConfigFieldRegistry getFields(ItemStack stack, ItemConfigFieldRegistry registry) {
        double maxDamage = 2 + UpgradeHelper.getUpgradeLevel(stack, "arrowDmg") * 2;
        int maxSpeed = 100 + UpgradeHelper.getUpgradeLevel(stack, "arrowSpeed") * 100;
        registry.register(stack, new DoubleConfigField("bowArrowDamage", 2.0, 0.0, maxDamage, "config.field.bowArrowDamage.description", IItemConfigField.EnumControlType.SLIDER));
        registry.register(stack, new IntegerConfigField("bowArrowSpeedModifier", 0, 0, maxSpeed, "config.field.bowArrowSpeedModifier.description", IItemConfigField.EnumControlType.SLIDER).setPrefix("+").setExtension("%"));
        registry.register(stack, new BooleanConfigField("bowAutoFire", false, "config.field.bowAutoFire.description"));
        registry.register(stack, new DoubleConfigField("bowExplosionPower", 0.0, 0.0, 4.0, "config.field.bowExplosionPower.description", IItemConfigField.EnumControlType.SLIDER));
        registry.register(stack, new IntegerConfigField("bowZoomModifier", 0, 0, (int)(this.getMaxZoomModifier(stack) * 100.0f), "config.field.bowZoomModifier.description", IItemConfigField.EnumControlType.SLIDER));
        return super.getFields(stack, registry);
    }

    public float getMaxZoomModifier(ItemStack stack) {
        return 3.0f;
    }

    @Override
    public List<String> getValidUpgrades(ItemStack stack) {
        List<String> list = super.getValidUpgrades(stack);
        list.add("arrowDmg");
        list.add("arrowSpeed");
        list.add("drawSpeed");
        return list;
    }

    @Override
    public int getMaxUpgradeLevel(ItemStack stack, String upgrade) {
        return 2;
    }

    public boolean checkEnchantTypeValid(EnumEnchantmentType type) {
        return type == EnumEnchantmentType.BOW || type == EnumEnchantmentType.ALL;
    }

    @Override
    public int getToolTier(ItemStack stack) {
        return 0;
    }

    public float getNewFOV(EntityPlayer player, ItemStack stack, float currentFOV, float originalFOV, EntityEquipmentSlot slot) {
        float zoom = (float)(10 + ToolConfigHelper.getIntegerField("bowZoomModifier", stack)) / 605.0f;
        if (player.func_184607_cu() == stack) {
            if (currentFOV > 1.5f) {
                currentFOV = 1.5f;
            }
            return currentFOV - zoom;
        }
        return currentFOV;
    }
}

