/*
 * Decompiled with CFR 0.152.
 */
package sonar.core;

import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sonar.core.SonarBlocks;
import sonar.core.SonarCrafting;
import sonar.core.SonarEvents;
import sonar.core.api.SonarAPI;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.common.block.SonarBlockTip;
import sonar.core.energy.DischargeValues;
import sonar.core.helpers.NBTHelper;
import sonar.core.integration.SonarLoader;
import sonar.core.integration.SonarWailaModule;
import sonar.core.integration.planting.FertiliserRegistry;
import sonar.core.integration.planting.HarvesterRegistry;
import sonar.core.integration.planting.PlanterRegistry;
import sonar.core.network.FlexibleGuiHandler;
import sonar.core.network.PacketBlockInteraction;
import sonar.core.network.PacketByteBuf;
import sonar.core.network.PacketByteBufMultipart;
import sonar.core.network.PacketFlexibleContainer;
import sonar.core.network.PacketFlexibleOpenGui;
import sonar.core.network.PacketInvUpdate;
import sonar.core.network.PacketMultipartSync;
import sonar.core.network.PacketRequestSync;
import sonar.core.network.PacketSonarSides;
import sonar.core.network.PacketStackUpdate;
import sonar.core.network.PacketTileSync;
import sonar.core.network.PacketTileSyncUpdate;
import sonar.core.network.SonarCommon;
import sonar.core.network.utils.ByteBufWritable;
import sonar.core.network.utils.IByteBufTile;
import sonar.core.registries.EnergyContainerHandlerRegistry;
import sonar.core.registries.EnergyProviderRegistry;
import sonar.core.registries.EnergyTypeRegistry;
import sonar.core.registries.FluidProviderRegistry;
import sonar.core.registries.ISonarRegistryBlock;
import sonar.core.registries.ISonarRegistryItem;
import sonar.core.registries.InventoryProviderRegistry;
import sonar.core.upgrades.MachineUpgradeRegistry;

@Mod(modid="SonarCore", name="SonarCore", version="3.1.6", acceptedMinecraftVersions="[1.9.4]")
public class SonarCore {
    public static final String modid = "SonarCore";
    public static final String version = "3.1.6";
    @SidedProxy(clientSide="sonar.core.network.SonarClient", serverSide="sonar.core.network.SonarCommon")
    public static SonarCommon proxy;
    @Mod.Instance(value="SonarCore")
    public static SonarCore instance;
    public static InventoryProviderRegistry inventoryProviders;
    public static FluidProviderRegistry fluidProviders;
    public static EnergyProviderRegistry energyProviders;
    public static EnergyContainerHandlerRegistry energyContainerHandlers;
    public static EnergyTypeRegistry energyTypes;
    public static MachineUpgradeRegistry machineUpgrades;
    public static SimpleNetworkWrapper network;
    public FlexibleGuiHandler guiHandler = new FlexibleGuiHandler();
    public static PlanterRegistry planters;
    public static HarvesterRegistry harvesters;
    public static FertiliserRegistry fertilisers;
    public static Logger logger;
    public static Block reinforcedStoneBlock;
    public static Block reinforcedStoneBrick;
    public static Block reinforcedDirtBlock;
    public static Block reinforcedDirtBrick;
    public static Block stableGlass;
    public static Block clearStableGlass;
    public static Block[] stableStone;
    public static Block[] stablestonerimmedBlock;
    public static Block[] stablestonerimmedblackBlock;
    public static Block reinforcedStoneStairs;
    public static Block reinforcedStoneBrickStairs;
    public static Block reinforcedDirtStairs;
    public static Block reinforcedDirtBrickStairs;
    public static Block reinforcedStoneFence;
    public static Block reinforcedStoneBrickFence;
    public static Block reinforcedDirtFence;
    public static Block reinforcedDirtBrickFence;
    public static Block reinforcedStoneGate;
    public static Block reinforcedStoneBrickGate;
    public static Block reinforcedDirtGate;
    public static Block reinforcedDirtBrickGate;
    public static Block reinforcedStoneSlab_half;
    public static Block reinforcedStoneBrickSlab_half;
    public static Block reinforcedDirtSlab_half;
    public static Block reinforcedDirtBrickSlab_half;
    public static Block reinforcedStoneSlab_double;
    public static Block reinforcedStoneBrickSlab_double;
    public static Block reinforcedDirtSlab_double;
    public static Block reinforcedDirtBrickSlab_double;
    public static final Random rand;
    public static CreativeTabs tab;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger.info("Initilising API");
        SonarAPI.init();
        logger.info("Initilised API");
        logger.info("Registering Blocks");
        SonarBlocks.registerBlocks();
        logger.info("Loaded Blocks");
        logger.info("Registering Crafting Recipes");
        SonarCrafting.registerCraftingRecipes();
        logger.info("Register Crafting Recipes");
        logger.info("Registering Renderers");
        proxy.registerRenderThings();
        logger.info("Registered Renderers");
        for (int i = 0; i < 16; ++i) {
            OreDictionary.registerOre((String)"sonarStableStone", (Block)stableStone[i]);
            OreDictionary.registerOre((String)"sonarStableStone", (Block)stablestonerimmedBlock[i]);
            OreDictionary.registerOre((String)"sonarStableStone", (Block)stablestonerimmedblackBlock[i]);
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        logger.info("Checking Loaded Mods");
        SonarLoader.initLoader();
        logger.info("Registering Packets");
        this.registerPackets();
        logger.info("Register Packets");
        if (SonarLoader.wailaLoaded) {
            SonarWailaModule.register();
            logger.info("Integrated with WAILA");
        } else {
            logger.warn("'WAILA' - unavailable or disabled in config");
        }
        MinecraftForge.EVENT_BUS.register((Object)new SonarEvents());
        logger.info("Registered Events");
        energyTypes.register();
        inventoryProviders.register();
        fluidProviders.register();
        energyProviders.register();
        energyContainerHandlers.register();
        machineUpgrades.register();
        planters.register();
        harvesters.register();
        fertilisers.register();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        logger.info("Adding Discharge Values");
        DischargeValues.addValues();
        logger.info("Added " + DischargeValues.dischargeList.size() + " Discharge Values");
        for (Map.Entry<ItemStack, Integer> entry : DischargeValues.dischargeList.entrySet()) {
            logger.info("Discharge Values: " + entry.toString());
        }
        logger.info("Registered " + energyTypes.getObjects().size() + " Energy Types");
        logger.info("Registered " + inventoryProviders.getObjects().size() + " Inventory Providers");
        logger.info("Registered " + fluidProviders.getObjects().size() + " Fluid Providers");
        logger.info("Registered " + energyProviders.getObjects().size() + " Energy Providers");
        logger.info("Registered " + energyContainerHandlers.getObjects().size() + " Energy Container Providers");
        logger.info("Registered " + machineUpgrades.getMap().size() + " Machine Upgrades");
    }

    private void registerPackets() {
        if (network == null) {
            network = NetworkRegistry.INSTANCE.newSimpleChannel("Sonar-Packets");
            network.registerMessage(PacketTileSync.Handler.class, PacketTileSync.class, 0, Side.CLIENT);
            network.registerMessage(PacketSonarSides.Handler.class, PacketSonarSides.class, 1, Side.CLIENT);
            network.registerMessage(PacketRequestSync.Handler.class, PacketRequestSync.class, 2, Side.SERVER);
            network.registerMessage(PacketByteBuf.Handler.class, PacketByteBuf.class, 4, Side.CLIENT);
            network.registerMessage(PacketByteBuf.Handler.class, PacketByteBuf.class, 5, Side.SERVER);
            network.registerMessage(PacketBlockInteraction.Handler.class, PacketBlockInteraction.class, 6, Side.SERVER);
            network.registerMessage(PacketStackUpdate.Handler.class, PacketStackUpdate.class, 7, Side.CLIENT);
            network.registerMessage(PacketInvUpdate.Handler.class, PacketInvUpdate.class, 8, Side.CLIENT);
            network.registerMessage(PacketTileSyncUpdate.Handler.class, PacketTileSyncUpdate.class, 9, Side.CLIENT);
            if (SonarLoader.mcmultipartLoaded) {
                network.registerMessage(PacketMultipartSync.Handler.class, PacketMultipartSync.class, 10, Side.CLIENT);
                network.registerMessage(PacketByteBufMultipart.Handler.class, PacketByteBufMultipart.class, 11, Side.CLIENT);
                network.registerMessage(PacketByteBufMultipart.Handler.class, PacketByteBufMultipart.class, 12, Side.SERVER);
            }
            network.registerMessage(PacketFlexibleOpenGui.Handler.class, PacketFlexibleOpenGui.class, 13, Side.CLIENT);
            network.registerMessage(PacketFlexibleContainer.Handler.class, PacketFlexibleContainer.class, 14, Side.CLIENT);
            network.registerMessage(PacketFlexibleContainer.Handler.class, PacketFlexibleContainer.class, 15, Side.SERVER);
        }
    }

    public static void registerItems(ArrayList<ISonarRegistryItem> items) {
        for (ISonarRegistryItem item : items) {
            Item toRegister = item.getItem();
            GameRegistry.register((IForgeRegistryEntry)(toRegister.getRegistryName() == null ? (Item)toRegister.setRegistryName(item.getRegistryName()) : toRegister));
            item.setItem(toRegister);
        }
    }

    public static void registerBlocks(ArrayList<ISonarRegistryBlock> blocks) {
        for (ISonarRegistryBlock block : blocks) {
            Block toRegister = block.getBlock();
            GameRegistry.register((IForgeRegistryEntry)(toRegister.getRegistryName() == null ? (Block)toRegister.setRegistryName(block.getRegistryName()) : toRegister));
            GameRegistry.register((IForgeRegistryEntry)new SonarBlockTip(toRegister).setRegistryName(block.getRegistryName()));
            block.setBlock(toRegister);
            if (!block.hasTileEntity()) continue;
            GameRegistry.registerTileEntity(block.getTileEntity(), (String)block.getRegistryName());
        }
    }

    public static void sendPacketAround(TileEntity tile, int spread, int id) {
        if (tile != null && tile instanceof IByteBufTile) {
            if (!tile.func_145831_w().field_72995_K) {
                network.sendToAllAround((IMessage)new PacketByteBuf((IByteBufTile)tile, tile.func_174877_v(), id, new ByteBufWritable[0]), new NetworkRegistry.TargetPoint(tile.func_145831_w().field_73011_w.getDimension(), (double)tile.func_174877_v().func_177958_n(), (double)tile.func_174877_v().func_177956_o(), (double)tile.func_174877_v().func_177952_p(), (double)spread));
            } else {
                network.sendToServer((IMessage)new PacketByteBuf((IByteBufTile)tile, tile.func_174877_v(), id, new ByteBufWritable[0]));
            }
        }
    }

    public static void sendFullSyncAround(TileEntity tile, int spread) {
        NBTTagCompound tag;
        if (!tile.func_145831_w().field_72995_K && tile instanceof INBTSyncable && !(tag = ((INBTSyncable)tile).writeData(new NBTTagCompound(), NBTHelper.SyncType.SYNC_OVERRIDE)).func_82582_d()) {
            network.sendToAllAround((IMessage)new PacketTileSync(tile.func_174877_v(), tag), new NetworkRegistry.TargetPoint(tile.func_145831_w().field_73011_w.getDimension(), (double)tile.func_174877_v().func_177958_n(), (double)tile.func_174877_v().func_177956_o(), (double)tile.func_174877_v().func_177952_p(), (double)spread));
        }
    }

    public static void sendFullSyncAroundWithRenderUpdate(TileEntity tile, int spread) {
        NBTTagCompound tag;
        if (!tile.func_145831_w().field_72995_K && tile instanceof INBTSyncable && !(tag = ((INBTSyncable)tile).writeData(new NBTTagCompound(), NBTHelper.SyncType.SYNC_OVERRIDE)).func_82582_d()) {
            network.sendToAllAround((IMessage)new PacketTileSyncUpdate(tile.func_174877_v(), tag), new NetworkRegistry.TargetPoint(tile.func_145831_w().field_73011_w.getDimension(), (double)tile.func_174877_v().func_177958_n(), (double)tile.func_174877_v().func_177956_o(), (double)tile.func_174877_v().func_177952_p(), (double)spread));
        }
    }

    public static void refreshFlexibleContainer(EntityPlayer player) {
        if (player.func_130014_f_().field_72995_K) {
            network.sendToServer((IMessage)new PacketFlexibleContainer(player));
        } else {
            network.sendTo((IMessage)new PacketFlexibleContainer(player), (EntityPlayerMP)player);
        }
    }

    public static void sendPacketToServer(TileEntity tile, int id) {
        if (tile.func_145831_w().field_72995_K) {
            network.sendToServer((IMessage)new PacketByteBuf((IByteBufTile)tile, tile.func_174877_v(), id, new ByteBufWritable[0]));
        }
    }

    public static int randInt(int min, int max) {
        return rand.nextInt(max - min + 1) + min;
    }

    static {
        inventoryProviders = new InventoryProviderRegistry();
        fluidProviders = new FluidProviderRegistry();
        energyProviders = new EnergyProviderRegistry();
        energyContainerHandlers = new EnergyContainerHandlerRegistry();
        energyTypes = new EnergyTypeRegistry();
        machineUpgrades = new MachineUpgradeRegistry();
        planters = new PlanterRegistry();
        harvesters = new HarvesterRegistry();
        fertilisers = new FertiliserRegistry();
        logger = LogManager.getLogger((String)modid);
        stableStone = new Block[16];
        stablestonerimmedBlock = new Block[16];
        stablestonerimmedblackBlock = new Block[16];
        rand = new Random();
        tab = new CreativeTabs(modid){

            public Item func_78016_d() {
                return Item.func_150898_a((Block)reinforcedStoneBlock);
            }
        };
    }
}

