/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.api.energy;

import sonar.core.api.IRegistryObject;

public class EnergyType
implements IRegistryObject {
    public static final EnergyType RF = new EnergyType("Redstone Flux", "RF", "RF/T", 1.0);
    public static final EnergyType EU = new EnergyType("Energy Units", "EU", "EU/T", 0.25);
    public static final EnergyType MJ = new EnergyType("Minecraft Joules", "J", "J/T", 2.5);
    public static final EnergyType AE = new EnergyType("Applied Energistics", "AE", "AE/t", 0.5);
    public static final EnergyType TESLA = new EnergyType("Tesla", "TESLA", "Tesla/t", 1.0);
    private String name = "";
    private String storage = "";
    private String usage = "";
    private double rfConversion = 1.0;

    public EnergyType(String name, String storage, String usage, double rfConversion) {
        this.name = name;
        this.storage = storage;
        this.usage = usage;
        this.rfConversion = rfConversion;
    }

    @Override
    public boolean isLoadable() {
        return true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getStorageSuffix() {
        return this.storage;
    }

    public String getUsageSuffix() {
        return this.usage;
    }

    public double toRFConversion() {
        return this.rfConversion;
    }

    public boolean equals(Object obj) {
        if (obj instanceof EnergyType) {
            return this.getName().equals(((EnergyType)obj).getName());
        }
        return false;
    }
}

