/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.client.gui;

import java.awt.Rectangle;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.inventory.Container;
import org.lwjgl.opengl.GL11;
import sonar.core.client.gui.GuiSonar;
import sonar.core.client.gui.widgets.IWidget;
import sonar.core.utils.IWorldPosition;

public abstract class GuiSonarWidget
extends GuiSonar {
    private LinkedHashMap<WidgetPos, IWidget> widgets = new LinkedHashMap();

    public void addWidget(int x, int y, IWidget widget) {
        widget.setGui(this);
        widget.setPosition(new WidgetPos(x, y));
        this.widgets.put(new WidgetPos(x, y), widget);
    }

    public GuiSonarWidget(Container container, IWorldPosition entity) {
        super(container, entity);
    }

    @Override
    protected void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        for (Map.Entry<WidgetPos, IWidget> widget : this.widgets.entrySet()) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)widget.getKey().x, (double)widget.getKey().y, (double)0.0);
            widget.getValue().drawForegroundLayer(x, y);
            GL11.glPopMatrix();
        }
    }

    @Override
    protected void func_146976_a(float val, int x, int y) {
        super.func_146976_a(val, x, y);
        for (Map.Entry<WidgetPos, IWidget> widget : this.widgets.entrySet()) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)widget.getKey().x, (double)widget.getKey().y, (double)0.0);
            widget.getValue().drawBackgroundLayer(val, x, y);
            GL11.glPopMatrix();
        }
    }

    public void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        for (Map.Entry<WidgetPos, IWidget> widget : this.widgets.entrySet()) {
            Rectangle rect = widget.getValue().getSizing();
            int x = this.field_147003_i + mouseX;
            int y = this.field_147009_r + mouseY;
            if ((double)x < (double)this.field_147003_i + rect.getWidth() && this.field_147003_i + widget.getKey().x > x && (double)y < (double)this.field_147009_r + rect.getHeight() && this.field_147009_r + widget.getKey().y > y) {
                widget.getValue().setFocused(true);
                widget.getValue().onClicked(x, y, mouseButton);
                continue;
            }
            widget.getValue().setFocused(false);
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        for (Map.Entry<WidgetPos, IWidget> widget : this.widgets.entrySet()) {
            widget.getValue().handleMouseInput();
        }
    }

    public void func_73869_a(char c, int i) throws IOException {
        super.func_73869_a(c, i);
        for (Map.Entry<WidgetPos, IWidget> widget : this.widgets.entrySet()) {
            if (!widget.getValue().isFocused()) continue;
            widget.getValue().keyTyped(c, i);
            break;
        }
    }

    public class WidgetPos {
        public int x;
        public int y;

        public WidgetPos(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }
}

