/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.client.gui.widgets;

import org.lwjgl.input.Mouse;

public class SonarScroller {
    public float currentScroll;
    public boolean isScrolling;
    public boolean wasClicking;
    public int left;
    public int start;
    public int end;
    public int width;

    public SonarScroller(int scrollerLeft, int scrollerStart, int length, int width) {
        this.left = scrollerLeft;
        this.start = scrollerStart;
        this.end = scrollerStart + length;
        this.width = width;
    }

    public float getCurrentScroll() {
        return this.currentScroll;
    }

    public void handleMouse(boolean needsScrollBars, int listSize) {
        float lastScroll = this.currentScroll;
        int i = Mouse.getEventDWheel();
        if (i != 0 && needsScrollBars) {
            int j = listSize + 1;
            if (i > 0) {
                i = 1;
            }
            if (i < 0) {
                i = -1;
            }
            this.currentScroll = (float)((double)this.currentScroll - (double)i / (double)j);
            if (this.currentScroll < 0.0f) {
                this.currentScroll = 0.0f;
            }
            if (this.currentScroll > 1.0f) {
                this.currentScroll = 1.0f;
            }
        }
    }

    public void drawScreen(int x, int y, boolean needsScrollBars) {
        float lastScroll = this.currentScroll;
        boolean flag = Mouse.isButtonDown((int)0);
        if (!this.wasClicking && flag && x >= this.left && y >= this.start && x < this.left + this.width && y < this.end) {
            this.isScrolling = needsScrollBars;
        }
        if (!flag) {
            this.isScrolling = false;
        }
        this.wasClicking = flag;
        if (this.isScrolling) {
            this.currentScroll = ((float)(y - this.start) - 7.5f) / ((float)(this.end - this.start) - 15.0f);
            if (this.currentScroll < 0.0f) {
                this.currentScroll = 0.0f;
            }
            if (this.currentScroll > 1.0f) {
                this.currentScroll = 1.0f;
            }
        }
    }
}

