/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.client.renderers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sonar.core.client.renderers.BlockRenderer;
import sonar.core.client.renderers.ISonarCustomRenderer;
import sonar.core.client.renderers.ISonarRendererProvider;
import sonar.core.client.renderers.ISonarTileRenderer;

public class SonarCustomStateMapper
extends StateMapperBase
implements ICustomModelLoader {
    public final ArrayList<ISonarCustomRenderer> renderers = new ArrayList();
    public final Map<ResourceLocation, BlockRenderer<? extends TileEntity>> customModels = new HashMap<ResourceLocation, BlockRenderer<? extends TileEntity>>();

    public SonarCustomStateMapper() {
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerCustomBlockRenderer(ISonarCustomRenderer renderer) {
        Block block = renderer.getBlock();
        BlockRenderer instance = new BlockRenderer(renderer);
        ModelResourceLocation blockModel = renderer.getBlockModelResourceLocation();
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)this);
        this.customModels.put((ResourceLocation)blockModel, instance);
        if (renderer instanceof ISonarTileRenderer) {
            ClientRegistry.bindTileEntitySpecialRenderer(((ISonarTileRenderer)renderer).getTileEntity(), instance);
        }
        if (renderer.doInventoryRendering()) {
            ModelResourceLocation itemModel = new ModelResourceLocation(blockModel.func_110624_b() + ":" + blockModel.func_110623_a(), "inventory");
            ModelLoader.setCustomMeshDefinition((Item)Item.func_150898_a((Block)block), (ItemMeshDefinition)renderer);
        }
        this.renderers.add(renderer);
    }

    protected ModelResourceLocation func_178132_a(IBlockState state) {
        Block block = state.func_177230_c();
        if (block instanceof ISonarRendererProvider) {
            return ((ISonarRendererProvider)block).getRenderer().getBlockModelResourceLocation();
        }
        return null;
    }

    public boolean accepts(ResourceLocation loc) {
        return this.customModels.containsKey(loc);
    }

    public IModel loadModel(ResourceLocation loc) throws Exception {
        return this.customModels.get(loc);
    }

    public void func_110549_a(IResourceManager resourceManager) {
    }
}

