/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.handlers.container;

import cofh.api.energy.IEnergyContainerItem;
import net.minecraft.item.ItemStack;
import sonar.core.api.energy.EnergyContainerHandler;
import sonar.core.api.energy.EnergyType;
import sonar.core.api.energy.StoredEnergyStack;
import sonar.core.api.utils.ActionType;

public class RFItemHandler
extends EnergyContainerHandler {
    @Override
    public String getName() {
        return "RF Item Handler";
    }

    @Override
    public boolean canHandleItem(ItemStack stack) {
        return stack.func_77973_b() != null && stack.func_77973_b() instanceof IEnergyContainerItem;
    }

    @Override
    public StoredEnergyStack addEnergy(StoredEnergyStack transfer, ItemStack stack, ActionType action) {
        IEnergyContainerItem receiver;
        IEnergyContainerItem item = (IEnergyContainerItem)stack.func_77973_b();
        if (item instanceof IEnergyContainerItem && (receiver = item).getMaxEnergyStored(stack) > 0) {
            int transferRF = transfer.stored < Integer.MAX_VALUE ? (int)transfer.stored : Integer.MAX_VALUE;
            transfer.stored -= (long)receiver.receiveEnergy(stack, transferRF, action.shouldSimulate());
        }
        if (transfer.stored == 0L) {
            transfer = null;
        }
        return transfer;
    }

    @Override
    public StoredEnergyStack removeEnergy(StoredEnergyStack transfer, ItemStack stack, ActionType action) {
        IEnergyContainerItem receiver;
        IEnergyContainerItem item = (IEnergyContainerItem)stack.func_77973_b();
        if (item instanceof IEnergyContainerItem && (receiver = item).getMaxEnergyStored(stack) > 0) {
            int transferRF = transfer.stored < Integer.MAX_VALUE ? (int)transfer.stored : Integer.MAX_VALUE;
            transfer.stored -= (long)receiver.extractEnergy(stack, transferRF, action.shouldSimulate());
        }
        if (transfer.stored == 0L) {
            transfer = null;
        }
        return transfer;
    }

    @Override
    public void getEnergy(StoredEnergyStack energyStack, ItemStack stack) {
        IEnergyContainerItem item = (IEnergyContainerItem)stack.func_77973_b();
        if (item == null) {
            return;
        }
        if (item instanceof IEnergyContainerItem && item.getMaxEnergyStored(stack) > 0) {
            IEnergyContainerItem receiver = item;
            energyStack.setStorageValues(receiver.getEnergyStored(stack), receiver.getMaxEnergyStored(stack));
            energyStack.setMaxInput(receiver.receiveEnergy(stack, Integer.MAX_VALUE, true));
            energyStack.setMaxOutput(receiver.extractEnergy(stack, Integer.MAX_VALUE, true));
        }
    }

    @Override
    public EnergyType getProvidedType() {
        return EnergyType.RF;
    }
}

