/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.handlers.container;

import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.api.ITeslaHolder;
import net.darkhax.tesla.api.ITeslaProducer;
import net.darkhax.tesla.capability.TeslaCapabilities;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;
import sonar.core.api.energy.EnergyContainerHandler;
import sonar.core.api.energy.EnergyType;
import sonar.core.api.energy.StoredEnergyStack;
import sonar.core.api.utils.ActionType;

public class TeslaItemHandler
extends EnergyContainerHandler {
    @Override
    public String getName() {
        return "TESLA Item Handler";
    }

    @Override
    public boolean canHandleItem(ItemStack stack) {
        return stack.func_77973_b() != null && (stack.hasCapability(TeslaCapabilities.CAPABILITY_CONSUMER, null) || stack.hasCapability(TeslaCapabilities.CAPABILITY_PRODUCER, null) || stack.hasCapability(TeslaCapabilities.CAPABILITY_HOLDER, null));
    }

    @Override
    public void getEnergy(StoredEnergyStack energyStack, ItemStack stack) {
        ITeslaProducer producer;
        long simulateAdd;
        ITeslaConsumer consumer;
        ITeslaHolder holder;
        if (stack == null) {
            return;
        }
        if (stack.hasCapability(TeslaCapabilities.CAPABILITY_HOLDER, null) && (holder = (ITeslaHolder)stack.getCapability(TeslaCapabilities.CAPABILITY_HOLDER, null)) != null) {
            energyStack.setStorageValues(holder.getStoredPower(), holder.getCapacity());
        }
        if (stack.hasCapability(TeslaCapabilities.CAPABILITY_CONSUMER, null) && (consumer = (ITeslaConsumer)stack.getCapability(TeslaCapabilities.CAPABILITY_CONSUMER, null)) != null) {
            simulateAdd = consumer.givePower(Long.MAX_VALUE, true);
            energyStack.setMaxInput(simulateAdd);
        }
        if (stack.hasCapability(TeslaCapabilities.CAPABILITY_PRODUCER, null) && (producer = (ITeslaProducer)stack.getCapability(TeslaCapabilities.CAPABILITY_PRODUCER, null)) != null) {
            simulateAdd = producer.takePower(Long.MAX_VALUE, true);
            energyStack.setMaxInput(simulateAdd);
        }
    }

    @Override
    public StoredEnergyStack addEnergy(StoredEnergyStack transfer, ItemStack stack, ActionType action) {
        ITeslaConsumer consumer;
        if (stack.hasCapability(TeslaCapabilities.CAPABILITY_CONSUMER, null) && (consumer = (ITeslaConsumer)stack.getCapability(TeslaCapabilities.CAPABILITY_CONSUMER, null)) != null) {
            int transferRF = transfer.stored < Integer.MAX_VALUE ? (int)transfer.stored : Integer.MAX_VALUE;
            transfer.stored -= consumer.givePower((long)transferRF, action.shouldSimulate());
        }
        if (transfer.stored == 0L) {
            transfer = null;
        }
        return transfer;
    }

    @Override
    public StoredEnergyStack removeEnergy(StoredEnergyStack transfer, ItemStack stack, ActionType action) {
        ITeslaProducer producer;
        if (stack.hasCapability(TeslaCapabilities.CAPABILITY_PRODUCER, null) && (producer = (ITeslaProducer)stack.getCapability(TeslaCapabilities.CAPABILITY_PRODUCER, null)) != null) {
            int transferRF = transfer.stored < Integer.MAX_VALUE ? (int)transfer.stored : Integer.MAX_VALUE;
            transfer.stored -= producer.takePower((long)transferRF, action.shouldSimulate());
        }
        if (transfer.stored == 0L) {
            transfer = null;
        }
        return transfer;
    }

    @Override
    public boolean isLoadable() {
        return Loader.isModLoaded((String)"tesla");
    }

    @Override
    public EnergyType getProvidedType() {
        return EnergyType.TESLA;
    }
}

