/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.handlers.energy;

import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.api.ITeslaHolder;
import net.darkhax.tesla.api.ITeslaProducer;
import net.darkhax.tesla.capability.TeslaCapabilities;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.Loader;
import sonar.core.api.energy.EnergyHandler;
import sonar.core.api.energy.EnergyType;
import sonar.core.api.energy.StoredEnergyStack;
import sonar.core.api.utils.ActionType;

public class TeslaHandler
extends EnergyHandler {
    public static String name = "TESLA-Provider";

    @Override
    public String getName() {
        return name;
    }

    @Override
    public boolean canProvideEnergy(TileEntity tile, EnumFacing dir) {
        return tile != null && (tile.hasCapability(TeslaCapabilities.CAPABILITY_CONSUMER, dir) || tile.hasCapability(TeslaCapabilities.CAPABILITY_PRODUCER, dir) || tile.hasCapability(TeslaCapabilities.CAPABILITY_HOLDER, dir));
    }

    @Override
    public StoredEnergyStack getEnergy(StoredEnergyStack energyStack, TileEntity tile, EnumFacing dir) {
        ITeslaProducer producer;
        long simulateAdd;
        ITeslaConsumer consumer;
        ITeslaHolder holder;
        if (tile == null) {
            return energyStack;
        }
        if (tile.hasCapability(TeslaCapabilities.CAPABILITY_HOLDER, dir) && (holder = (ITeslaHolder)tile.getCapability(TeslaCapabilities.CAPABILITY_HOLDER, dir)) != null) {
            energyStack.setStorageValues(holder.getStoredPower(), holder.getCapacity());
        }
        if (tile.hasCapability(TeslaCapabilities.CAPABILITY_CONSUMER, dir) && (consumer = (ITeslaConsumer)tile.getCapability(TeslaCapabilities.CAPABILITY_CONSUMER, dir)) != null) {
            simulateAdd = consumer.givePower(Long.MAX_VALUE, true);
            energyStack.setMaxInput(simulateAdd);
        }
        if (tile.hasCapability(TeslaCapabilities.CAPABILITY_PRODUCER, dir) && (producer = (ITeslaProducer)tile.getCapability(TeslaCapabilities.CAPABILITY_PRODUCER, dir)) != null) {
            simulateAdd = producer.takePower(Long.MAX_VALUE, true);
            energyStack.setMaxInput(simulateAdd);
        }
        return energyStack;
    }

    @Override
    public StoredEnergyStack addEnergy(StoredEnergyStack transfer, TileEntity tile, EnumFacing dir, ActionType action) {
        ITeslaConsumer consumer;
        if (tile.hasCapability(TeslaCapabilities.CAPABILITY_CONSUMER, dir) && (consumer = (ITeslaConsumer)tile.getCapability(TeslaCapabilities.CAPABILITY_CONSUMER, dir)) != null) {
            int transferRF = transfer.stored < Integer.MAX_VALUE ? (int)transfer.stored : Integer.MAX_VALUE;
            transfer.stored -= consumer.givePower((long)transferRF, action.shouldSimulate());
        }
        if (transfer.stored == 0L) {
            transfer = null;
        }
        return transfer;
    }

    @Override
    public StoredEnergyStack removeEnergy(StoredEnergyStack transfer, TileEntity tile, EnumFacing dir, ActionType action) {
        ITeslaProducer producer;
        if (tile.hasCapability(TeslaCapabilities.CAPABILITY_PRODUCER, dir) && (producer = (ITeslaProducer)tile.getCapability(TeslaCapabilities.CAPABILITY_PRODUCER, dir)) != null) {
            int transferRF = transfer.stored < Integer.MAX_VALUE ? (int)transfer.stored : Integer.MAX_VALUE;
            transfer.stored -= producer.takePower((long)transferRF, action.shouldSimulate());
        }
        if (transfer.stored == 0L) {
            transfer = null;
        }
        return transfer;
    }

    @Override
    public boolean isLoadable() {
        return Loader.isModLoaded((String)"tesla");
    }

    @Override
    public EnergyType getProvidedType() {
        return EnergyType.TESLA;
    }
}

