/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.handlers.fluids;

import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import sonar.core.api.StorageSize;
import sonar.core.api.fluids.FluidHandler;
import sonar.core.api.fluids.StoredFluidStack;
import sonar.core.api.utils.ActionType;

public class FluidCapabilityHandler
extends FluidHandler {
    public static String name = "Fluid Capability Handler";

    @Override
    public String getName() {
        return name;
    }

    @Override
    public boolean canHandleFluids(TileEntity tile, EnumFacing dir) {
        return tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, dir);
    }

    @Override
    public StoredFluidStack addStack(StoredFluidStack add, TileEntity tile, EnumFacing dir, ActionType action) {
        IFluidHandler handler = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, dir);
        add.stored = add.stored - (long)handler.fill(add.fluid, !action.shouldSimulate());
        return add;
    }

    @Override
    public StoredFluidStack removeStack(StoredFluidStack remove, TileEntity tile, EnumFacing dir, ActionType action) {
        IFluidHandler handler = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, dir);
        FluidStack drained = null;
        drained = handler.drain(remove.fluid, !action.shouldSimulate());
        remove.stored = remove.stored - (drained != null ? (long)drained.amount : 0L);
        return remove;
    }

    @Override
    public StorageSize getFluids(List<StoredFluidStack> fluids, TileEntity tile, EnumFacing dir) {
        IFluidHandler handler = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, dir);
        long stored = 0L;
        long maxStorage = 0L;
        IFluidTankProperties[] tankInfo = handler.getTankProperties();
        if (tankInfo != null) {
            for (IFluidTankProperties info : tankInfo) {
                FluidStack contents = info.getContents();
                if (contents != null && contents.amount != 0) {
                    stored += (long)contents.amount;
                    fluids.add(new StoredFluidStack(contents, info.getCapacity()));
                }
                maxStorage += (long)info.getCapacity();
            }
        }
        return new StorageSize(stored, maxStorage);
    }
}

