/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.helpers;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import sonar.core.SonarCore;
import sonar.core.api.energy.EnergyContainerHandler;
import sonar.core.api.energy.EnergyHandler;
import sonar.core.api.energy.EnergyType;
import sonar.core.api.energy.ISonarEnergyTile;
import sonar.core.api.energy.StoredEnergyStack;
import sonar.core.api.utils.ActionType;
import sonar.core.api.wrappers.EnergyWrapper;
import sonar.core.energy.DischargeValues;
import sonar.core.handlers.energy.SonarHandler;
import sonar.core.network.sync.SyncEnergyStorage;

public class EnergyHelper
extends EnergyWrapper {
    public static final SonarHandler chargingHandler = new SonarHandler();

    @Override
    public long receiveEnergy(TileEntity tile, long maxReceive, EnumFacing dir, ActionType type) {
        EnergyHandler handler;
        if (maxReceive != 0L && tile != null && (handler = this.canTransferEnergy(tile, dir)) != null) {
            return this.performReceive(handler, tile, maxReceive, dir, type);
        }
        return 0L;
    }

    public long performReceive(EnergyHandler handler, TileEntity tile, long maxReceive, EnumFacing dir, ActionType type) {
        long receive = StoredEnergyStack.convert(maxReceive, EnergyType.RF, handler.getProvidedType());
        StoredEnergyStack stack = handler.addEnergy(new StoredEnergyStack(EnergyType.RF).setStackSize(receive), tile, dir, type);
        long remain = stack == null ? 0L : stack.getStackSize();
        remain = StoredEnergyStack.convert(remain, handler.getProvidedType(), EnergyType.RF);
        return maxReceive - remain;
    }

    @Override
    public long extractEnergy(TileEntity tile, long maxExtract, EnumFacing dir, ActionType type) {
        EnergyHandler handler;
        if (maxExtract != 0L && tile != null && (handler = this.canTransferEnergy(tile, dir)) != null) {
            return this.performExtract(handler, tile, maxExtract, dir, type);
        }
        return 0L;
    }

    public long performExtract(EnergyHandler handler, TileEntity tile, long maxExtract, EnumFacing dir, ActionType type) {
        long receive = StoredEnergyStack.convert(maxExtract, EnergyType.RF, handler.getProvidedType());
        StoredEnergyStack stack = handler.removeEnergy(new StoredEnergyStack(EnergyType.RF).setStackSize(receive), tile, dir, type);
        long remain = stack == null ? 0L : stack.getStackSize();
        remain = StoredEnergyStack.convert(remain, handler.getProvidedType(), EnergyType.RF);
        return maxExtract - remain;
    }

    @Override
    public long receiveEnergy(ItemStack stack, long maxReceive, ActionType type) {
        EnergyContainerHandler handler;
        if (maxReceive != 0L && stack != null && (handler = this.canTransferEnergy(stack)) != null) {
            long receive = StoredEnergyStack.convert(maxReceive, EnergyType.RF, handler.getProvidedType());
            StoredEnergyStack energystack = handler.addEnergy(new StoredEnergyStack(EnergyType.RF).setStackSize(receive), stack, type);
            long remain = energystack == null ? 0L : energystack.getStackSize();
            remain = StoredEnergyStack.convert(remain, handler.getProvidedType(), EnergyType.RF);
            return maxReceive - remain;
        }
        return 0L;
    }

    @Override
    public long extractEnergy(ItemStack stack, long maxExtract, ActionType type) {
        EnergyContainerHandler handler;
        if (maxExtract != 0L && stack != null && (handler = this.canTransferEnergy(stack)) != null) {
            long receive = StoredEnergyStack.convert(maxExtract, EnergyType.RF, handler.getProvidedType());
            StoredEnergyStack energystack = handler.removeEnergy(new StoredEnergyStack(EnergyType.RF).setStackSize(receive), stack, type);
            long remain = energystack == null ? 0L : energystack.getStackSize();
            remain = StoredEnergyStack.convert(remain, handler.getProvidedType(), EnergyType.RF);
            return maxExtract - remain;
        }
        return 0L;
    }

    @Override
    public StoredEnergyStack getEnergyStored(ItemStack stack, EnergyType format) {
        EnergyContainerHandler handler = this.canTransferEnergy(stack);
        if (handler != null) {
            StoredEnergyStack energy = new StoredEnergyStack(handler.getProvidedType());
            handler.getEnergy(energy, stack);
            return energy.convertEnergyType(format);
        }
        return new StoredEnergyStack(format);
    }

    @Override
    public long transferEnergy(TileEntity from, TileEntity to, EnumFacing dirFrom, EnumFacing dirTo, long maxTransferRF) {
        long maxTransfer;
        if (from != null && !from.func_145831_w().field_72995_K && to != null && maxTransferRF != 0L && (maxTransfer = Math.min(this.extractEnergy(from, maxTransferRF, dirFrom, ActionType.SIMULATE), this.receiveEnergy(to, maxTransferRF, dirTo, ActionType.SIMULATE))) != 0L) {
            return this.extractEnergy(from, this.receiveEnergy(to, maxTransfer, dirTo, ActionType.PERFORM), dirFrom, ActionType.PERFORM);
        }
        return 0L;
    }

    @Override
    public ItemStack chargeItem(ItemStack item, TileEntity tile, long maxTransferRF) {
        long maxTransfer;
        if (tile != null && !tile.func_145831_w().field_72995_K && item != null && maxTransferRF != 0L && (maxTransfer = Math.min(this.performExtract(chargingHandler, tile, maxTransferRF, null, ActionType.SIMULATE), this.receiveEnergy(item, maxTransferRF, ActionType.SIMULATE))) != 0L) {
            this.performExtract(chargingHandler, tile, this.receiveEnergy(item, maxTransfer, ActionType.PERFORM), null, ActionType.PERFORM);
            return item;
        }
        return item;
    }

    @Override
    public ItemStack dischargeItem(ItemStack item, TileEntity tile, long maxTransferRF) {
        if (item != null && !tile.func_145831_w().field_72995_K && tile != null && maxTransferRF != 0L) {
            long maxTransfer = Math.min(this.extractEnergy(item, maxTransferRF, ActionType.SIMULATE), this.performReceive(chargingHandler, tile, maxTransferRF, null, ActionType.SIMULATE));
            if (maxTransfer != 0L) {
                this.extractEnergy(item, this.performReceive(chargingHandler, tile, maxTransfer, null, ActionType.PERFORM), ActionType.PERFORM);
                return item;
            }
            if (tile instanceof ISonarEnergyTile) {
                SyncEnergyStorage storage = ((ISonarEnergyTile)tile).getStorage();
                int value = DischargeValues.getValueOf(item);
                if (value != 0 && storage.getEnergyStored() + value <= storage.getMaxEnergyStored()) {
                    storage.setEnergyStored(storage.getEnergyStored() + value);
                    --item.field_77994_a;
                    if (item.field_77994_a <= 0) {
                        item = null;
                    }
                    return item;
                }
            }
        }
        return item;
    }

    @Override
    public EnergyHandler canTransferEnergy(TileEntity tile, EnumFacing dir) {
        List handlers = SonarCore.energyProviders.getObjects();
        for (EnergyHandler handler : handlers) {
            if (!handler.canProvideEnergy(tile, dir)) continue;
            return handler;
        }
        return null;
    }

    @Override
    public EnergyContainerHandler canTransferEnergy(ItemStack stack) {
        List handlers = SonarCore.energyContainerHandlers.getObjects();
        for (EnergyContainerHandler handler : handlers) {
            if (!handler.canHandleItem(stack)) continue;
            return handler;
        }
        return null;
    }
}

