/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.helpers;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import sonar.core.helpers.IRecipeHelper;

public abstract class ValueHelper
implements IRecipeHelper {
    protected Map<Object, Integer> recipeList = new HashMap<Object, Integer>();

    public abstract void addRecipes();

    public ValueHelper() {
        this.addRecipes();
    }

    @Override
    public Map<Object, Integer> getRecipes() {
        return this.recipeList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addRecipe(Object object, Integer value) {
        ItemStack[] stack = null;
        if (object == null) {
            return;
        }
        if (object instanceof String) {
            List ores = OreDictionary.getOres((String)((String)object));
            if (ores.size() <= 0) return;
            ItemStack[] oreStacks = new ItemStack[ores.size()];
            stack = ores.toArray(oreStacks);
        } else if (object instanceof ItemStack[]) {
            for (int s = 0; s < ((ItemStack[])object).length; ++s) {
                if (((ItemStack[])object)[s] != null) continue;
                return;
            }
            stack = object;
        } else {
            stack = this.fixedStack(object);
        }
        this.recipeList.put(stack, value);
    }

    private ItemStack fixedStack(Object obj) {
        if (obj instanceof ItemStack) {
            return ((ItemStack)obj).func_77946_l();
        }
        if (obj instanceof Item) {
            return new ItemStack((Item)obj, 1);
        }
        if (!(obj instanceof Block)) {
            throw new RuntimeException("Invalid Recipe!");
        }
        return new ItemStack((Block)obj, 1);
    }

    public Integer getOutput(ItemStack input) {
        Map.Entry<Object, Integer> entry;
        if (input == null) {
            return null;
        }
        Iterator<Map.Entry<Object, Integer>> iterator = this.recipeList.entrySet().iterator();
        do {
            if (iterator.hasNext()) continue;
            return 0;
        } while (!this.checkInput(input, (entry = iterator.next()).getKey()));
        return entry.getValue();
    }

    private boolean checkInput(ItemStack input, Object key) {
        return !(key instanceof ItemStack ? !this.equalStack(input, (ItemStack)key, true) : key instanceof ItemStack[] && this.containsStack(input, (ItemStack[])key, true) == -1);
    }

    public int containsStack(ItemStack stack, Object[] key, boolean checkSize) {
        for (int i = 0; i < key.length; ++i) {
            if (key[i] == null) continue;
            if (key[i] instanceof ItemStack) {
                if (!this.equalStack(stack, (ItemStack)key[i], checkSize)) continue;
                return i;
            }
            if (!(key[i] instanceof ItemStack[])) continue;
            for (int s = 0; s < ((ItemStack[])key[i]).length; ++s) {
                ItemStack target = ((ItemStack[])key[i])[s];
                if (target == null || !this.equalStack(stack, target, checkSize)) continue;
                return i;
            }
        }
        return -1;
    }

    private boolean equalStack(ItemStack stack, ItemStack key, boolean checkSize) {
        return !(stack.func_77973_b() != key.func_77973_b() || key.func_77952_i() != Short.MAX_VALUE && stack.func_77952_i() != key.func_77952_i() || checkSize && key.field_77994_a > stack.field_77994_a);
    }
}

