/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.integration.minetweaker;

import java.util.ArrayList;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.minecraft.MineTweakerMC;
import minetweaker.api.oredict.IOreDictEntry;
import net.minecraft.item.ItemStack;
import sonar.core.SonarCore;
import sonar.core.helpers.RecipeHelper;

public class SonarAddRecipe
implements IUndoableAction {
    public ArrayList inputs;
    public ArrayList<ItemStack> outputs;
    public boolean liquidStack;
    public boolean wasNull;
    public boolean wrongSize;
    public RecipeHelper helper;

    public SonarAddRecipe(RecipeHelper helper, ArrayList inputs, ArrayList<ItemStack> outputs) {
        this.helper = helper;
        if (inputs.size() != helper.inputSize || outputs.size() != helper.outputSize) {
            MineTweakerAPI.logError((String)("A " + helper.getRecipeID() + " recipe was the wrong size"));
            this.wrongSize = true;
            return;
        }
        ArrayList<Object> adaptedInputs = new ArrayList<Object>();
        for (Object input : inputs) {
            if (input == null) {
                MineTweakerAPI.logError((String)String.format("An ingredient of a %s was null", helper.getRecipeID()));
                this.wasNull = true;
                return;
            }
            if (input instanceof IItemStack) {
                adaptedInputs.add(MineTweakerMC.getItemStack((IItemStack)((IItemStack)input)));
                continue;
            }
            if (input instanceof IOreDictEntry) {
                adaptedInputs.add(new RecipeHelper.OreStack(((IOreDictEntry)input).getName(), 1));
                continue;
            }
            if (input instanceof ILiquidStack) {
                MineTweakerAPI.logError((String)String.format("A liquid was passed into a %s, aborting!", helper.getRecipeID()));
                this.liquidStack = true;
                return;
            }
            if (!(input instanceof ItemStack)) {
                MineTweakerAPI.logError((String)String.format("%s: Invalid ingredient: %s", helper.getRecipeID(), input));
                continue;
            }
            adaptedInputs.add(input);
        }
        this.inputs = adaptedInputs;
        this.outputs = outputs;
    }

    public void apply() {
        if (!(this.wasNull || this.liquidStack || this.wrongSize)) {
            ArrayList toApply = (ArrayList)this.inputs.clone();
            toApply.addAll(this.outputs);
            this.helper.addRecipe(toApply.toArray());
        } else {
            SonarCore.logger.error(String.format("Failed to add %s recipe (%s = %s)", this.helper.getRecipeID(), this.inputs, this.outputs));
        }
    }

    public void undo() {
        if (!(this.wasNull || this.liquidStack || this.wrongSize)) {
            boolean removed = this.helper.removeRecipe(this.inputs.toArray());
            if (!removed) {
                MineTweakerAPI.logError((String)String.format("%s: Failed to remove recipe %s", this.helper.getRecipeID(), this.inputs.toArray()));
            }
        } else {
            SonarCore.logger.error(String.format("Failed to remove %s recipe (%s = %s)", this.helper.getRecipeID(), this.inputs, this.outputs));
        }
    }

    public String describe() {
        return String.format("Adding %s recipe (%s = %s)", this.helper.getRecipeID(), this.inputs, this.outputs);
    }

    public String describeUndo() {
        return String.format("Reverting /%s/", this.describe());
    }

    public boolean canUndo() {
        return true;
    }

    public Object getOverrideKey() {
        return null;
    }
}

