/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.integration.multipart;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import mcmultipart.multipart.IMultipart;
import mcmultipart.multipart.Multipart;
import mcmultipart.raytrace.PartMOP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.common.FMLCommonHandler;
import sonar.core.SonarCore;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.api.utils.BlockCoords;
import sonar.core.helpers.NBTHelper;
import sonar.core.integration.multipart.SonarMultipartHelper;
import sonar.core.network.sync.ISyncPart;
import sonar.core.utils.IRemovable;
import sonar.core.utils.IWorldPosition;
import sonar.core.utils.Pair;

public abstract class SonarMultipart
extends Multipart
implements ITickable,
INBTSyncable,
IWorldPosition,
IRemovable {
    public ArrayList<ISyncPart> syncParts = new ArrayList();
    public AxisAlignedBB collisionBox = null;
    public boolean wasRemoved = false;
    public boolean firstTick = false;
    protected boolean forceSync;

    public SonarMultipart(AxisAlignedBB collisionBox) {
        this.collisionBox = collisionBox;
    }

    public SonarMultipart() {
    }

    public void func_73660_a() {
        if (!this.firstTick) {
            this.onFirstTick();
            this.firstTick = true;
        }
        for (ISyncPart part : this.syncParts) {
            if (part == null || !part.hasChanged()) continue;
            this.markDirty();
            break;
        }
    }

    public void onFirstTick() {
    }

    public UUID getUUID() {
        if (this.getContainer() != null) {
            return this.getContainer().getPartID((IMultipart)this);
        }
        return null;
    }

    public void addSelectionBoxes(List<AxisAlignedBB> list) {
        if (this.collisionBox != null) {
            list.add(this.collisionBox);
        }
    }

    public void addCollisionBoxes(AxisAlignedBB mask, List<AxisAlignedBB> list, Entity collidingEntity) {
        if (this.collisionBox != null && this.collisionBox.func_72326_a(mask)) {
            list.add(this.collisionBox);
        }
    }

    @Override
    public BlockCoords getCoords() {
        return new BlockCoords(this.getContainer().getPosIn(), this.getContainer().getWorldIn());
    }

    public void onRemoved() {
        this.wasRemoved = true;
    }

    public final NBTTagCompound writeToNBT(NBTTagCompound tag) {
        return this.writeData(tag, NBTHelper.SyncType.SAVE);
    }

    public final void readFromNBT(NBTTagCompound tag) {
        this.readData(tag, NBTHelper.SyncType.SAVE);
    }

    @Override
    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        NBTHelper.readSyncParts(nbt, type, this.syncParts);
    }

    @Override
    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (this.forceSync && type == NBTHelper.SyncType.DEFAULT_SYNC) {
            type = NBTHelper.SyncType.SYNC_OVERRIDE;
            this.forceSync = false;
        }
        NBTHelper.writeSyncParts(nbt, type, this.syncParts, this.forceSync);
        return nbt;
    }

    public void sendSyncPacket() {
        if (!this.getWorld().field_72995_K) {
            SonarMultipartHelper.sendMultipartSyncAround(this, 64);
        } else {
            SonarMultipartHelper.sendMultipartSyncToServer(this);
        }
    }

    public void sendByteBufPacket(int id) {
        if (!this.getWorld().field_72995_K) {
            SonarMultipartHelper.sendMultipartPacketAround(this, id, 64);
        } else {
            SonarMultipartHelper.sendMultipartPacketToServer(this, id);
        }
    }

    public ItemStack getPickBlock(EntityPlayer player, PartMOP hit) {
        return this.getItemStack();
    }

    public abstract ItemStack getItemStack();

    public Pair<Boolean, EnumFacing> rotatePart(EnumFacing face, EnumFacing axis) {
        EnumFacing[] valid = this.getValidRotations();
        if (valid != null) {
            int pos = -1;
            for (int i = 0; i < valid.length; ++i) {
                if (valid[i] != face) continue;
                pos = i;
                break;
            }
            if (pos != -1) {
                int n = pos = pos + 1 < valid.length ? pos + 1 : 0;
                if (this.isServer()) {
                    face = valid[pos];
                }
                return new Pair<Boolean, EnumFacing>(true, face);
            }
        }
        return new Pair<Boolean, EnumFacing>(false, face);
    }

    public void forceNextSync() {
        this.forceSync = true;
    }

    @Override
    public boolean wasRemoved() {
        return this.wasRemoved;
    }

    public boolean isClient() {
        if (this.getWorld() == null) {
            return FMLCommonHandler.instance().getEffectiveSide().isClient();
        }
        return this.getWorld().field_72995_K;
    }

    public boolean isServer() {
        if (this.getWorld() == null) {
            return FMLCommonHandler.instance().getEffectiveSide().isServer();
        }
        return !this.getWorld().field_72995_K;
    }

    public void openGui(EntityPlayer player, Object mod) {
        player.openGui(mod, this.getUUID().hashCode(), this.getWorld(), this.getPos().func_177958_n(), this.getPos().func_177956_o(), this.getPos().func_177952_p());
    }

    public void openBasicGui(EntityPlayer player, int id) {
        SonarCore.instance.guiHandler.openBasicMultipart(this.getUUID(), player, this.getWorld(), this.getPos(), id);
    }
}

