/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.integration.multipart;

import java.util.UUID;
import mcmultipart.multipart.IMultipart;
import mcmultipart.multipart.IMultipartContainer;
import mcmultipart.multipart.ISlottedPart;
import mcmultipart.multipart.MultipartHelper;
import mcmultipart.multipart.PartSlot;
import mcmultipart.raytrace.RayTraceUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import sonar.core.SonarCore;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.helpers.NBTHelper;
import sonar.core.integration.SonarLoader;
import sonar.core.integration.multipart.SonarMultipart;
import sonar.core.network.PacketByteBufMultipart;
import sonar.core.network.PacketMultipartSync;
import sonar.core.network.utils.IByteBufTile;

public class SonarMultipartHelper {
    public static RayTraceUtils.AdvancedRayTraceResultPart collisionRayTrace(IMultipartContainer container, Vec3d start, Vec3d end) {
        double dist = Double.POSITIVE_INFINITY;
        RayTraceUtils.AdvancedRayTraceResultPart current = null;
        for (IMultipart p : container.getParts()) {
            double d;
            RayTraceUtils.AdvancedRayTraceResultPart result = p.collisionRayTrace(start, end);
            if (result == null || !((d = result.squareDistanceTo(start)) <= dist)) continue;
            dist = d;
            current = result;
        }
        return current;
    }

    public static Object getTile(World world, BlockPos pos) {
        IMultipartContainer container;
        if (SonarLoader.mcmultipartLoaded && (container = MultipartHelper.getPartContainer((IBlockAccess)world, (BlockPos)pos)) != null) {
            return container;
        }
        return world.func_175625_s(pos);
    }

    @Deprecated
    public static Object getPart(int partID, World world, BlockPos pos) {
        IMultipartContainer container;
        ISlottedPart part;
        Object object = SonarMultipartHelper.getTile(world, pos);
        if (SonarLoader.mcmultipartLoaded && object instanceof IMultipartContainer && (part = (container = (IMultipartContainer)object).getPartInSlot(PartSlot.VALUES[partID])) != null) {
            return part;
        }
        return object;
    }

    public static IMultipart getPartFromHash(int hashCode, World world, BlockPos pos) {
        Object object = SonarMultipartHelper.getTile(world, pos);
        if (SonarLoader.mcmultipartLoaded && object instanceof IMultipartContainer) {
            return SonarMultipartHelper.getPartFromHash(hashCode, (IMultipartContainer)object);
        }
        return null;
    }

    public static IMultipart getPartFromHash(int hashCode, IMultipartContainer container) {
        for (IMultipart part : container.getParts()) {
            if (part == null || container.getPartID(part).hashCode() != hashCode) continue;
            return part;
        }
        return null;
    }

    public static IMultipart getPart(UUID partUUID, World world, BlockPos pos) {
        IMultipartContainer container;
        IMultipart part;
        Object object = SonarMultipartHelper.getTile(world, pos);
        if (SonarLoader.mcmultipartLoaded && object instanceof IMultipartContainer && (part = (container = (IMultipartContainer)object).getPartFromID(partUUID)) != null) {
            return part;
        }
        return null;
    }

    public static boolean sendMultipartSyncAround(SonarMultipart part, int spread) {
        NBTTagCompound tag;
        if (!part.getWorld().field_72995_K && part != null && part instanceof INBTSyncable && !(tag = part.writeData(new NBTTagCompound(), NBTHelper.SyncType.SYNC_OVERRIDE)).func_82582_d()) {
            SonarCore.network.sendToAllAround((IMessage)SonarMultipartHelper.buildSyncPacket(part, tag), new NetworkRegistry.TargetPoint(part.getWorld().field_73011_w.getDimension(), (double)part.getPos().func_177958_n(), (double)part.getPos().func_177956_o(), (double)part.getPos().func_177952_p(), (double)spread));
            return true;
        }
        return false;
    }

    public static boolean sendMultipartSyncToServer(SonarMultipart part) {
        NBTTagCompound tag;
        if (part.getWorld().field_72995_K && part != null && part instanceof INBTSyncable && !(tag = part.writeData(new NBTTagCompound(), NBTHelper.SyncType.SYNC_OVERRIDE)).func_82582_d()) {
            SonarCore.network.sendToServer((IMessage)SonarMultipartHelper.buildSyncPacket(part, tag));
            return true;
        }
        return false;
    }

    public static boolean sendMultipartPacketAround(SonarMultipart part, int id, int spread) {
        if (!part.getWorld().field_72995_K && part != null && part instanceof IByteBufTile) {
            SonarCore.network.sendToAllAround((IMessage)SonarMultipartHelper.buildBufPacket(part, id), new NetworkRegistry.TargetPoint(part.getWorld().field_73011_w.getDimension(), (double)part.getPos().func_177958_n(), (double)part.getPos().func_177956_o(), (double)part.getPos().func_177952_p(), (double)spread));
            return true;
        }
        return false;
    }

    public static boolean sendMultipartPacketToServer(SonarMultipart part, int id) {
        if (part.getWorld().field_72995_K && part != null && part instanceof IByteBufTile) {
            SonarCore.network.sendToServer((IMessage)SonarMultipartHelper.buildBufPacket(part, id));
            return true;
        }
        return false;
    }

    public static PacketMultipartSync buildSyncPacket(SonarMultipart part, NBTTagCompound tag) {
        return new PacketMultipartSync(part.getPos(), tag, part.getUUID());
    }

    public static PacketByteBufMultipart buildBufPacket(SonarMultipart part, int id) {
        return new PacketByteBufMultipart(part.getUUID(), (IByteBufTile)((Object)part), part.getPos(), id);
    }
}

