/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.inventory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import sonar.core.api.inventories.StoredItemStack;
import sonar.core.common.tileentity.TileEntitySonar;
import sonar.core.inventory.ContainerSync;
import sonar.core.inventory.ILargeInventory;
import sonar.core.inventory.slots.SlotLarge;

public abstract class ContainerLargeInventory
extends ContainerSync {
    ILargeInventory entity;

    public ContainerLargeInventory(TileEntitySonar tile) {
        super(tile);
        this.entity = (ILargeInventory)((Object)tile);
    }

    protected boolean mergeSpecial(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        boolean flag = false;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }
        if (stack.func_77985_e()) {
            while (stack.field_77994_a > 0 && (!reverseDirection && i < endIndex || reverseDirection && i >= startIndex)) {
                Slot slot = (Slot)this.field_75151_b.get(i);
                ItemStack itemstack = slot.func_75211_c();
                StoredItemStack stored = this.entity.getTileInv().getLargeStack(i);
                if (itemstack != null && itemstack.func_77973_b() == stack.func_77973_b() && (!stack.func_77981_g() || stack.func_77960_j() == itemstack.func_77960_j()) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack)) {
                    int j = itemstack.field_77994_a + stack.field_77994_a;
                    int maxSize = stack.func_77976_d();
                    if (j <= maxSize) {
                        stack.field_77994_a = 0;
                        if (slot instanceof SlotLarge) {
                            this.entity.getTileInv().setLargeStack(i, stored.setStackSize(j));
                        } else {
                            itemstack.field_77994_a = j;
                        }
                        slot.func_75218_e();
                        flag = true;
                    } else if (itemstack.field_77994_a < maxSize) {
                        stack.field_77994_a -= maxSize - itemstack.field_77994_a;
                        if (slot instanceof SlotLarge) {
                            stored.add(new StoredItemStack(itemstack.func_77946_l()).setStackSize(maxSize));
                            this.entity.getTileInv().setLargeStack(i, stored);
                        } else {
                            itemstack.field_77994_a = maxSize;
                        }
                        slot.func_75218_e();
                        flag = true;
                    }
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (stack.field_77994_a > 0) {
            i = reverseDirection ? endIndex - 1 : startIndex;
            while (!reverseDirection && i < endIndex || reverseDirection && i >= startIndex) {
                Slot slot1 = (Slot)this.field_75151_b.get(i);
                ItemStack itemstack1 = slot1.func_75211_c();
                if (slot1.func_75214_a(stack)) {
                    if (slot1 instanceof SlotLarge) {
                        StoredItemStack target = this.entity.getTileInv().getLargeStack(i);
                        if (target != null) {
                            target = target.copy();
                            itemstack1 = target.getFullStack();
                        } else {
                            target = new StoredItemStack(stack).setStackSize(0L);
                            itemstack1 = null;
                        }
                        int max = target.getItemStack().func_77976_d() * this.entity.getTileInv().numStacks;
                        if (target.stored < (long)max) {
                            int toAdd = (int)Math.min((long)max - target.stored, (long)stack.field_77994_a);
                            target.add(new StoredItemStack(stack.func_77946_l()).setStackSize(toAdd));
                            this.entity.getTileInv().setLargeStack(i, target);
                            stack.field_77994_a -= toAdd;
                            if (stack.field_77994_a == 0) {
                                flag = true;
                                break;
                            }
                        }
                    } else if (itemstack1 == null) {
                        slot1.func_75215_d(stack.func_77946_l());
                        slot1.func_75218_e();
                        stack.field_77994_a = 0;
                        flag = true;
                        break;
                    }
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public ItemStack func_184996_a(int slotID, int dragType, ClickType button, EntityPlayer player) {
        if (slotID >= this.entity.getTileInv().size || button == ClickType.QUICK_MOVE) {
            return super.func_184996_a(slotID, dragType, button, player);
        }
        if (slotID >= 0) {
            StoredItemStack clicked = this.entity.getTileInv().getLargeStack(slotID);
            if ((dragType == 0 || dragType == 1) && button == ClickType.PICKUP) {
                ItemStack held = player.field_71071_by.func_70445_o();
                if (held == null && clicked != null && clicked.getItemStack() != null) {
                    int toRemove = (int)Math.min((long)clicked.getItemStack().func_77976_d(), clicked.stored);
                    if (dragType == 1 && toRemove != 1) {
                        toRemove = (int)Math.ceil(toRemove / 2);
                    }
                    if (toRemove != 0) {
                        StoredItemStack newStack = clicked.copy();
                        ItemStack stack = newStack.copy().setStackSize(toRemove).getFullStack();
                        newStack.remove(stack);
                        if (newStack.stored == 0L) {
                            this.entity.getTileInv().setLargeStack(slotID, null);
                        }
                        player.field_71071_by.func_70437_b(stack);
                        this.entity.getTileInv().setLargeStack(slotID, newStack);
                        return null;
                    }
                } else if (held != null) {
                    int maxAdd;
                    if (clicked == null || clicked.getItemStack() == null || clicked.getStackSize() == 0L) {
                        if (this.entity.getTileInv().isItemValidForSlot(slotID * this.entity.getTileInv().numStacks, held)) {
                            this.entity.getTileInv().setLargeStack(slotID, new StoredItemStack(held));
                            player.field_71071_by.func_70437_b(null);
                            return null;
                        }
                    } else if (clicked != null && clicked.getItemStack() != null && clicked.equalStack(held) && (maxAdd = (int)Math.min((long)(held.func_77976_d() * this.entity.getTileInv().numStacks) - clicked.getStackSize(), (long)held.field_77994_a)) > 0) {
                        StoredItemStack newStack = clicked.copy();
                        newStack.add(new StoredItemStack(held).setStackSize(maxAdd));
                        held.field_77994_a -= maxAdd;
                        if (held.field_77994_a == 0) {
                            player.field_71071_by.func_70437_b(null);
                        }
                        this.entity.getTileInv().setLargeStack(slotID, newStack);
                        return null;
                    }
                }
            }
        }
        return null;
    }
}

