/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.inventory;

import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.items.IItemHandler;
import sonar.core.api.inventories.StoredItemStack;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.sync.DirtyPart;
import sonar.core.network.sync.ISyncPart;

public class SonarLargeInventory
extends DirtyPart
implements IItemHandler,
INBTSyncable,
ISyncPart {
    public StoredItemStack[] slots;
    public int limit = 64;
    public final TileEntity tile;
    public int numStacks = 4;
    public int size;

    public SonarLargeInventory(TileEntity tile, int size, int numStacks) {
        this.size = size;
        this.slots = new StoredItemStack[size];
        this.tile = tile;
        this.numStacks = numStacks;
    }

    public SonarLargeInventory setStackLimit(int limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (type == NBTHelper.SyncType.SAVE && nbt.func_74764_b(this.getTagName())) {
            NBTTagList list = nbt.func_150295_c(this.getTagName(), 10);
            StoredItemStack[] stacks = new StoredItemStack[this.size];
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound compound = list.func_150305_b(i);
                byte b = compound.func_74771_c("Slot");
                if (b < 0 || b >= this.size) continue;
                stacks[b] = NBTHelper.instanceNBTSyncable(StoredItemStack.class, compound);
            }
            this.slots = stacks;
        }
    }

    @Override
    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (type == NBTHelper.SyncType.SAVE) {
            NBTTagList list = new NBTTagList();
            for (int i = 0; i < this.size; ++i) {
                StoredItemStack stack = this.slots[i];
                if (stack == null || stack.getStackSize() == 0L) continue;
                NBTTagCompound compound = new NBTTagCompound();
                compound.func_74774_a("Slot", (byte)i);
                list.func_74742_a((NBTBase)stack.writeData(compound, type));
            }
            nbt.func_74782_a(this.getTagName(), (NBTBase)list);
        }
        return nbt;
    }

    public ItemStack getStackInSlot(int slot) {
        int target = (int)Math.floor(slot / this.numStacks);
        StoredItemStack stack = this.slots[target];
        if (stack == null || stack.getStackSize() == 0L) {
            return null;
        }
        int actualSize = this.getSlotSize(stack, target, slot);
        return actualSize == 0 ? null : stack.copy().setStackSize(actualSize).getActualStack();
    }

    public int getSlotSize(StoredItemStack stack, int target, int slot) {
        int maxStackSize = stack.item.func_77976_d();
        int pos = slot - target * this.numStacks;
        int size = (int)stack.getStackSize();
        int actualSize = size >= pos * maxStackSize ? maxStackSize : Math.min(0, size - pos * maxStackSize);
        return actualSize;
    }

    public int getSlots() {
        return this.size * this.numStacks;
    }

    public int getLargeSize() {
        return this.size;
    }

    public StoredItemStack getLargeStack(int slot) {
        if (this.size > slot) {
            return this.slots[slot];
        }
        return null;
    }

    public void setLargeStack(int slot, StoredItemStack stack) {
        this.slots[slot] = stack;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        int maxAdd;
        int target;
        StoredItemStack stored;
        if (stack != null && stack.field_77994_a != 0 && ((stored = this.slots[target = (int)Math.floor(slot / this.numStacks)]) == null || stored.getStackSize() == 0L || stored.equalStack(stack) && stored.getStackSize() < (long)(this.numStacks * stack.func_77976_d())) && (maxAdd = (int)Math.min((long)(this.numStacks * stack.func_77976_d()) - (stored != null ? stored.getStackSize() : 0L), (long)stack.field_77994_a)) != 0) {
            if (!simulate) {
                if (stored != null) {
                    stored.stored += (long)maxAdd;
                } else {
                    stored = this.slots[target] = new StoredItemStack(stack.func_77946_l(), maxAdd);
                }
            }
            return maxAdd == stack.field_77994_a ? null : new StoredItemStack(stack.func_77946_l()).setStackSize(stack.field_77994_a - maxAdd).getActualStack();
        }
        return stack;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack stack = this.getStackInSlot(slot);
        if (stack != null) {
            int toRemove = Math.min(amount, stack.field_77994_a);
            if (toRemove == 0) {
                return null;
            }
            int target = (int)Math.floor(slot / this.numStacks);
            StoredItemStack stored = this.slots[target];
            if (!simulate) {
                stored.stored -= (long)toRemove;
                if (stored.stored == 0L) {
                    this.slots[target] = null;
                }
            }
            return new StoredItemStack(stack.func_77946_l()).setStackSize(toRemove).getActualStack();
        }
        return null;
    }

    public boolean isItemValidForSlot(int slot, ItemStack item) {
        return true;
    }

    public void markDirty() {
        this.tile.func_70296_d();
    }

    @Override
    public void writeToBuf(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.writeData(new NBTTagCompound(), NBTHelper.SyncType.SAVE));
    }

    @Override
    public void readFromBuf(ByteBuf buf) {
        this.readData(ByteBufUtils.readTag((ByteBuf)buf), NBTHelper.SyncType.SAVE);
    }

    @Override
    public boolean canSync(NBTHelper.SyncType sync) {
        return sync == NBTHelper.SyncType.SAVE;
    }

    @Override
    public String getTagName() {
        return "Items";
    }
}

