/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.network;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import mcmultipart.multipart.IMultipart;
import mcmultipart.multipart.IMultipartContainer;
import mcmultipart.multipart.MultipartHelper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.PacketTileEntityHandler;
import sonar.core.network.PacketTileSync;

public class PacketMultipartSync
extends PacketTileSync {
    public UUID partUUID;

    public PacketMultipartSync() {
    }

    public PacketMultipartSync(BlockPos pos, NBTTagCompound tag, UUID partUUID) {
        super(pos, tag);
        this.partUUID = partUUID;
    }

    public PacketMultipartSync(BlockPos pos, NBTTagCompound tag, NBTHelper.SyncType type, UUID partUUID) {
        super(pos, tag, type);
        this.partUUID = partUUID;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        long msb = buf.readLong();
        long lsb = buf.readLong();
        this.partUUID = new UUID(msb, lsb);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeLong(this.partUUID.getMostSignificantBits());
        buf.writeLong(this.partUUID.getLeastSignificantBits());
    }

    public static class Handler
    extends PacketTileEntityHandler<PacketMultipartSync> {
        @Override
        public IMessage processMessage(PacketMultipartSync message, TileEntity tile) {
            if (tile.func_145831_w().field_72995_K) {
                IMultipart part;
                IMultipartContainer container = MultipartHelper.getPartContainer((IBlockAccess)tile.func_145831_w(), (BlockPos)tile.func_174877_v());
                if (container != null && (part = container.getPartFromID(message.partUUID)) != null && part instanceof INBTSyncable) {
                    INBTSyncable sync = (INBTSyncable)part;
                    sync.readData(message.tag, message.type != null ? message.type : NBTHelper.SyncType.DEFAULT_SYNC);
                }
                tile.func_145831_w().func_175726_f(tile.func_174877_v()).func_76630_e();
            }
            return null;
        }
    }
}

