/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.helpers.NBTHelper;
import sonar.core.integration.fmp.OLDMultipartHelper;
import sonar.core.network.PacketCoords;
import sonar.core.network.PacketTileEntityHandler;

public class PacketTileSync
extends PacketCoords<PacketTileSync> {
    public NBTTagCompound tag;
    public NBTHelper.SyncType type;

    public PacketTileSync() {
    }

    public PacketTileSync(BlockPos pos, NBTTagCompound tag) {
        super(pos);
        this.tag = tag;
    }

    public PacketTileSync(BlockPos pos, NBTTagCompound tag, NBTHelper.SyncType type) {
        super(pos);
        this.tag = tag;
        this.type = type;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.tag = ByteBufUtils.readTag((ByteBuf)buf);
        if (buf.readBoolean()) {
            this.type = NBTHelper.SyncType.values()[buf.readByte()];
        }
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.tag);
        if (this.type == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.writeByte(this.type.ordinal());
        }
    }

    public static class Handler
    extends PacketTileEntityHandler<PacketTileSync> {
        @Override
        public IMessage processMessage(PacketTileSync message, TileEntity tile) {
            if (tile.func_145831_w().field_72995_K) {
                Object te = OLDMultipartHelper.checkObject(tile);
                if (te == null) {
                    return null;
                }
                NBTHelper.SyncType type = NBTHelper.SyncType.DEFAULT_SYNC;
                if (message.type != null) {
                    type = message.type;
                }
                if (te instanceof INBTSyncable) {
                    INBTSyncable sync = (INBTSyncable)te;
                    sync.readData(message.tag, type);
                }
            }
            return null;
        }
    }
}

