/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.network.sync;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.sync.ObjectType;
import sonar.core.network.sync.SyncPart;

public class SyncUnidentifiedObject
extends SyncPart {
    public Object obj = null;
    public ObjectType objectType = null;

    public SyncUnidentifiedObject(int id) {
        super(id);
    }

    public void set(Object obj, ObjectType objectType) {
        if (!(obj == null || this.obj != null && obj.equals(this.obj))) {
            this.obj = obj;
            this.objectType = objectType;
            this.setChanged(true);
        }
    }

    @Nullable
    public Object get() {
        return this.obj;
    }

    public boolean hasObject() {
        return this.obj != null && this.objectType != null;
    }

    public boolean hasObject(NBTTagCompound tag) {
        return tag.func_74764_b(this.getTagName() + "obj");
    }

    @Override
    public void writeToBuf(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.writeData(new NBTTagCompound(), NBTHelper.SyncType.SAVE));
    }

    @Override
    public void readFromBuf(ByteBuf buf) {
        this.readData(ByteBufUtils.readTag((ByteBuf)buf), NBTHelper.SyncType.SAVE);
    }

    @Override
    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (this.hasObject()) {
            nbt.func_74768_a(this.getTagName() + "type", this.objectType.ordinal());
            NBTHelper.writeNBTBase(nbt, this.objectType.tagType, this.obj, this.getTagName() + "obj");
        }
        return nbt;
    }

    @Override
    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (this.hasObject(nbt)) {
            this.objectType = ObjectType.values()[nbt.func_74762_e(this.getTagName() + "type")];
            this.obj = NBTHelper.readNBTBase(nbt, this.objectType.tagType, this.getTagName() + "obj");
        }
    }
}

