/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.recipes;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import sonar.core.SonarCore;
import sonar.core.helpers.ItemStackHelper;
import sonar.core.recipes.DefaultSonarRecipe;
import sonar.core.recipes.ISonarRecipe;
import sonar.core.recipes.ISonarRecipeObject;
import sonar.core.recipes.OreStack;
import sonar.core.recipes.RecipeInterchangable;
import sonar.core.recipes.RecipeItemStack;
import sonar.core.utils.Pair;

public abstract class RecipeHelperV2 {
    public ArrayList<ISonarRecipe> recipes = new ArrayList();
    public ArrayList<Class<?>> validInputs = Lists.newArrayList((Object[])new Class[]{ISonarRecipeObject.class, ItemStack.class, Item.class, Block.class, ItemStack[].class, List.class});
    public ArrayList<Class<?>> validOutputs = Lists.newArrayList((Object[])new Class[]{ISonarRecipeObject.class, ItemStack.class, Item.class, Block.class});
    public ArrayList<Class<?>> adjusted = Lists.newArrayList((Object[])new Class[]{Item.class, Block.class});

    public abstract String getRecipeID();

    public ArrayList<ISonarRecipe> getRecipes() {
        return this.recipes;
    }

    public ISonarRecipe getRecipeFromInputs(List inputs) {
        for (ISonarRecipe recipe : this.recipes) {
            if (!recipe.matchingInputs(inputs)) continue;
            return recipe;
        }
        return null;
    }

    public ISonarRecipe getRecipeFromOutputs(List outputs) {
        for (ISonarRecipe recipe : this.recipes) {
            if (!recipe.matchingOutputs(outputs)) continue;
            return recipe;
        }
        return null;
    }

    public boolean addRecipe(ISonarRecipe recipe) {
        if (recipe != null) {
            return this.recipes.add(recipe);
        }
        return false;
    }

    public boolean removeRecipe(ISonarRecipe recipe) {
        if (recipe != null) {
            return this.recipes.remove(recipe);
        }
        return false;
    }

    public void addValidInput(Class inputTypes) {
        this.validInputs.add(inputTypes);
    }

    public boolean isValidInput(Object input) {
        for (Class<?> inputType : this.validInputs) {
            List list;
            if (!(inputType == List.class ? !(list = (List)input).isEmpty() && this.isValidInput(list.get(0)) : inputType.isInstance(input))) continue;
            return true;
        }
        return false;
    }

    public boolean isValidOutput(Object output) {
        for (Class<?> outputType : this.validOutputs) {
            if (!outputType.isInstance(output)) continue;
            return true;
        }
        return false;
    }

    public boolean requiresAdjustment(Object obj) {
        for (Class<?> objectType : this.adjusted) {
            if (!objectType.isInstance(obj)) continue;
            return true;
        }
        return false;
    }

    public Object adjustObject(Object obj) {
        return ItemStackHelper.createStack(obj);
    }

    public ISonarRecipeObject buildRecipeObject(Object obj) {
        if (this.requiresAdjustment(obj)) {
            obj = this.adjustObject(obj);
        }
        if (obj instanceof ISonarRecipeObject) {
            return (ISonarRecipeObject)obj;
        }
        if (obj instanceof List) {
            List list = (List)obj;
            ArrayList<ISonarRecipeObject> buildList = new ArrayList<ISonarRecipeObject>();
            if (!list.isEmpty()) {
                for (Object listObj : list) {
                    if (listObj == null) continue;
                    ISonarRecipeObject recipeObject = this.buildRecipeObject(listObj);
                    if (recipeObject != null) {
                        buildList.add(recipeObject);
                        continue;
                    }
                    return null;
                }
                return new RecipeInterchangable(buildList);
            }
            return null;
        }
        if (obj instanceof String) {
            return new OreStack((String)obj, 1);
        }
        if (obj instanceof ItemStack) {
            return new RecipeItemStack((ItemStack)obj);
        }
        return null;
    }

    public void addRecipe(List inputs, List outputs) {
        this.addRecipe(this.buildDefaultRecipe(inputs, outputs));
    }

    public ISonarRecipe buildDefaultRecipe(List inputs, List outputs) {
        ArrayList recipeInputs = Lists.newArrayList();
        ArrayList recipeOutputs = Lists.newArrayList();
        for (Pair builder : Lists.newArrayList((Object[])new Pair[]{new Pair<List, ArrayList>(inputs, recipeInputs), new Pair<List, ArrayList>(outputs, recipeOutputs)})) {
            for (Object obj : (List)builder.a) {
                if (this.isValidInput(obj)) {
                    recipeInputs.add(this.buildRecipeObject(obj));
                    continue;
                }
                SonarCore.logger.error("Invalid recipe value! " + obj);
                return null;
            }
        }
        return new DefaultSonarRecipe(recipeOutputs, recipeOutputs);
    }

    public static boolean matchingIngredients(ArrayList<ISonarRecipeObject> ingredients, Object ... objs) {
        ArrayList matches = (ArrayList)ingredients.clone();
        for (Object obj : objs) {
            ISonarRecipeObject ingredient2;
            block2: {
                for (ISonarRecipeObject ingredient2 : (ArrayList)matches.clone()) {
                    if (!ingredient2.matches(obj)) continue;
                    break block2;
                }
                return false;
            }
            matches.remove(ingredient2);
        }
        return true;
    }
}

