/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.upgrades;

import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import sonar.core.SonarCore;
import sonar.core.api.upgrades.IUpgradeInventory;
import sonar.core.helpers.NBTHelper;

public class UpgradeInventory
implements IUpgradeInventory {
    public ArrayList<String> allowed = new ArrayList();
    public THashMap<String, Integer> upgrades = new THashMap();
    public THashMap<String, Integer> maxUpgrades = new THashMap();
    public boolean markDirty = true;

    public UpgradeInventory(int max, Object ... allowed) {
        for (Object object : allowed) {
            if (object == null || !(object instanceof String)) continue;
            this.allowed.add((String)object);
        }
        for (String type : this.allowed) {
            this.upgrades.put((Object)type, (Object)0);
            this.maxUpgrades.put((Object)type, (Object)max);
        }
        if (allowed.length == 0) {
            SonarCore.logger.warn("Upgradable Inventory: has no allowed Upgrade Types");
        }
    }

    public UpgradeInventory addMaxiumum(String type, int max) {
        this.maxUpgrades.put((Object)type, (Object)max);
        return this;
    }

    @Override
    public boolean addUpgrade(ItemStack stack) {
        String upgrade;
        if (stack != null && (upgrade = (String)SonarCore.machineUpgrades.getSecondaryObject(stack.func_77973_b())) != null && this.allowed.contains(upgrade) && ((Integer)this.maxUpgrades.get((Object)upgrade)).intValue() != ((Integer)this.upgrades.get((Object)upgrade)).intValue()) {
            this.upgrades.put((Object)upgrade, (Object)((Integer)this.upgrades.get((Object)upgrade) + 1));
            this.markDirty = true;
            return true;
        }
        return false;
    }

    @Override
    public ItemStack removeUpgrade(String type, int amount) {
        int stored;
        if (this.upgrades.containsKey((Object)type) && (stored = ((Integer)this.upgrades.get((Object)type)).intValue()) != 0) {
            int remove = Math.min(amount, stored);
            Item item = (Item)SonarCore.machineUpgrades.getPrimaryObject(type);
            if (item != null) {
                this.upgrades.put((Object)type, (Object)(stored - remove));
                return new ItemStack(item, remove);
            }
        }
        return null;
    }

    @Override
    public int getUpgradesInstalled(String upgrade) {
        if (this.upgrades.get((Object)upgrade) == null) {
            return 0;
        }
        return (Integer)this.upgrades.get((Object)upgrade);
    }

    public ArrayList<ItemStack> getDrops() {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (Map.Entry entry : this.upgrades.entrySet()) {
            Item item = (Item)SonarCore.machineUpgrades.getPrimaryObject(entry.getKey());
            if (item == null || (Integer)entry.getValue() == 0) continue;
            drops.add(new ItemStack(item, ((Integer)entry.getValue()).intValue()));
            this.upgrades.put(entry.getKey(), (Object)0);
        }
        this.markDirty = true;
        return drops;
    }

    @Override
    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (type == NBTHelper.SyncType.SAVE || type.isType(NBTHelper.SyncType.DEFAULT_SYNC) && this.markDirty) {
            NBTTagCompound upgradeTag = new NBTTagCompound();
            for (Map.Entry entry : this.upgrades.entrySet()) {
                upgradeTag.func_74768_a((String)entry.getKey(), ((Integer)entry.getValue()).intValue());
            }
            if (!upgradeTag.func_82582_d()) {
                nbt.func_74782_a("Upgrades", (NBTBase)upgradeTag);
            }
            if (type.isType(NBTHelper.SyncType.DEFAULT_SYNC)) {
                this.markDirty = false;
            }
        }
        return nbt;
    }

    @Override
    public void readData(NBTTagCompound tag, NBTHelper.SyncType type) {
        NBTTagCompound upgradeTag;
        if ((type == NBTHelper.SyncType.SAVE || type.isType(NBTHelper.SyncType.DEFAULT_SYNC)) && (upgradeTag = tag.func_74775_l("Upgrades")) != null && !upgradeTag.func_82582_d()) {
            for (String key : upgradeTag.func_150296_c()) {
                this.upgrades.put((Object)key, (Object)upgradeTag.func_74762_e(key));
            }
        }
    }

    @Override
    public ArrayList<String> getAllowedUpgrades() {
        return this.allowed;
    }

    @Override
    public THashMap<String, Integer> getInstalledUpgrades() {
        return this.upgrades;
    }
}

