/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.utils;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import sonar.core.SonarCore;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.PacketSonarSides;
import sonar.core.network.sync.DirtyPart;
import sonar.core.network.sync.ISyncPart;
import sonar.core.utils.IMachineSides;
import sonar.core.utils.MachineSideConfig;

public class MachineSides
extends DirtyPart
implements ISyncPart {
    public MachineSideConfig[] configs;
    public ArrayList<EnumFacing> allowedDirs;
    public ArrayList<MachineSideConfig> allowedSides;
    public MachineSideConfig def;
    public TileEntity tile;

    public MachineSides(MachineSideConfig def, TileEntity tile, Object ... blocked) {
        this.def = def;
        this.tile = tile;
        if (!(tile instanceof IMachineSides)) {
            SonarCore.logger.warn("Machine Sides: TileEntity doesn't implement IMachineSides!");
        }
        this.configs = new MachineSideConfig[]{def, def, def, def, def, def};
        ArrayList allowedDirs = Lists.newArrayList((Object[])EnumFacing.field_82609_l);
        ArrayList allowedSides = Lists.newArrayList((Object[])MachineSideConfig.ALLOWED_VALUES);
        for (Object object : blocked) {
            if (object == null) continue;
            if (object instanceof EnumFacing) {
                allowedDirs.remove((EnumFacing)object);
            }
            if (!(object instanceof MachineSideConfig)) continue;
            allowedSides.remove((Object)((MachineSideConfig)((Object)object)));
        }
        if (allowedDirs.isEmpty() || allowedSides.isEmpty()) {
            SonarCore.logger.warn("Machine Sides can't have no allowed directions/sides");
            this.allowedDirs = Lists.newArrayList((Object[])EnumFacing.field_82609_l);
            this.allowedSides = Lists.newArrayList((Object[])MachineSideConfig.ALLOWED_VALUES);
        } else {
            this.allowedDirs = allowedDirs;
            this.allowedSides = allowedSides;
        }
    }

    public void sendPacket(int dimension, EnumFacing side) {
        if (this.tile instanceof IMachineSides) {
            BlockPos pos = this.tile.func_174877_v();
            SonarCore.network.sendToAllAround((IMessage)new PacketSonarSides(pos, side, this.getSideConfig(side)), new NetworkRegistry.TargetPoint(dimension, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 64.0));
        }
    }

    public boolean decreaseSide(EnumFacing side) {
        if (!this.allowedDirs.contains(side)) {
            return false;
        }
        if (!this.tile.func_145831_w().field_72995_K) {
            String name = this.configs[side.func_176745_a()].func_176610_l();
            int pos = 0;
            for (MachineSideConfig configs : this.allowedSides) {
                if (configs.func_176610_l().equals(name)) continue;
                ++pos;
            }
            this.configs[side.func_176745_a()] = this.allowedSides.get((pos == 0 ? this.allowedSides.size() : pos) - 1);
            this.sendPacket(this.tile.func_145831_w().field_73011_w.getDimension(), side);
        }
        this.setChanged(true);
        return true;
    }

    public boolean increaseSide(EnumFacing side) {
        if (!this.allowedDirs.contains(side)) {
            return false;
        }
        if (!this.tile.func_145831_w().field_72995_K) {
            String name = this.configs[side.func_176745_a()].func_176610_l();
            int pos = 0;
            for (MachineSideConfig configs : this.allowedSides) {
                if (configs.func_176610_l().equals(name)) break;
                ++pos;
            }
            this.configs[side.func_176745_a()] = this.allowedSides.get(this.allowedSides.size() <= pos + 1 ? 0 : pos + 1);
            this.sendPacket(this.tile.func_145831_w().field_73011_w.getDimension(), side);
        }
        this.setChanged(true);
        return true;
    }

    public boolean setSide(EnumFacing side, MachineSideConfig config) {
        if (this.allowedDirs.contains(side) && this.allowedSides.contains((Object)config)) {
            this.configs[side.func_176745_a()] = config;
            this.setChanged(true);
            return true;
        }
        return false;
    }

    public boolean resetSides() {
        MachineSideConfig[] sides = new MachineSideConfig[]{this.def, this.def, this.def, this.def, this.def, this.def};
        return true;
    }

    public MachineSideConfig getSideConfig(EnumFacing side) {
        if (!this.allowedDirs.contains(side)) {
            return MachineSideConfig.NONE;
        }
        return this.configs[side.func_176745_a()];
    }

    public ArrayList<EnumFacing> getSidesWithConfig(MachineSideConfig side) {
        ArrayList<EnumFacing> sides = new ArrayList<EnumFacing>();
        for (EnumFacing facing : this.allowedDirs) {
            if (this.configs[facing.func_176745_a()].name() != side.name()) continue;
            sides.add(facing);
        }
        return sides;
    }

    public MachineSideConfig[] getConfigs() {
        return this.configs;
    }

    @Override
    public void writeToBuf(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.writeData(new NBTTagCompound(), NBTHelper.SyncType.SAVE));
    }

    @Override
    public void readFromBuf(ByteBuf buf) {
        this.readData(ByteBufUtils.readTag((ByteBuf)buf), NBTHelper.SyncType.SAVE);
    }

    @Override
    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        NBTTagCompound sideNBT = new NBTTagCompound();
        for (int i = 0; i < 6; ++i) {
            sideNBT.func_74768_a("" + i, this.configs[i].ordinal());
        }
        nbt.func_74782_a(this.getTagName(), (NBTBase)sideNBT);
        return nbt;
    }

    @Override
    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        NBTTagCompound sideNBT = nbt.func_74775_l(this.getTagName());
        for (int i = 0; i < 6; ++i) {
            MachineSideConfig side;
            if (!sideNBT.func_74764_b("" + i) || (side = MachineSideConfig.values()[sideNBT.func_74762_e("" + i)]) == null) continue;
            this.configs[i] = side;
        }
    }

    @Override
    public boolean canSync(NBTHelper.SyncType sync) {
        return sync.isType(NBTHelper.SyncType.SAVE, NBTHelper.SyncType.DEFAULT_SYNC);
    }

    @Override
    public String getTagName() {
        return "sides";
    }
}

