/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.varia.WrenchChecker;
import mcjty.rftools.blocks.blockprotector.BlockProtectorTileEntity;
import mcjty.rftools.blocks.blockprotector.BlockProtectors;
import mcjty.rftools.blocks.environmental.NoTeleportAreaManager;
import mcjty.rftools.blocks.environmental.PeacefulAreaManager;
import mcjty.rftools.blocks.screens.ScreenSetup;
import mcjty.rftools.blocks.teleporter.TeleportDestination;
import mcjty.rftools.blocks.teleporter.TeleportationTools;
import mcjty.rftools.playerprops.BuffProperties;
import mcjty.rftools.playerprops.FavoriteDestinationsProperties;
import mcjty.rftools.playerprops.PlayerExtendedProperties;
import mcjty.rftools.playerprops.PropertiesDispatcher;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.commons.lang3.tuple.Pair;

public class ForgeEventHandlers {
    private static List<Pair<TeleportDestination, EntityPlayer>> playersToTeleportHere = new ArrayList<Pair<TeleportDestination, EntityPlayer>>();

    public static void addPlayerToTeleportHere(TeleportDestination destination, EntityPlayer player) {
        playersToTeleportHere.add((Pair<TeleportDestination, EntityPlayer>)Pair.of((Object)destination, (Object)player));
    }

    private static void performDelayedTeleports() {
        if (!playersToTeleportHere.isEmpty()) {
            for (Pair<TeleportDestination, EntityPlayer> pair : playersToTeleportHere) {
                TeleportationTools.performTeleport((EntityPlayer)pair.getRight(), (TeleportDestination)pair.getLeft(), 0, 10, false);
            }
            playersToTeleportHere.clear();
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.world.field_73011_w.getDimension() == 0) {
            ForgeEventHandlers.performDelayedTeleports();
        }
    }

    @SubscribeEvent
    public void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        BuffProperties buffProperties;
        if (event.phase == TickEvent.Phase.START && !event.player.field_70170_p.field_72995_K && (buffProperties = PlayerExtendedProperties.getBuffProperties(event.player)) != null) {
            buffProperties.tickBuffs((EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void onEntityConstructing(AttachCapabilitiesEvent.Entity event) {
        if (event.getEntity() instanceof EntityPlayer && !event.getEntity().hasCapability(PlayerExtendedProperties.BUFF_CAPABILITY, null)) {
            event.addCapability(new ResourceLocation("rftools", "Properties"), (ICapabilityProvider)new PropertiesDispatcher());
        }
    }

    private Collection<GlobalCoordinate> getProtectors(World world, int x, int y, int z) {
        Collection<GlobalCoordinate> protectors;
        BlockProtectors blockProtectors = BlockProtectors.getProtectors(world);
        if (blockProtectors == null) {
            protectors = Collections.emptyList();
        } else {
            int id = world.field_73011_w.getDimension();
            protectors = blockProtectors.findProtectors(x, y, z, id, 2);
        }
        return protectors;
    }

    @SubscribeEvent
    public void onPlayerInteractEvent(PlayerInteractEvent event) {
        ItemStack heldItem;
        if (event instanceof PlayerInteractEvent.LeftClickBlock) {
            this.checkCreativeClick(event);
        }
        if ((heldItem = event.getEntityPlayer().func_184586_b(event.getHand())) == null || heldItem.func_77973_b() == null) {
            return;
        }
        if (event.getEntityPlayer().func_70093_af() && WrenchChecker.isAWrench((Item)heldItem.func_77973_b())) {
            World world = event.getWorld();
            int x = event.getPos().func_177958_n();
            int y = event.getPos().func_177956_o();
            int z = event.getPos().func_177952_p();
            Collection<GlobalCoordinate> protectors = this.getProtectors(world, x, y, z);
            this.checkHarvestProtection((Event)event, x, y, z, world, protectors);
        }
    }

    @SubscribeEvent
    public void onBlockBreakEvent(BlockEvent.BreakEvent event) {
        int x = event.getPos().func_177958_n();
        int y = event.getPos().func_177956_o();
        int z = event.getPos().func_177952_p();
        World world = event.getWorld();
        Collection<GlobalCoordinate> protectors = this.getProtectors(world, x, y, z);
        this.checkHarvestProtection((Event)event, x, y, z, world, protectors);
    }

    private void checkCreativeClick(PlayerInteractEvent event) {
        Block block;
        if (event.getEntityPlayer().func_184812_l_() && ((block = event.getWorld().func_180495_p(event.getPos()).func_177230_c()) == ScreenSetup.screenBlock || block == ScreenSetup.creativeScreenBlock || block == ScreenSetup.screenHitBlock) && !event.getEntityPlayer().func_70093_af()) {
            if (event.getWorld().field_72995_K) {
                block.func_180649_a(event.getWorld(), event.getPos(), event.getEntityPlayer());
            }
            event.setCanceled(true);
        }
    }

    private void checkHarvestProtection(Event event, int x, int y, int z, World world, Collection<GlobalCoordinate> protectors) {
        for (GlobalCoordinate protector : protectors) {
            BlockPos relative;
            BlockProtectorTileEntity blockProtectorTileEntity;
            boolean b;
            TileEntity te = world.func_175625_s(protector.getCoordinate());
            if (!(te instanceof BlockProtectorTileEntity) || !(b = (blockProtectorTileEntity = (BlockProtectorTileEntity)te).isProtected(relative = blockProtectorTileEntity.absoluteToRelative(x, y, z)))) continue;
            if (blockProtectorTileEntity.attemptHarvestProtection()) {
                event.setCanceled(true);
            } else {
                blockProtectorTileEntity.removeProtection(relative);
            }
            return;
        }
    }

    @SubscribeEvent
    public void onDetonate(ExplosionEvent.Detonate event) {
        Explosion explosion = event.getExplosion();
        Vec3d explosionVector = explosion.getPosition();
        Collection<GlobalCoordinate> protectors = this.getProtectors(event.getWorld(), (int)explosionVector.field_72450_a, (int)explosionVector.field_72448_b, (int)explosionVector.field_72449_c);
        if (protectors.isEmpty()) {
            return;
        }
        List affectedBlocks = event.getAffectedBlocks();
        ArrayList<BlockPos> toremove = new ArrayList<BlockPos>();
        int rf = 0;
        for (GlobalCoordinate protector : protectors) {
            BlockPos pos = protector.getCoordinate();
            TileEntity te = event.getWorld().func_175625_s(pos);
            if (!(te instanceof BlockProtectorTileEntity)) continue;
            BlockProtectorTileEntity blockProtectorTileEntity = (BlockProtectorTileEntity)te;
            for (BlockPos block : affectedBlocks) {
                BlockPos relative = blockProtectorTileEntity.absoluteToRelative(block);
                boolean b = blockProtectorTileEntity.isProtected(relative);
                if (!b) continue;
                Vec3d blockVector = new Vec3d((Vec3i)block);
                double distanceTo = explosionVector.func_72438_d(blockVector);
                int rfneeded = blockProtectorTileEntity.attemptExplosionProtection((float)(distanceTo / (double)explosion.field_77280_f), explosion.field_77280_f);
                if (rfneeded > 0) {
                    toremove.add(block);
                    rf += rfneeded;
                    continue;
                }
                blockProtectorTileEntity.removeProtection(relative);
            }
        }
        affectedBlocks.removeAll(toremove);
    }

    @SubscribeEvent
    public void onEntityTeleport(EnderTeleportEvent event) {
        BlockPos coordinate;
        World world = event.getEntity().func_130014_f_();
        int id = world.field_73011_w.getDimension();
        Entity entity = event.getEntity();
        if (NoTeleportAreaManager.isTeleportPrevented(entity, new GlobalCoordinate(coordinate = new BlockPos((int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v), id))) {
            event.setCanceled(true);
        } else {
            coordinate = new BlockPos((int)event.getTargetX(), (int)event.getTargetY(), (int)event.getTargetZ());
            if (NoTeleportAreaManager.isTeleportPrevented(entity, new GlobalCoordinate(coordinate, id))) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onEntitySpawnEvent(LivingSpawnEvent.CheckSpawn event) {
        BlockPos coordinate;
        World world = event.getWorld();
        int id = world.field_73011_w.getDimension();
        Entity entity = event.getEntity();
        if (entity instanceof IMob && PeacefulAreaManager.isPeaceful(new GlobalCoordinate(coordinate = new BlockPos((int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v), id))) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onPlayerCloned(PlayerEvent.Clone event) {
        if (event.isWasDeath() && event.getOriginal().hasCapability(PlayerExtendedProperties.FAVORITE_DESTINATIONS_CAPABILITY, null)) {
            FavoriteDestinationsProperties oldFavorites = (FavoriteDestinationsProperties)event.getOriginal().getCapability(PlayerExtendedProperties.FAVORITE_DESTINATIONS_CAPABILITY, null);
            FavoriteDestinationsProperties newFavorites = PlayerExtendedProperties.getFavoriteDestinations(event.getEntityPlayer());
            newFavorites.copyFrom(oldFavorites);
        }
    }
}

