/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.blockprotector;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import mcjty.lib.api.information.IMachineInformation;
import mcjty.lib.api.smartwrench.SmartWrenchSelector;
import mcjty.lib.entity.GenericEnergyReceiverTileEntity;
import mcjty.lib.network.Argument;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.RedstoneMode;
import mcjty.rftools.blocks.blockprotector.BlockProtectorConfiguration;
import mcjty.rftools.blocks.blockprotector.BlockProtectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;

public class BlockProtectorTileEntity
extends GenericEnergyReceiverTileEntity
implements SmartWrenchSelector,
ITickable,
IMachineInformation {
    public static final String CMD_RSMODE = "rsMode";
    public static final String COMPONENT_NAME = "block_protector";
    private int id = -1;
    private boolean active = false;
    private Set<BlockPos> protectedBlocks = new HashSet<BlockPos>();

    public BlockProtectorTileEntity() {
        super(BlockProtectorConfiguration.MAXENERGY, BlockProtectorConfiguration.RECEIVEPERTICK);
    }

    public int getEnergyDiffPerTick() {
        return this.active ? -this.getRfPerTick() : 0;
    }

    @Nullable
    public String getEnergyUnitName() {
        return "RF";
    }

    public boolean isMachineActive() {
        return this.active;
    }

    public boolean isMachineRunning() {
        return this.active;
    }

    @Nullable
    public String getMachineStatus() {
        return this.active ? "protecting blocks" : "idle";
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.checkStateServer();
        }
    }

    private void checkStateServer() {
        if (this.protectedBlocks.isEmpty()) {
            this.setActive(false);
            return;
        }
        if (!this.isMachineEnabled()) {
            this.setActive(false);
            return;
        }
        this.setActive(true);
        this.consumeEnergy(this.getRfPerTick());
    }

    private int getRfPerTick() {
        return this.protectedBlocks.size() * BlockProtectorConfiguration.rfPerProtectedBlock;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        boolean oldActive = this.active;
        super.onDataPacket(net, packet);
        if (this.field_145850_b.field_72995_K && this.active != oldActive) {
            this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
        }
    }

    public boolean isActive() {
        return this.active;
    }

    private void setActive(boolean a) {
        this.active = a;
        this.markDirtyClient();
    }

    public boolean attemptHarvestProtection() {
        if (!this.isMachineEnabled()) {
            return false;
        }
        int rf = this.getEnergyStored(EnumFacing.DOWN);
        if (BlockProtectorConfiguration.rfForHarvestAttempt > rf) {
            return false;
        }
        this.consumeEnergy(BlockProtectorConfiguration.rfForHarvestAttempt);
        return true;
    }

    public int attemptExplosionProtection(float distance, float radius) {
        if (!this.isMachineEnabled()) {
            return -1;
        }
        int rf = this.getEnergyStored(EnumFacing.DOWN);
        int rfneeded = (int)((double)BlockProtectorConfiguration.rfForExplosionProtection * (1.0 - (double)distance) * (double)radius / 8.0) + 1;
        if ((rfneeded = (int)((float)rfneeded * (2.0f - this.getInfusedFactor()) / 2.0f)) > rf) {
            return -1;
        }
        if (rfneeded <= 0) {
            rfneeded = 1;
        }
        this.consumeEnergy(rfneeded);
        return rfneeded;
    }

    public Set<BlockPos> getProtectedBlocks() {
        return this.protectedBlocks;
    }

    public BlockPos absoluteToRelative(BlockPos c) {
        return this.absoluteToRelative(c.func_177958_n(), c.func_177956_o(), c.func_177952_p());
    }

    public BlockPos absoluteToRelative(int x, int y, int z) {
        return new BlockPos(x - this.func_174877_v().func_177958_n(), y - this.func_174877_v().func_177956_o(), z - this.func_174877_v().func_177952_p());
    }

    public boolean isProtected(BlockPos c) {
        return this.protectedBlocks.contains(c);
    }

    public void removeProtection(BlockPos relative) {
        this.protectedBlocks.remove(relative);
        this.markDirtyClient();
    }

    public void toggleCoordinate(GlobalCoordinate c) {
        if (c.getDimension() != this.field_145850_b.field_73011_w.getDimension()) {
            return;
        }
        BlockPos relative = this.absoluteToRelative(c.getCoordinate());
        if (this.protectedBlocks.contains(relative)) {
            this.protectedBlocks.remove(relative);
        } else {
            this.protectedBlocks.add(relative);
        }
        this.markDirtyClient();
    }

    public void selectBlock(EntityPlayer player, BlockPos pos) {
        int xCoord = this.func_174877_v().func_177958_n();
        int yCoord = this.func_174877_v().func_177956_o();
        int zCoord = this.func_174877_v().func_177952_p();
        if (Math.abs(pos.func_177958_n() - xCoord) > BlockProtectorConfiguration.maxProtectDistance || Math.abs(pos.func_177956_o() - yCoord) > BlockProtectorConfiguration.maxProtectDistance || Math.abs(pos.func_177952_p() - zCoord) > BlockProtectorConfiguration.maxProtectDistance) {
            Logging.message((EntityPlayer)player, (String)(TextFormatting.RED + "Block out of range of the block protector!"));
            return;
        }
        GlobalCoordinate gc = new GlobalCoordinate(pos, this.field_145850_b.field_73011_w.getDimension());
        this.toggleCoordinate(gc);
    }

    public int getOrCalculateID() {
        if (this.id == -1) {
            BlockProtectors protectors = BlockProtectors.getProtectors(this.field_145850_b);
            GlobalCoordinate gc = new GlobalCoordinate(this.func_174877_v(), this.field_145850_b.field_73011_w.getDimension());
            this.id = protectors.getNewId(gc);
            protectors.save(this.field_145850_b);
            this.setId(this.id);
        }
        return this.id;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
        this.markDirtyClient();
    }

    public void updateDestination() {
        BlockProtectors protectors = BlockProtectors.getProtectors(this.field_145850_b);
        GlobalCoordinate gc = new GlobalCoordinate(this.func_174877_v(), this.field_145850_b.field_73011_w.getDimension());
        if (this.id == -1) {
            this.id = protectors.getNewId(gc);
            this.func_70296_d();
        } else {
            protectors.assignId(gc, this.id);
        }
        protectors.save(this.field_145850_b);
        this.markDirtyClient();
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        NBTTagList tagList = tagCompound.func_150295_c("coordinates", 10);
        this.protectedBlocks.clear();
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = (NBTTagCompound)tagList.func_179238_g(i);
            this.protectedBlocks.add(BlockPosTools.readFromNBT((NBTTagCompound)tag, (String)"c"));
        }
        this.active = tagCompound.func_74767_n("active");
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.id = tagCompound.func_74764_b("protectorId") ? tagCompound.func_74762_e("protectorId") : -1;
        byte m = tagCompound.func_74771_c(CMD_RSMODE);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        NBTTagList list = new NBTTagList();
        for (BlockPos block : this.protectedBlocks) {
            list.func_74742_a((NBTBase)BlockPosTools.writeToNBT((BlockPos)block));
        }
        tagCompound.func_74782_a("coordinates", (NBTBase)list);
        tagCompound.func_74757_a("active", this.active);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.func_74768_a("protectorId", this.id);
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_RSMODE.equals(command)) {
            String m = args.get("rs").getString();
            this.setRSMode(RedstoneMode.getMode((String)m));
            return true;
        }
        return false;
    }
}

