/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.crafter;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.entity.GenericEnergyReceiverTileEntity;
import mcjty.lib.network.Argument;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.RedstoneMode;
import mcjty.rftools.blocks.crafter.CrafterConfiguration;
import mcjty.rftools.blocks.crafter.CrafterContainer;
import mcjty.rftools.blocks.crafter.CraftingRecipe;
import mcjty.rftools.items.storage.StorageFilterCache;
import mcjty.rftools.items.storage.StorageFilterItem;
import mcjty.rftools.jei.JEIRecipeAcceptor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.oredict.OreDictionary;

public class CrafterBaseTE
extends GenericEnergyReceiverTileEntity
implements ITickable,
DefaultSidedInventory,
JEIRecipeAcceptor {
    public static final int SPEED_SLOW = 0;
    public static final int SPEED_FAST = 1;
    public static final String CMD_MODE = "mode";
    public static final String CMD_REMEMBER = "remember";
    public static final String CMD_FORGET = "forget";
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, CrafterContainer.factory, 41);
    private ItemStack[] ghostSlots = new ItemStack[30];
    private CraftingRecipe[] recipes;
    private int supportedRecipes;
    private StorageFilterCache filterCache = null;
    private int speedMode = 0;
    private InventoryCrafting workInventory = new InventoryCrafting(new Container(){

        public boolean func_75145_c(EntityPlayer var1) {
            return false;
        }
    }, 3, 3);

    public CrafterBaseTE() {
        super(CrafterConfiguration.MAXENERGY, CrafterConfiguration.RECEIVEPERTICK);
        this.setSupportedRecipes(8);
    }

    protected boolean needsRedstoneMode() {
        return true;
    }

    protected boolean needsCustomInvWrapper() {
        return true;
    }

    public ItemStack[] getGhostSlots() {
        return this.ghostSlots;
    }

    @Override
    public void setGridContents(List<ItemStack> stacks) {
        this.func_70299_a(9, stacks.get(0));
        for (int i = 1; i < stacks.size(); ++i) {
            this.func_70299_a(0 + i - 1, stacks.get(i));
        }
    }

    public void selectRecipe(int index) {
        this.func_70299_a(9, this.recipes[index].getResult());
        for (int i = 0; i < this.recipes[index].getInventory().func_70302_i_(); ++i) {
            this.func_70299_a(0 + i, this.recipes[index].getInventory().func_70301_a(i));
        }
    }

    public void setSupportedRecipes(int supportedRecipes) {
        this.supportedRecipes = supportedRecipes;
        this.recipes = new CraftingRecipe[supportedRecipes];
        for (int i = 0; i < this.recipes.length; ++i) {
            this.recipes[i] = new CraftingRecipe();
        }
    }

    public int getSupportedRecipes() {
        return this.supportedRecipes;
    }

    public int getSpeedMode() {
        return this.speedMode;
    }

    public void setSpeedMode(int speedMode) {
        this.speedMode = speedMode;
        this.markDirtyClient();
    }

    public CraftingRecipe getRecipe(int index) {
        return this.recipes[index];
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (index == 40) {
            this.filterCache = null;
        }
        this.inventoryHelper.setInventorySlotContents(this.func_70297_j_(), index, stack);
    }

    public ItemStack func_70298_a(int index, int count) {
        if (index == 40) {
            this.filterCache = null;
        }
        return this.getInventoryHelper().decrStackSize(index, count);
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    private void getFilterCache() {
        if (this.filterCache == null) {
            this.filterCache = StorageFilterItem.getCache(this.inventoryHelper.getStackInSlot(40));
        }
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        ItemStack ghostSlot;
        if (index >= 0 && index <= 9) {
            return false;
        }
        if (index >= 10 && index < 36) {
            ItemStack ghostSlot2 = this.ghostSlots[index - 10];
            if (ghostSlot2 != null && !ghostSlot2.func_77969_a(stack)) {
                return false;
            }
            if (this.inventoryHelper.containsItem(40)) {
                this.getFilterCache();
                if (this.filterCache != null) {
                    return this.filterCache.match(stack);
                }
            }
        } else if (index >= 36 && index < 40 && (ghostSlot = this.ghostSlots[index - 36 + 26]) != null && !ghostSlot.func_77969_a(stack)) {
            return false;
        }
        return true;
    }

    public int[] func_180463_a(EnumFacing side) {
        return CrafterContainer.factory.getAccessibleSlots();
    }

    public boolean func_180462_a(int index, ItemStack stack, EnumFacing direction) {
        if (!this.func_94041_b(index, stack)) {
            return false;
        }
        return CrafterContainer.factory.isInputSlot(index);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return CrafterContainer.factory.isOutputSlot(index);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
        this.readGhostBufferFromNBT(tagCompound);
        this.readRecipesFromNBT(tagCompound);
        this.speedMode = tagCompound.func_74771_c("speedMode");
    }

    private void readGhostBufferFromNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = tagCompound.func_150295_c("GItems", 10);
        for (int i = 0; i < bufferTagList.func_74745_c(); ++i) {
            NBTTagCompound nbtTagCompound = bufferTagList.func_150305_b(i);
            this.ghostSlots[i] = ItemStack.func_77949_a((NBTTagCompound)nbtTagCompound);
        }
    }

    private void readRecipesFromNBT(NBTTagCompound tagCompound) {
        NBTTagList recipeTagList = tagCompound.func_150295_c("Recipes", 10);
        for (int i = 0; i < recipeTagList.func_74745_c(); ++i) {
            NBTTagCompound nbtTagCompound = recipeTagList.func_150305_b(i);
            this.recipes[i].readFromNBT(nbtTagCompound);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
        this.writeGhostBufferToNBT(tagCompound);
        this.writeRecipesToNBT(tagCompound);
        tagCompound.func_74774_a("speedMode", (byte)this.speedMode);
    }

    private void writeGhostBufferToNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = new NBTTagList();
        for (int i = 0; i < this.ghostSlots.length; ++i) {
            ItemStack stack = this.ghostSlots[i];
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            if (stack != null) {
                stack.func_77955_b(nbtTagCompound);
            }
            bufferTagList.func_74742_a((NBTBase)nbtTagCompound);
        }
        tagCompound.func_74782_a("GItems", (NBTBase)bufferTagList);
    }

    private void writeRecipesToNBT(NBTTagCompound tagCompound) {
        NBTTagList recipeTagList = new NBTTagList();
        for (CraftingRecipe recipe : this.recipes) {
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            recipe.writeToNBT(nbtTagCompound);
            recipeTagList.func_74742_a((NBTBase)nbtTagCompound);
        }
        tagCompound.func_74782_a("Recipes", (NBTBase)recipeTagList);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.checkStateServer();
        }
    }

    protected void checkStateServer() {
        if (!this.isMachineEnabled()) {
            return;
        }
        int steps = 1;
        if (this.speedMode == 1) {
            steps = CrafterConfiguration.speedOperations;
        }
        for (int i = 0; i < steps; ++i) {
            this.craftOneCycle();
        }
    }

    private void craftOneCycle() {
        int rf = (int)((float)CrafterConfiguration.rfPerOperation * (2.0f - this.getInfusedFactor()) / 2.0f);
        if (this.getEnergyStored(EnumFacing.DOWN) < rf) {
            return;
        }
        boolean energyConsumed = false;
        for (int index = 0; index < this.supportedRecipes; ++index) {
            CraftingRecipe craftingRecipe = this.recipes[index];
            if (craftingRecipe == null || !this.craftOneItemNew(craftingRecipe)) continue;
            energyConsumed = true;
        }
        if (energyConsumed) {
            this.consumeEnergy(rf);
        }
    }

    private boolean craftOneItemNew(CraftingRecipe craftingRecipe) {
        IRecipe recipe = craftingRecipe.getCachedRecipe(this.field_145850_b);
        if (recipe == null) {
            return false;
        }
        HashMap<Integer, ItemStack> undo = new HashMap<Integer, ItemStack>();
        if (!this.testAndConsumeCraftingItems(craftingRecipe, undo, true)) {
            this.undo(undo);
            if (!this.testAndConsumeCraftingItems(craftingRecipe, undo, false)) {
                this.undo(undo);
                return false;
            }
        }
        ItemStack result = null;
        try {
            result = recipe.func_77572_b(this.workInventory);
        }
        catch (Exception e) {
            Logging.log((String)"Problem with recipe!");
        }
        CraftingRecipe.CraftMode mode = craftingRecipe.getCraftMode();
        if (result != null && this.placeResult(mode, result, undo)) {
            ItemStack[] remaining = recipe.func_179532_b(this.workInventory);
            if (remaining != null) {
                CraftingRecipe.CraftMode remainingMode = mode == CraftingRecipe.CraftMode.EXTC ? CraftingRecipe.CraftMode.INT : mode;
                for (ItemStack s : remaining) {
                    if (s == null || this.placeResult(remainingMode, s, undo)) continue;
                    this.undo(undo);
                    return false;
                }
            }
            return true;
        }
        this.undo(undo);
        return false;
    }

    private static boolean match(ItemStack target, ItemStack input, boolean strictDamage) {
        if (strictDamage) {
            return OreDictionary.itemMatches((ItemStack)target, (ItemStack)input, (boolean)false);
        }
        if (input == null && target != null || input != null && target == null) {
            return false;
        }
        return target.func_77973_b() == input.func_77973_b();
    }

    private boolean testAndConsumeCraftingItems(CraftingRecipe craftingRecipe, Map<Integer, ItemStack> undo, boolean strictDamage) {
        int keep = craftingRecipe.isKeepOne() ? 1 : 0;
        InventoryCrafting inventory = craftingRecipe.getInventory();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack != null) {
                int count = stack.field_77994_a;
                for (int j = 0; j < 26; ++j) {
                    int slotIdx = 10 + j;
                    ItemStack input = this.inventoryHelper.getStackInSlot(slotIdx);
                    if (input != null && input.field_77994_a > keep && CrafterBaseTE.match(stack, input, strictDamage)) {
                        this.workInventory.func_70299_a(i, input.func_77946_l());
                        int ss = count;
                        if (input.field_77994_a - ss < keep) {
                            ss = input.field_77994_a - keep;
                        }
                        count -= ss;
                        if (!undo.containsKey(slotIdx)) {
                            undo.put(slotIdx, input.func_77946_l());
                        }
                        input.func_77979_a(ss);
                        if (input.field_77994_a == 0) {
                            this.inventoryHelper.setStackInSlot(slotIdx, null);
                        }
                    }
                    if (count == 0) break;
                }
                if (count <= 0) continue;
                return false;
            }
            this.workInventory.func_70299_a(i, null);
        }
        IRecipe recipe = craftingRecipe.getCachedRecipe(this.field_145850_b);
        return recipe.func_77569_a(this.workInventory, this.field_145850_b);
    }

    private void undo(Map<Integer, ItemStack> undo) {
        for (Map.Entry<Integer, ItemStack> entry : undo.entrySet()) {
            this.inventoryHelper.setStackInSlot(entry.getKey().intValue(), entry.getValue());
        }
        undo.clear();
    }

    private boolean placeResult(CraftingRecipe.CraftMode mode, ItemStack result, Map<Integer, ItemStack> undo) {
        int stop;
        int start;
        if (mode == CraftingRecipe.CraftMode.INT) {
            start = 10;
            stop = 36;
        } else {
            start = 36;
            stop = 40;
        }
        return InventoryHelper.mergeItemStack((IInventory)this, (boolean)true, (ItemStack)result, (int)start, (int)stop, undo) == 0;
    }

    private void rememberItems() {
        for (int i = 0; i < this.ghostSlots.length; ++i) {
            int slotIdx = i < 26 ? i + 10 : i + 36 - 26;
            if (!this.inventoryHelper.containsItem(slotIdx)) continue;
            ItemStack stack = this.inventoryHelper.getStackInSlot(slotIdx);
            this.ghostSlots[i] = stack.func_77946_l();
            this.ghostSlots[i].field_77994_a = 1;
        }
        this.markDirtyClient();
    }

    private void forgetItems() {
        for (int i = 0; i < this.ghostSlots.length; ++i) {
            this.ghostSlots[i] = null;
        }
        this.markDirtyClient();
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_MODE.equals(command)) {
            String m = args.get("rs").getString();
            this.setRSMode(RedstoneMode.getMode((String)m));
            this.setSpeedMode(args.get("speed").getInteger());
            return true;
        }
        if (CMD_REMEMBER.equals(command)) {
            this.rememberItems();
            return true;
        }
        if (CMD_FORGET.equals(command)) {
            this.forgetItems();
            return true;
        }
        return false;
    }
}

