/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.itemfilter;

import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemFilterInvWrapper
implements IItemHandlerModifiable {
    private final ISidedInventory inv;
    private final EnumFacing side;

    public ItemFilterInvWrapper(ISidedInventory inv) {
        this(inv, null);
    }

    public ItemFilterInvWrapper(ISidedInventory inv, EnumFacing side) {
        this.inv = inv;
        this.side = side;
    }

    public static int getSlot(ISidedInventory inv, int slot, EnumFacing side) {
        int[] slots = inv.func_180463_a(side);
        if (slot < slots.length) {
            return slots[slot];
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemFilterInvWrapper that = (ItemFilterInvWrapper)o;
        if (!this.inv.equals(that.inv)) {
            return false;
        }
        return this.side == that.side;
    }

    public int hashCode() {
        int result = this.inv.hashCode();
        result = 31 * result + (this.side != null ? this.side.hashCode() : 0);
        return result;
    }

    public int getSlots() {
        return this.inv.func_180463_a(this.side).length;
    }

    public ItemStack getStackInSlot(int slot) {
        int i = ItemFilterInvWrapper.getSlot(this.inv, slot, this.side);
        return i == -1 ? null : this.inv.func_70301_a(i);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (stack == null) {
            return null;
        }
        int slot1 = ItemFilterInvWrapper.getSlot(this.inv, slot, this.side);
        if (slot1 == -1) {
            return stack;
        }
        if (!this.inv.func_94041_b(slot1, stack) || !this.inv.func_180462_a(slot1, stack, this.side)) {
            return stack;
        }
        ItemStack stackInSlot = this.inv.func_70301_a(slot1);
        if (stackInSlot != null) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)stackInSlot)) {
                return stack;
            }
            int m = Math.min(stack.func_77976_d(), this.inv.func_70297_j_()) - stackInSlot.field_77994_a;
            if (stack.field_77994_a <= m) {
                if (!simulate) {
                    ItemStack copy = stack.func_77946_l();
                    copy.field_77994_a += stackInSlot.field_77994_a;
                    this.inv.func_70299_a(slot1, copy);
                }
                return null;
            }
            stack = stack.func_77946_l();
            if (!simulate) {
                ItemStack copy = stack.func_77979_a(m);
                copy.field_77994_a += stackInSlot.field_77994_a;
                this.inv.func_70299_a(slot1, copy);
                return stack;
            }
            stack.field_77994_a -= m;
            return stack;
        }
        int m = Math.min(stack.func_77976_d(), this.inv.func_70297_j_());
        if (m < stack.field_77994_a) {
            stack = stack.func_77946_l();
            if (!simulate) {
                this.inv.func_70299_a(slot1, stack.func_77979_a(m));
                return stack;
            }
            stack.field_77994_a -= m;
            return stack;
        }
        if (!simulate) {
            this.inv.func_70299_a(slot1, stack);
        }
        return null;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.inv.func_70299_a(slot, stack);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return null;
        }
        int slot1 = ItemFilterInvWrapper.getSlot(this.inv, slot, this.side);
        if (slot1 == -1) {
            return null;
        }
        ItemStack stackInSlot = this.inv.func_70301_a(slot1);
        if (stackInSlot == null) {
            return null;
        }
        if (!this.inv.func_180461_b(slot1, stackInSlot, this.side)) {
            return null;
        }
        if (simulate) {
            if (stackInSlot.field_77994_a < amount) {
                return stackInSlot.func_77946_l();
            }
            ItemStack copy = stackInSlot.func_77946_l();
            copy.field_77994_a = amount;
            return copy;
        }
        int m = Math.min(stackInSlot.field_77994_a, amount);
        return this.inv.func_70298_a(slot1, m);
    }
}

