/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.logic.wireless;

import java.util.List;
import mcjty.lib.container.EmptyContainer;
import mcjty.rftools.blocks.logic.generic.LogicSlabBlock;
import mcjty.rftools.blocks.logic.wireless.RedstoneChannels;
import mcjty.rftools.blocks.logic.wireless.RedstoneReceiverItemBlock;
import mcjty.rftools.blocks.logic.wireless.RedstoneTransmitterTileEntity;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class RedstoneTransmitterBlock
extends LogicSlabBlock<RedstoneTransmitterTileEntity, EmptyContainer> {
    public RedstoneTransmitterBlock() {
        super(Material.field_151573_f, "redstone_transmitter_block", RedstoneTransmitterTileEntity.class, EmptyContainer.class, RedstoneReceiverItemBlock.class);
    }

    @Override
    public boolean hasRedstoneOutput() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemStack, EntityPlayer player, List<String> list, boolean whatIsThis) {
        super.addInformation(itemStack, player, list, whatIsThis);
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            int channel = tagCompound.func_74762_e("channel");
            list.add(TextFormatting.GREEN + "Channel: " + channel);
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(TextFormatting.WHITE + "This logic block accepts redstone signals and");
            list.add(TextFormatting.WHITE + "sends them out wirelessly to linked receivers");
            list.add(TextFormatting.WHITE + "Place down to create a channel or else right");
            list.add(TextFormatting.WHITE + "click on receiver/transmitter to use that channel");
        } else {
            list.add(TextFormatting.WHITE + "<Press Shift>");
        }
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        TileEntity te = world.func_175625_s(data.getPos());
        if (te instanceof RedstoneTransmitterTileEntity) {
            RedstoneTransmitterTileEntity redstoneTransmitterTileEntity = (RedstoneTransmitterTileEntity)te;
            probeInfo.text(TextFormatting.GREEN + "Channel: " + redstoneTransmitterTileEntity.getChannel());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        NBTTagCompound tagCompound = accessor.getNBTData();
        if (tagCompound != null) {
            int channel = tagCompound.func_74762_e("channel");
            currenttip.add(TextFormatting.GREEN + "Channel: " + channel);
        }
        return currenttip;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn) {
        super.func_189540_a(state, world, pos, blockIn);
        RedstoneTransmitterTileEntity te = (RedstoneTransmitterTileEntity)world.func_175625_s(pos);
        te.update();
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        if (!world.field_72995_K) {
            RedstoneTransmitterTileEntity te = (RedstoneTransmitterTileEntity)world.func_175625_s(pos);
            if (te.getChannel() == -1) {
                RedstoneChannels redstoneChannels = RedstoneChannels.getChannels(world);
                int id = redstoneChannels.newChannel();
                te.setChannel(id);
                redstoneChannels.save(world);
            }
            te.update();
        }
    }

    public int getGuiID() {
        return -1;
    }
}

