/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.monitor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.network.Argument;
import mcjty.lib.varia.EnergyTools;
import mcjty.rftools.blocks.monitor.BlockPosNet;
import mcjty.rftools.blocks.monitor.GuiRFMonitor;
import mcjty.rftools.blocks.monitor.RFMonitorMode;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;

public class RFMonitorBlockTileEntity
extends GenericTileEntity
implements ITickable {
    private BlockPos monitor;
    private RFMonitorMode alarmMode = RFMonitorMode.MODE_OFF;
    private int alarmLevel = 0;
    public static final String CMD_GETADJACENTBLOCKS = "getAdj";
    public static final String CLIENTCMD_ADJACENTBLOCKSREADY = "adjReady";
    private int counter = 20;
    private int rflevel = 0;
    private boolean inAlarm = false;

    public RFMonitorMode getAlarmMode() {
        return this.alarmMode;
    }

    public int getAlarmLevel() {
        return this.alarmLevel;
    }

    public boolean isPowered() {
        return this.inAlarm;
    }

    public void setAlarm(RFMonitorMode mode, int level) {
        this.alarmMode = mode;
        this.alarmLevel = level;
        this.markDirtyClient();
    }

    public BlockPos getMonitor() {
        return this.monitor;
    }

    public boolean isValid() {
        return this.monitor != null;
    }

    public void setInvalid() {
        if (this.monitor == null) {
            return;
        }
        this.monitor = null;
        if (this.rflevel != 0) {
            this.rflevel = 0;
            this.markDirtyClient();
        } else {
            this.func_70296_d();
        }
        this.setRedstoneOut(false);
    }

    public void setMonitor(BlockPos c) {
        this.monitor = c;
        this.markDirtyClient();
    }

    public int getRflevel() {
        return this.rflevel;
    }

    public List<BlockPos> findAdjacentBlocks() {
        int x = this.func_174877_v().func_177958_n();
        int y = this.func_174877_v().func_177956_o();
        int z = this.func_174877_v().func_177952_p();
        ArrayList<BlockPos> adjacentBlocks = new ArrayList<BlockPos>();
        for (int dy = -1; dy <= 1; ++dy) {
            int yy = y + dy;
            if (yy < 0 || yy >= this.field_145850_b.func_72800_K()) continue;
            for (int dz = -1; dz <= 1; ++dz) {
                int zz = z + dz;
                for (int dx = -1; dx <= 1; ++dx) {
                    TileEntity tileEntity;
                    int xx = x + dx;
                    if (dx == 0 && dy == 0 && dz == 0 || (tileEntity = this.field_145850_b.func_175625_s(new BlockPos(xx, yy, zz))) == null || !EnergyTools.isEnergyTE((TileEntity)tileEntity)) continue;
                    adjacentBlocks.add(new BlockPos(xx, yy, zz));
                }
            }
        }
        return adjacentBlocks;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.checkStateServer();
        }
    }

    private void checkStateServer() {
        if (!this.isValid()) {
            this.counter = 1;
            return;
        }
        --this.counter;
        if (this.counter > 0) {
            return;
        }
        this.counter = 20;
        TileEntity tileEntity = this.field_145850_b.func_175625_s(this.monitor);
        if (!EnergyTools.isEnergyTE((TileEntity)tileEntity)) {
            this.setInvalid();
            return;
        }
        EnergyTools.EnergyLevelMulti energy = EnergyTools.getEnergyLevelMulti((TileEntity)tileEntity);
        long maxEnergy = energy.getMaxEnergy();
        int ratio = 0;
        boolean alarm = false;
        if (maxEnergy > 0L) {
            long stored = energy.getEnergy();
            ratio = (int)(1L + stored * 5L / maxEnergy);
            if (ratio < 1) {
                ratio = 1;
            } else if (ratio > 5) {
                ratio = 5;
            }
            switch (this.alarmMode) {
                case MODE_OFF: {
                    alarm = false;
                    break;
                }
                case MODE_LESS: {
                    alarm = stored * 100L / maxEnergy < (long)this.alarmLevel;
                    break;
                }
                case MODE_MORE: {
                    boolean bl = alarm = stored * 100L / maxEnergy > (long)this.alarmLevel;
                }
            }
        }
        if (this.rflevel != ratio) {
            this.rflevel = ratio;
            this.markDirtyClient();
        }
        if (alarm != this.inAlarm) {
            this.inAlarm = alarm;
            this.setRedstoneOut(this.inAlarm);
            this.func_70296_d();
        }
    }

    private void setRedstoneOut(boolean a) {
        this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q());
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.monitor = tagCompound.func_74764_b("monitorX") ? new BlockPos(tagCompound.func_74762_e("monitorX"), tagCompound.func_74762_e("monitorY"), tagCompound.func_74762_e("monitorZ")) : null;
        this.inAlarm = tagCompound.func_74767_n("inAlarm");
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.rflevel = tagCompound.func_74762_e("rflevel");
        this.alarmMode = RFMonitorMode.getModeFromIndex(tagCompound.func_74771_c("alarmMode"));
        this.alarmLevel = tagCompound.func_74771_c("alarmLevel");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        if (this.monitor != null) {
            tagCompound.func_74768_a("monitorX", this.monitor.func_177958_n());
            tagCompound.func_74768_a("monitorY", this.monitor.func_177956_o());
            tagCompound.func_74768_a("monitorZ", this.monitor.func_177952_p());
        }
        tagCompound.func_74757_a("inAlarm", this.inAlarm);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.func_74768_a("rflevel", this.getRflevel());
        tagCompound.func_74774_a("alarmMode", (byte)this.alarmMode.getIndex());
        tagCompound.func_74774_a("alarmLevel", (byte)this.alarmLevel);
    }

    public List executeWithResultList(String command, Map<String, Argument> args) {
        List rc = super.executeWithResultList(command, args);
        if (rc != null) {
            return rc;
        }
        if (CMD_GETADJACENTBLOCKS.equals(command)) {
            return this.findAdjacentBlocks();
        }
        return null;
    }

    public boolean execute(String command, List list) {
        boolean rc = super.execute(command, list);
        if (rc) {
            return true;
        }
        if (CLIENTCMD_ADJACENTBLOCKSREADY.equals(command)) {
            GuiRFMonitor.fromServer_clientAdjacentBlocks = list.stream().map(o -> ((BlockPosNet)o).getPos()).collect(Collectors.toList());
            return true;
        }
        return false;
    }
}

