/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.powercell;

import cofh.api.energy.IEnergyConnection;
import cofh.api.energy.IEnergyContainerItem;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import java.util.Map;
import java.util.Set;
import mcjty.lib.api.smartwrench.SmartWrenchSelector;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.network.Argument;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.EnergyTools;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.varia.Logging;
import mcjty.rftools.blocks.powercell.PowerCellBlock;
import mcjty.rftools.blocks.powercell.PowerCellConfiguration;
import mcjty.rftools.blocks.powercell.PowerCellContainer;
import mcjty.rftools.blocks.powercell.PowerCellNetwork;
import mcjty.rftools.blocks.powercell.PowerCellSetup;
import mcjty.rftools.blocks.teleporter.TeleportationTools;
import mcjty.rftools.items.powercell.PowerCellCardItem;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class PowerCellTileEntity
extends GenericTileEntity
implements IEnergyProvider,
IEnergyReceiver,
DefaultSidedInventory,
ITickable,
SmartWrenchSelector {
    public static String CMD_SETNONE = "setNone";
    public static String CMD_SETINPUT = "setInput";
    public static String CMD_SETOUTPUT = "setOutput";
    public static String CMD_CLEARSTATS = "clearStats";
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, PowerCellContainer.factory, 3);
    private int networkId = -1;
    private int energy = 0;
    private int totalExtracted = 0;
    private int totalInserted = 0;
    private Mode[] modes = new Mode[]{Mode.MODE_NONE, Mode.MODE_NONE, Mode.MODE_NONE, Mode.MODE_NONE, Mode.MODE_NONE, Mode.MODE_NONE};

    protected boolean needsCustomInvWrapper() {
        return true;
    }

    public int getNetworkId() {
        return this.networkId;
    }

    public PowerCellNetwork.Network getNetwork() {
        int networkId = this.getNetworkId();
        if (networkId == -1) {
            return null;
        }
        PowerCellNetwork generatorNetwork = PowerCellNetwork.getChannels(this.field_145850_b);
        return generatorNetwork.getOrCreateNetwork(networkId);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        Mode[] old = new Mode[]{this.modes[0], this.modes[1], this.modes[2], this.modes[3], this.modes[4], this.modes[5]};
        super.onDataPacket(net, packet);
        for (int i = 0; i < 6; ++i) {
            if (old[i] == this.modes[i]) continue;
            this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
            return;
        }
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
        this.energy = tagCompound.func_74762_e("energy");
        this.totalInserted = tagCompound.func_74762_e("totIns");
        this.totalExtracted = tagCompound.func_74762_e("totExt");
        this.networkId = tagCompound.func_74762_e("networkId");
        this.modes[0] = Mode.values()[tagCompound.func_74771_c("m0")];
        this.modes[1] = Mode.values()[tagCompound.func_74771_c("m1")];
        this.modes[2] = Mode.values()[tagCompound.func_74771_c("m2")];
        this.modes[3] = Mode.values()[tagCompound.func_74771_c("m3")];
        this.modes[4] = Mode.values()[tagCompound.func_74771_c("m4")];
        this.modes[5] = Mode.values()[tagCompound.func_74771_c("m5")];
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
        tagCompound.func_74768_a("energy", this.energy);
        tagCompound.func_74768_a("totIns", this.totalInserted);
        tagCompound.func_74768_a("totExt", this.totalExtracted);
        tagCompound.func_74768_a("networkId", this.networkId);
        tagCompound.func_74774_a("m0", (byte)this.modes[0].ordinal());
        tagCompound.func_74774_a("m1", (byte)this.modes[1].ordinal());
        tagCompound.func_74774_a("m2", (byte)this.modes[2].ordinal());
        tagCompound.func_74774_a("m3", (byte)this.modes[3].ordinal());
        tagCompound.func_74774_a("m4", (byte)this.modes[4].ordinal());
        tagCompound.func_74774_a("m5", (byte)this.modes[5].ordinal());
    }

    public Mode getMode(EnumFacing side) {
        return this.modes[side.ordinal()];
    }

    public void toggleMode(EnumFacing side) {
        switch (this.modes[side.ordinal()]) {
            case MODE_NONE: {
                this.modes[side.ordinal()] = Mode.MODE_INPUT;
                break;
            }
            case MODE_INPUT: {
                this.modes[side.ordinal()] = Mode.MODE_OUTPUT;
                break;
            }
            case MODE_OUTPUT: {
                this.modes[side.ordinal()] = Mode.MODE_NONE;
            }
        }
        this.markDirtyClient();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            int energyStored;
            if (this.isCreative()) {
                int gain = 1000000;
                int networkId = this.getNetworkId();
                if (networkId == -1) {
                    this.receiveEnergyLocal(gain, false);
                } else {
                    this.receiveEnergyMulti(gain, false);
                }
            }
            if ((energyStored = this.getEnergyStored(EnumFacing.DOWN)) <= 0) {
                return;
            }
            this.handleChargingItem();
            this.sendOutEnergy();
        }
    }

    private void handleChargingItem() {
        ItemStack stack = this.inventoryHelper.getStackInSlot(2);
        if (stack != null && stack.func_77973_b() instanceof IEnergyContainerItem) {
            IEnergyContainerItem energyContainerItem = (IEnergyContainerItem)stack.func_77973_b();
            int energyStored = this.getEnergyStored(EnumFacing.DOWN);
            int rfToGive = PowerCellConfiguration.CHARGEITEMPERTICK <= energyStored ? PowerCellConfiguration.CHARGEITEMPERTICK : energyStored;
            int received = energyContainerItem.receiveEnergy(stack, rfToGive, false);
            this.extractEnergyInternal(received, false, PowerCellConfiguration.CHARGEITEMPERTICK);
        }
    }

    private void sendOutEnergy() {
        int energyStored = this.getEnergyStored(EnumFacing.DOWN);
        for (EnumFacing face : EnumFacing.values()) {
            IEnergyConnection connection;
            BlockPos pos;
            TileEntity te;
            if (this.modes[face.ordinal()] != Mode.MODE_OUTPUT || !EnergyTools.isEnergyTE((TileEntity)(te = this.field_145850_b.func_175625_s(pos = this.func_174877_v().func_177972_a(face)))) || te instanceof PowerCellTileEntity && this.getNetworkId() != -1 && ((PowerCellTileEntity)te).getNetworkId() == this.getNetworkId()) continue;
            EnumFacing opposite = face.func_176734_d();
            float factor = this.getCostFactor();
            int rfPerTick = this.getRfPerTickPerSide();
            int rfToGive = rfPerTick <= (int)((float)energyStored / factor) ? rfPerTick : (int)((float)energyStored / factor);
            int received = te instanceof IEnergyConnection ? ((connection = (IEnergyConnection)te).canConnectEnergy(opposite) ? EnergyTools.receiveEnergy((TileEntity)te, (EnumFacing)opposite, (int)rfToGive) : 0) : EnergyTools.receiveEnergy((TileEntity)te, (EnumFacing)opposite, (int)rfToGive);
            if ((energyStored -= this.extractEnergyInternal((int)((float)received * factor), false, PowerCellConfiguration.rfPerTick * this.getPowerFactor() / PowerCellConfiguration.simpleFactor)) <= 0) break;
        }
    }

    public float getCostFactor() {
        float factor;
        float infusedFactor = this.getInfusedFactor();
        if (this.getNetworkId() == -1) {
            factor = 1.0f;
        } else {
            factor = this.getNetwork().calculateCostFactor(this.field_145850_b, this.getGlobalPos());
            factor = (factor - 1.0f) * (1.0f - infusedFactor / 2.0f) + 1.0f;
        }
        return factor;
    }

    public int getRfPerTickPerSide() {
        return (int)((double)(PowerCellConfiguration.rfPerTick * this.getPowerFactor() / PowerCellConfiguration.simpleFactor) * ((double)this.getInfusedFactor() * 0.5 + 1.0));
    }

    private void handleCardRemoval() {
        PowerCellNetwork.Network network;
        if (!this.field_145850_b.field_72995_K && (network = this.getNetwork()) != null) {
            this.energy = network.extractEnergySingleBlock(this.isAdvanced(), this.isSimple());
            network.remove(this.field_145850_b, this.getGlobalPos(), this.isAdvanced(), this.isSimple());
            PowerCellNetwork.getChannels(this.field_145850_b).save(this.field_145850_b);
        }
        this.networkId = -1;
        this.func_70296_d();
    }

    private void handleCardInsertion() {
        ItemStack stack = this.inventoryHelper.getStackInSlot(0);
        int id = PowerCellCardItem.getId(stack);
        if (!this.field_145850_b.field_72995_K) {
            PowerCellNetwork channels = PowerCellNetwork.getChannels(this.field_145850_b);
            if (id == -1) {
                id = channels.newChannel();
                PowerCellCardItem.setId(stack, id);
            }
            this.networkId = id;
            PowerCellNetwork.Network network = this.getNetwork();
            network.add(this.field_145850_b, this.getGlobalPos(), this.isAdvanced(), this.isSimple());
            network.setEnergy(network.getEnergy() + this.energy);
            channels.save(this.field_145850_b);
        } else {
            this.networkId = id;
        }
        this.func_70296_d();
    }

    private boolean isAdvanced() {
        return PowerCellBlock.isAdvanced(this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c());
    }

    private boolean isSimple() {
        return PowerCellBlock.isSimple(this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c());
    }

    private boolean isCreative() {
        return PowerCellBlock.isCreative(this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c());
    }

    private int getPowerFactor() {
        if (this.isSimple()) {
            return 1;
        }
        return this.isAdvanced() ? PowerCellConfiguration.advancedFactor * PowerCellConfiguration.simpleFactor : PowerCellConfiguration.simpleFactor;
    }

    public int getEnergy() {
        return this.energy;
    }

    public GlobalCoordinate getGlobalPos() {
        return new GlobalCoordinate(this.func_174877_v(), this.field_145850_b.field_73011_w.getDimension());
    }

    public ItemStack func_70304_b(int index) {
        if (index == 0) {
            this.handleCardRemoval();
        }
        return this.inventoryHelper.removeStackFromSlot(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        if (index == 0 && this.inventoryHelper.containsItem(index) && count >= this.inventoryHelper.getStackInSlot((int)index).field_77994_a) {
            this.handleCardRemoval();
        }
        return this.inventoryHelper.decrStackSize(index, count);
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (index == 0) {
            this.handleCardRemoval();
        }
        this.inventoryHelper.setInventorySlotContents(this.func_70297_j_(), index, stack);
        if (index == 0 && this.inventoryHelper.containsItem(index)) {
            this.handleCardInsertion();
        } else if (index == 1 && this.inventoryHelper.containsItem(index)) {
            PowerCellCardItem.setId(this.inventoryHelper.getStackInSlot(index), this.networkId);
        }
    }

    public int getTotalExtracted() {
        return this.totalExtracted;
    }

    public int getTotalInserted() {
        return this.totalInserted;
    }

    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        if (this.modes[from.ordinal()] != Mode.MODE_INPUT) {
            return 0;
        }
        int networkId = this.getNetworkId();
        int received = networkId == -1 ? this.receiveEnergyLocal(maxReceive, simulate) : this.receiveEnergyMulti(maxReceive, simulate);
        if (!simulate) {
            this.totalInserted += received;
            this.func_70296_d();
        }
        return received;
    }

    private int receiveEnergyMulti(int maxReceive, boolean simulate) {
        PowerCellNetwork.Network network = this.getNetwork();
        int totEnergy = PowerCellConfiguration.rfPerNormalCell * (network.getBlockCount() - network.getAdvancedBlockCount() - network.getSimpleBlockCount()) + PowerCellConfiguration.rfPerNormalCell * PowerCellConfiguration.advancedFactor * network.getAdvancedBlockCount() + PowerCellConfiguration.rfPerNormalCell * network.getSimpleBlockCount() / PowerCellConfiguration.simpleFactor;
        int maxInsert = Math.min(totEnergy - network.getEnergy(), maxReceive);
        if (maxInsert > 0 && !simulate) {
            network.setEnergy(network.getEnergy() + maxInsert);
            PowerCellNetwork.getChannels(this.field_145850_b).save(this.field_145850_b);
        }
        return maxInsert;
    }

    private int receiveEnergyLocal(int maxReceive, boolean simulate) {
        int maxInsert = Math.min(PowerCellConfiguration.rfPerNormalCell * this.getPowerFactor() / PowerCellConfiguration.simpleFactor - this.energy, maxReceive);
        if (maxInsert > 0 && !simulate) {
            this.energy += maxInsert;
            this.func_70296_d();
        }
        return maxInsert;
    }

    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        return 0;
    }

    private int extractEnergyInternal(int maxExtract, boolean simulate, int maximum) {
        int networkId = this.getNetworkId();
        int extracted = networkId == -1 ? this.extractEnergyLocal(maxExtract, simulate, maximum) : this.extractEnergyMulti(maxExtract, simulate, maximum);
        if (!simulate) {
            this.totalExtracted += extracted;
            this.func_70296_d();
        }
        return extracted;
    }

    private int extractEnergyMulti(int maxExtract, boolean simulate, int maximum) {
        PowerCellNetwork.Network network = this.getNetwork();
        int energy = network.getEnergy();
        if (maxExtract > energy) {
            maxExtract = energy;
        }
        if (maxExtract > maximum) {
            maxExtract = maximum;
        }
        if (!simulate) {
            network.setEnergy(energy - maxExtract);
            PowerCellNetwork.getChannels(this.field_145850_b).save(this.field_145850_b);
        }
        return maxExtract;
    }

    private int extractEnergyLocal(int maxExtract, boolean simulate, int maximum) {
        if (maxExtract > this.energy) {
            maxExtract = this.energy;
        }
        if (maxExtract > maximum) {
            maxExtract = maximum;
        }
        if (!simulate) {
            this.energy -= maxExtract;
            this.func_70296_d();
        }
        return maxExtract;
    }

    public int getEnergyStored(EnumFacing from) {
        int networkId = this.getNetworkId();
        if (networkId == -1) {
            return this.energy;
        }
        PowerCellNetwork.Network network = this.getNetwork();
        return network.getEnergy();
    }

    public int getMaxEnergyStored(EnumFacing from) {
        int networkId = this.getNetworkId();
        if (networkId == -1) {
            return PowerCellConfiguration.rfPerNormalCell * this.getPowerFactor() / PowerCellConfiguration.simpleFactor;
        }
        PowerCellNetwork.Network network = this.getNetwork();
        return (network.getBlockCount() - network.getAdvancedBlockCount() - network.getSimpleBlockCount()) * PowerCellConfiguration.rfPerNormalCell + network.getAdvancedBlockCount() * PowerCellConfiguration.rfPerNormalCell * PowerCellConfiguration.advancedFactor + network.getSimpleBlockCount() * PowerCellConfiguration.rfPerNormalCell / PowerCellConfiguration.simpleFactor;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 0 && stack.func_77973_b() != PowerCellSetup.powerCellCardItem) {
            return false;
        }
        return index != 1 || stack.func_77973_b() == PowerCellSetup.powerCellCardItem;
    }

    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_SETNONE.equals(command)) {
            for (EnumFacing facing : EnumFacing.values()) {
                this.modes[facing.ordinal()] = Mode.MODE_NONE;
            }
            this.markDirtyClient();
            return true;
        }
        if (CMD_SETINPUT.equals(command)) {
            for (EnumFacing facing : EnumFacing.values()) {
                this.modes[facing.ordinal()] = Mode.MODE_INPUT;
            }
            this.markDirtyClient();
            return true;
        }
        if (CMD_SETOUTPUT.equals(command)) {
            for (EnumFacing facing : EnumFacing.values()) {
                this.modes[facing.ordinal()] = Mode.MODE_OUTPUT;
            }
            this.markDirtyClient();
            return true;
        }
        if (CMD_CLEARSTATS.equals(command)) {
            this.totalExtracted = 0;
            this.totalInserted = 0;
            this.func_70296_d();
            return true;
        }
        return false;
    }

    public void selectBlock(EntityPlayer player, BlockPos pos) {
        PowerCellTileEntity.dumpNetwork(player, this);
    }

    public static void dumpNetwork(EntityPlayer player, PowerCellTileEntity powerCellTileEntity) {
        PowerCellNetwork.Network network = powerCellTileEntity.getNetwork();
        Set<GlobalCoordinate> blocks = network.getBlocks();
        System.out.println("blocks.size() = " + blocks.size());
        blocks.forEach(b -> {
            String msg;
            World w = TeleportationTools.getWorldForDimension(player.field_70170_p, b.getDimension());
            if (w == null) {
                msg = "dimension missing!";
            } else {
                Block block = w.func_180495_p(b.getCoordinate()).func_177230_c();
                msg = block == PowerCellSetup.powerCellBlock ? "normal" : (block == PowerCellSetup.advancedPowerCellBlock ? "advanced" : (block == PowerCellSetup.creativePowerCellBlock ? "creative" : "not a powercell!"));
                TileEntity te = w.func_175625_s(b.getCoordinate());
                if (te instanceof PowerCellTileEntity) {
                    PowerCellTileEntity power = (PowerCellTileEntity)te;
                    msg = msg + " (+:" + power.getTotalInserted() + ", -:" + power.getTotalExtracted() + ")";
                }
            }
            Logging.message((EntityPlayer)player, (String)("Block: " + BlockPosTools.toString((BlockPos)b.getCoordinate()) + " (" + b.getDimension() + "): " + msg));
        });
    }

    public static enum Mode implements IStringSerializable
    {
        MODE_NONE("none"),
        MODE_INPUT("input"),
        MODE_OUTPUT("output");

        private final String name;

        private Mode(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

