/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens.modules;

import mcjty.lib.varia.BlockPosTools;
import mcjty.rftools.api.screens.IScreenDataHelper;
import mcjty.rftools.api.screens.IScreenModule;
import mcjty.rftools.api.screens.data.IModuleDataContents;
import mcjty.rftools.blocks.elevator.ElevatorTileEntity;
import mcjty.rftools.blocks.screens.ScreenConfiguration;
import mcjty.rftools.blocks.screens.modules.ScreenModuleHelper;
import mcjty.rftools.varia.RFToolsTools;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class ElevatorButtonScreenModule
implements IScreenModule<IModuleDataContents> {
    protected int dim = 0;
    protected BlockPos coordinate = BlockPosTools.INVALID;
    protected ScreenModuleHelper helper = new ScreenModuleHelper();
    private boolean vertical = false;
    private boolean large = false;

    @Override
    public IModuleDataContents getData(IScreenDataHelper helper, World worldObj, long millis) {
        WorldServer world = DimensionManager.getWorld((int)this.dim);
        if (world == null) {
            return null;
        }
        if (!RFToolsTools.chunkLoaded((World)world, this.coordinate)) {
            return null;
        }
        TileEntity te = world.func_175625_s(this.coordinate);
        if (!(te instanceof ElevatorTileEntity)) {
            return null;
        }
        ElevatorTileEntity elevatorTileEntity = (ElevatorTileEntity)te;
        return helper.createContents(elevatorTileEntity.getCurrentLevel(), elevatorTileEntity.getLevelCount(), 0L);
    }

    @Override
    public void setupFromNBT(NBTTagCompound tagCompound, int dim, BlockPos pos) {
        if (tagCompound != null) {
            this.coordinate = BlockPosTools.INVALID;
            if (tagCompound.func_74764_b("elevatorx")) {
                this.dim = tagCompound.func_74764_b("elevatordim") ? tagCompound.func_74762_e("elevatordim") : tagCompound.func_74762_e("dim");
                if (dim == this.dim) {
                    BlockPos c = new BlockPos(tagCompound.func_74762_e("elevatorx"), tagCompound.func_74762_e("elevatory"), tagCompound.func_74762_e("elevatorz"));
                    int dx = Math.abs(c.func_177958_n() - pos.func_177958_n());
                    int dz = Math.abs(c.func_177952_p() - pos.func_177952_p());
                    if (dx <= 64 && dz <= 64) {
                        this.coordinate = c;
                    }
                }
                this.vertical = tagCompound.func_74767_n("vertical");
                this.large = tagCompound.func_74767_n("large");
            }
        }
    }

    @Override
    public void mouseClick(World world, int x, int y, boolean clicked, EntityPlayer player) {
        if (BlockPosTools.INVALID.equals((Object)this.coordinate)) {
            if (player != null) {
                player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "Module is not linked to elevator!"));
            }
            return;
        }
        WorldServer w = DimensionManager.getWorld((int)this.dim);
        if (w == null) {
            return;
        }
        if (!RFToolsTools.chunkLoaded(world, this.coordinate)) {
            return;
        }
        TileEntity te = w.func_175625_s(this.coordinate);
        if (!(te instanceof ElevatorTileEntity)) {
            return;
        }
        ElevatorTileEntity elevatorTileEntity = (ElevatorTileEntity)te;
        int levelCount = elevatorTileEntity.getLevelCount();
        int level = -1;
        if (this.vertical) {
            int max = this.large ? 6 : 8;
            boolean twocols = levelCount > max;
            int yoffset = 0;
            if (y >= yoffset) {
                level = (y - yoffset) / (this.large ? 20 : 14);
                if (level < 0) {
                    return;
                }
                level = twocols ? (x > 73 ? (level < levelCount - max ? levelCount - level - 1 : -1) : max - level - 1) : levelCount - level - 1;
                System.out.println("level = " + level);
            }
        } else {
            int xoffset = 5;
            if (x >= xoffset) {
                level = (x - xoffset) / (this.large ? 20 : 14);
            }
        }
        if (level >= 0 && level < levelCount) {
            elevatorTileEntity.toLevel(level);
        }
    }

    @Override
    public int getRfPerTick() {
        return ScreenConfiguration.ELEVATOR_BUTTON_RFPERTICK;
    }
}

