/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storagemonitor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.entity.GenericEnergyReceiverTileEntity;
import mcjty.lib.network.Argument;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.SoundTools;
import mcjty.rftools.api.general.IInventoryTracker;
import mcjty.rftools.api.storage.IStorageScanner;
import mcjty.rftools.blocks.crafter.CraftingRecipe;
import mcjty.rftools.blocks.storagemonitor.CachedItemCount;
import mcjty.rftools.blocks.storagemonitor.CachedItemKey;
import mcjty.rftools.blocks.storagemonitor.StorageScannerConfiguration;
import mcjty.rftools.blocks.storagemonitor.StorageScannerContainer;
import mcjty.rftools.craftinggrid.CraftingGrid;
import mcjty.rftools.craftinggrid.CraftingGridProvider;
import mcjty.rftools.craftinggrid.StorageCraftingTools;
import mcjty.rftools.craftinggrid.TileEntityItemSource;
import mcjty.rftools.jei.JEIRecipeAcceptor;
import mcjty.rftools.varia.RFToolsTools;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.oredict.OreDictionary;

public class StorageScannerTileEntity
extends GenericEnergyReceiverTileEntity
implements DefaultSidedInventory,
ITickable,
CraftingGridProvider,
JEIRecipeAcceptor,
IStorageScanner {
    public static final String CMD_SETRADIUS = "setRadius";
    public static final String CMD_UP = "up";
    public static final String CMD_TOP = "top";
    public static final String CMD_DOWN = "down";
    public static final String CMD_BOTTOM = "bottom";
    public static final String CMD_TOGGLEROUTABLE = "toggleRoutable";
    public static final String CMD_TOGGLEEXPORT = "toggleExport";
    private static final int[] SLOTS = new int[]{0, 1, 2};
    private List<BlockPos> inventories = new ArrayList<BlockPos>();
    private Map<CachedItemKey, CachedItemCount> cachedCounts = new HashMap<CachedItemKey, CachedItemCount>();
    private Set<BlockPos> routable = new HashSet<BlockPos>();
    private int radius = 1;
    private EntityPlayer entityPlayer;
    private Integer monitorDim;
    private boolean exportToCurrent = false;
    private BlockPos lastSelectedInventory = null;
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, StorageScannerContainer.factory, 3);
    private CraftingGrid craftingGrid = new CraftingGrid();

    public StorageScannerTileEntity() {
        super(StorageScannerConfiguration.MAXENERGY, StorageScannerConfiguration.RECEIVEPERTICK);
        this.monitorDim = null;
    }

    public StorageScannerTileEntity(EntityPlayer entityPlayer, int monitordim) {
        super(StorageScannerConfiguration.MAXENERGY, StorageScannerConfiguration.RECEIVEPERTICK);
        this.entityPlayer = entityPlayer;
        this.monitorDim = monitordim;
    }

    protected boolean needsCustomInvWrapper() {
        return true;
    }

    @Override
    public void storeRecipe(int index) {
        this.getCraftingGrid().storeRecipe(index);
    }

    @Override
    public void setRecipe(int index, ItemStack[] stacks) {
        this.craftingGrid.setRecipe(index, stacks);
        this.func_70296_d();
    }

    @Override
    public CraftingGrid getCraftingGrid() {
        return this.craftingGrid;
    }

    @Override
    public void markInventoryDirty() {
        this.func_70296_d();
    }

    @Override
    public int[] craft(EntityPlayerMP player, int n, boolean test) {
        CraftingRecipe activeRecipe = this.craftingGrid.getActiveRecipe();
        return this.craft(player, n, test, activeRecipe);
    }

    public int[] craft(EntityPlayerMP player, int n, boolean test, CraftingRecipe activeRecipe) {
        TileEntityItemSource itemSource = new TileEntityItemSource().addInventory((IInventory)player.field_71071_by, 0);
        for (BlockPos p : this.getInventories()) {
            TileEntity tileEntity;
            if (!this.isRoutable(p) || (tileEntity = this.field_145850_b.func_175625_s(p)) instanceof StorageScannerTileEntity) continue;
            itemSource.add(tileEntity, 0);
        }
        if (test) {
            return StorageCraftingTools.testCraftItems(player, n, activeRecipe, itemSource);
        }
        StorageCraftingTools.craftItems(player, n, activeRecipe, itemSource);
        return null;
    }

    @Override
    public void setGridContents(List<ItemStack> stacks) {
        for (int i = 0; i < stacks.size(); ++i) {
            this.craftingGrid.getCraftingGridInventory().func_70299_a(i, stacks.get(i));
        }
        this.func_70296_d();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            ItemStack stack;
            if (this.inventoryHelper.containsItem(0)) {
                if (this.getEnergyStored(EnumFacing.DOWN) < StorageScannerConfiguration.rfPerInsert) {
                    return;
                }
                stack = this.inventoryHelper.getStackInSlot(0);
                stack = this.injectStackInternal(stack, this.exportToCurrent);
                this.inventoryHelper.setInventorySlotContents(64, 0, stack);
                this.consumeEnergy(StorageScannerConfiguration.rfPerInsert);
            }
            if (this.inventoryHelper.containsItem(2)) {
                if (this.getEnergyStored(EnumFacing.DOWN) < StorageScannerConfiguration.rfPerInsert) {
                    return;
                }
                stack = this.inventoryHelper.getStackInSlot(2);
                stack = this.injectStackInternal(stack, false);
                this.inventoryHelper.setInventorySlotContents(64, 2, stack);
                this.consumeEnergy(StorageScannerConfiguration.rfPerInsert);
            }
        }
    }

    public ItemStack injectStack(ItemStack stack, EntityPlayer player) {
        if (this.getEnergyStored(EnumFacing.DOWN) < StorageScannerConfiguration.rfPerInsert) {
            player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "Not enough power to insert items!"));
            return stack;
        }
        if (!this.checkForRoutableInventories()) {
            player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "There are no routable inventories!"));
            return stack;
        }
        if ((stack = this.injectStackInternal(stack, false)) == null) {
            this.consumeEnergy(StorageScannerConfiguration.rfPerInsert);
            SoundTools.playSound((World)this.field_145850_b, (SoundEvent)SoundEvents.field_187638_cR, (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)1.0, (double)3.0);
        }
        return stack;
    }

    private boolean checkForRoutableInventories() {
        for (BlockPos blockPos : this.inventories) {
            TileEntity te;
            if (blockPos.equals((Object)this.func_174877_v()) || !this.routable.contains(blockPos) || (te = this.field_145850_b.func_175625_s(blockPos)) == null) continue;
            return true;
        }
        return false;
    }

    private ItemStack injectStackInternal(ItemStack stack, boolean toSelected) {
        if (toSelected && this.lastSelectedInventory != null && this.lastSelectedInventory.func_177956_o() != -1) {
            TileEntity te = this.field_145850_b.func_175625_s(this.lastSelectedInventory);
            if (te != null && !(te instanceof StorageScannerTileEntity) && (stack = InventoryHelper.insertItem((World)this.field_145850_b, (BlockPos)this.lastSelectedInventory, null, (ItemStack)stack)) == null) {
                return stack;
            }
            return stack;
        }
        for (BlockPos blockPos : this.inventories) {
            TileEntity te;
            if (blockPos.equals((Object)this.func_174877_v()) || !this.routable.contains(blockPos) || (te = this.field_145850_b.func_175625_s(blockPos)) == null || te instanceof StorageScannerTileEntity || (stack = InventoryHelper.insertItem((World)this.field_145850_b, (BlockPos)blockPos, null, (ItemStack)stack)) != null) continue;
            return stack;
        }
        return stack;
    }

    public void giveToPlayer(ItemStack stack, boolean single, EntityPlayer player, boolean oredict) {
        if (stack == null) {
            return;
        }
        if (this.getEnergyStored(EnumFacing.DOWN) < StorageScannerConfiguration.rfPerRequest) {
            player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "Not enough power to request items!"));
            return;
        }
        Set<Integer> oredictMatches = StorageScannerTileEntity.getOredictMatchers(stack, oredict);
        List<BlockPos> inventories = this.getInventories();
        int[] cnt = new int[]{single ? 1 : stack.func_77976_d()};
        boolean given = false;
        for (BlockPos c : inventories) {
            ItemStack received;
            ItemStack itemStack;
            int i;
            TileEntity tileEntity = this.field_145850_b.func_175625_s(c);
            if (tileEntity instanceof StorageScannerTileEntity) continue;
            if (RFToolsTools.hasItemCapabilitySafe(tileEntity)) {
                IItemHandler capability = RFToolsTools.getItemCapabilitySafe(tileEntity);
                for (i = 0; i < capability.getSlots(); ++i) {
                    itemStack = capability.getStackInSlot(i);
                    if (!StorageScannerTileEntity.isItemEqual(stack, itemStack, oredictMatches) || !this.giveItemToPlayer(player, cnt, received = capability.extractItem(i, cnt[0], false))) continue;
                    given = true;
                }
                continue;
            }
            if (!(tileEntity instanceof IInventory)) continue;
            IInventory inventory = (IInventory)tileEntity;
            for (i = 0; i < inventory.func_70302_i_(); ++i) {
                itemStack = inventory.func_70301_a(i);
                if (!StorageScannerTileEntity.isItemEqual(stack, itemStack, oredictMatches) || !this.giveItemToPlayer(player, cnt, received = inventory.func_70298_a(i, cnt[0]))) continue;
                given = true;
            }
        }
        if (given) {
            this.consumeEnergy(StorageScannerConfiguration.rfPerRequest);
            SoundTools.playSound((World)this.field_145850_b, (SoundEvent)SoundEvents.field_187638_cR, (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)1.0, (double)1.0);
        }
    }

    private boolean giveItemToPlayer(EntityPlayer player, int[] cnt, ItemStack received) {
        if (received != null && cnt[0] > 0) {
            cnt[0] = cnt[0] - received.field_77994_a;
            this.giveToPlayer(received, player);
            return true;
        }
        return false;
    }

    private boolean giveToPlayer(ItemStack stack, EntityPlayer player) {
        if (stack == null) {
            return false;
        }
        if (!player.field_71071_by.func_70441_a(stack)) {
            player.func_70099_a(stack, 1.05f);
        }
        return true;
    }

    @Override
    public int countItems(ItemStack stack, boolean starred, boolean oredict) {
        if (stack == null) {
            return 0;
        }
        int cnt = 0;
        Set<Integer> oredictMatches = StorageScannerTileEntity.getOredictMatchers(stack, oredict);
        List<BlockPos> inventories = this.getInventories();
        for (BlockPos c : inventories) {
            TileEntity tileEntity;
            if (starred && !this.routable.contains(c) || (tileEntity = this.field_145850_b.func_175625_s(c)) instanceof StorageScannerTileEntity) continue;
            Integer cachedCount = null;
            if (tileEntity instanceof IInventoryTracker) {
                Integer oldVersion;
                IInventoryTracker tracker = (IInventoryTracker)tileEntity;
                CachedItemCount itemCount = this.cachedCounts.get(new CachedItemKey(c, stack.func_77973_b(), stack.func_77952_i()));
                if (itemCount != null && (oldVersion = Integer.valueOf(itemCount.getVersion())).intValue() == tracker.getVersion()) {
                    cachedCount = itemCount.getCount();
                }
            }
            if (cachedCount != null) {
                cnt += cachedCount.intValue();
                continue;
            }
            int[] cc = new int[]{0};
            InventoryHelper.getItems((TileEntity)tileEntity, s -> StorageScannerTileEntity.isItemEqual(stack, s, oredictMatches)).forEach(s -> {
                cc[0] = cc[0] + s.field_77994_a;
            });
            cnt += cc[0];
            if (!(tileEntity instanceof IInventoryTracker)) continue;
            IInventoryTracker tracker = (IInventoryTracker)tileEntity;
            this.cachedCounts.put(new CachedItemKey(c, stack.func_77973_b(), stack.func_77952_i()), new CachedItemCount(tracker.getVersion(), cc[0]));
        }
        return cnt;
    }

    private static Set<Integer> getOredictMatchers(ItemStack stack, boolean oredict) {
        HashSet<Integer> oredictMatches = new HashSet<Integer>();
        if (oredict) {
            for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
                oredictMatches.add(id);
            }
        }
        return oredictMatches;
    }

    public static boolean isItemEqual(ItemStack thisItem, ItemStack other, boolean oredict) {
        return StorageScannerTileEntity.isItemEqual(thisItem, other, StorageScannerTileEntity.getOredictMatchers(thisItem, oredict));
    }

    public static boolean isItemEqual(ItemStack thisItem, ItemStack other, Set<Integer> oreDictMatchers) {
        int[] oreIDs;
        if (other == null) {
            return false;
        }
        if (oreDictMatchers.isEmpty()) {
            return thisItem.func_77969_a(other);
        }
        for (int id : oreIDs = OreDictionary.getOreIDs((ItemStack)other)) {
            if (!oreDictMatchers.contains(id)) continue;
            return true;
        }
        return false;
    }

    public Set<BlockPos> performSearch(String search) {
        List<BlockPos> inventories = this.getInventories();
        search = search.toLowerCase();
        HashSet<BlockPos> output = new HashSet<BlockPos>();
        for (BlockPos c : inventories) {
            TileEntity tileEntity = this.field_145850_b.func_175625_s(c);
            if (tileEntity instanceof StorageScannerTileEntity) continue;
            String finalSearch = search;
            InventoryHelper.getItems((TileEntity)tileEntity, s -> s.func_82833_r().toLowerCase().contains(finalSearch)).forEach(s -> output.add(c));
        }
        return output;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int v) {
        this.radius = v;
        this.markDirtyClient();
    }

    public boolean isExportToCurrent() {
        return this.exportToCurrent;
    }

    public void setExportToCurrent(boolean exportToCurrent) {
        this.exportToCurrent = exportToCurrent;
        this.func_70296_d();
    }

    private void toggleExportRoutable() {
        this.exportToCurrent = !this.exportToCurrent;
        this.markDirtyClient();
    }

    public boolean isRoutable(BlockPos p) {
        return this.routable.contains(p);
    }

    public void toggleRoutable(BlockPos p) {
        if (this.routable.contains(p)) {
            this.routable.remove(p);
        } else {
            this.routable.add(p);
        }
        this.markDirtyClient();
    }

    public List<BlockPos> getInventories() {
        return this.inventories;
    }

    private void moveUp(int index) {
        if (index <= 0) {
            return;
        }
        if (index >= this.inventories.size()) {
            return;
        }
        BlockPos p1 = this.inventories.get(index - 1);
        BlockPos p2 = this.inventories.get(index);
        this.inventories.set(index - 1, p2);
        this.inventories.set(index, p1);
        this.func_70296_d();
    }

    private void moveTop(int index) {
        if (index <= 0) {
            return;
        }
        if (index >= this.inventories.size()) {
            return;
        }
        BlockPos p = this.inventories.get(index);
        this.inventories.remove(index);
        this.inventories.add(0, p);
        this.func_70296_d();
    }

    private void moveDown(int index) {
        if (index < 0) {
            return;
        }
        if (index >= this.inventories.size() - 1) {
            return;
        }
        BlockPos p1 = this.inventories.get(index);
        BlockPos p2 = this.inventories.get(index + 1);
        this.inventories.set(index, p2);
        this.inventories.set(index + 1, p1);
        this.func_70296_d();
    }

    private void moveBottom(int index) {
        if (index < 0) {
            return;
        }
        if (index >= this.inventories.size() - 1) {
            return;
        }
        BlockPos p = this.inventories.get(index);
        this.inventories.remove(index);
        this.inventories.add(p);
        this.func_70296_d();
    }

    public void clearCachedCounts() {
        this.cachedCounts.clear();
    }

    public List<BlockPos> findInventories() {
        this.cachedCounts.clear();
        List<BlockPos> old = this.inventories;
        HashSet<BlockPos> oldAdded = new HashSet<BlockPos>();
        this.inventories = new ArrayList<BlockPos>();
        for (BlockPos p : old) {
            TileEntity te;
            if (p.func_177958_n() < this.func_174877_v().func_177958_n() - this.radius || p.func_177958_n() > this.func_174877_v().func_177958_n() + this.radius || p.func_177956_o() < this.func_174877_v().func_177956_o() - this.radius || p.func_177956_o() > this.func_174877_v().func_177956_o() + this.radius || p.func_177952_p() < this.func_174877_v().func_177952_p() - this.radius || p.func_177952_p() > this.func_174877_v().func_177952_p() + this.radius || !InventoryHelper.isInventory((TileEntity)(te = this.field_145850_b.func_175625_s(p))) || te instanceof StorageScannerTileEntity) continue;
            this.inventories.add(p);
            oldAdded.add(p);
        }
        for (int x = this.func_174877_v().func_177958_n() - this.radius; x <= this.func_174877_v().func_177958_n() + this.radius; ++x) {
            for (int z = this.func_174877_v().func_177952_p() - this.radius; z <= this.func_174877_v().func_177952_p() + this.radius; ++z) {
                for (int y = this.func_174877_v().func_177956_o() - this.radius; y <= this.func_174877_v().func_177956_o() + this.radius; ++y) {
                    TileEntity te;
                    BlockPos p = new BlockPos(x, y, z);
                    if (oldAdded.contains(p) || !InventoryHelper.isInventory((TileEntity)(te = this.field_145850_b.func_175625_s(p))) || te instanceof StorageScannerTileEntity) continue;
                    this.inventories.add(p);
                }
            }
        }
        return this.inventories;
    }

    @Override
    public ItemStack requestItem(ItemStack match, int amount, boolean doRoutable, boolean oredict) {
        if (match == null) {
            return null;
        }
        if (this.getEnergyStored(EnumFacing.DOWN) < StorageScannerConfiguration.rfPerRequest) {
            return null;
        }
        Set<Integer> oredictMatches = StorageScannerTileEntity.getOredictMatchers(match, oredict);
        List<BlockPos> inventories = this.getInventories();
        ItemStack result = null;
        int[] cnt = new int[]{match.func_77976_d() < amount ? match.func_77976_d() : amount};
        for (BlockPos c : inventories) {
            ItemStack received;
            ItemStack itemStack;
            int i;
            TileEntity tileEntity;
            if (cnt[0] <= 0) break;
            if (doRoutable && !this.routable.contains(c) || (tileEntity = this.field_145850_b.func_175625_s(c)) instanceof StorageScannerTileEntity) continue;
            if (RFToolsTools.hasItemCapabilitySafe(tileEntity)) {
                IItemHandler capability = RFToolsTools.getItemCapabilitySafe(tileEntity);
                for (i = 0; i < capability.getSlots(); ++i) {
                    itemStack = capability.getStackInSlot(i);
                    if (!StorageScannerTileEntity.isItemEqual(match, itemStack, oredictMatches) || (received = capability.extractItem(i, cnt[0], false)) == null) continue;
                    if (result == null) {
                        result = received;
                    } else {
                        result.field_77994_a += received.field_77994_a;
                    }
                    cnt[0] = cnt[0] - received.field_77994_a;
                }
                continue;
            }
            if (!(tileEntity instanceof IInventory)) continue;
            IInventory inventory = (IInventory)tileEntity;
            for (i = 0; i < inventory.func_70302_i_(); ++i) {
                itemStack = inventory.func_70301_a(i);
                if (!StorageScannerTileEntity.isItemEqual(match, itemStack, oredictMatches) || (received = inventory.func_70298_a(i, cnt[0])) == null) continue;
                if (result == null) {
                    result = received;
                } else {
                    result.field_77994_a += received.field_77994_a;
                }
                cnt[0] = cnt[0] - received.field_77994_a;
            }
        }
        if (result != null) {
            this.consumeEnergy(StorageScannerConfiguration.rfPerRequest);
        }
        return result;
    }

    @Override
    public int insertItem(ItemStack stack) {
        if (this.getEnergyStored(EnumFacing.DOWN) < StorageScannerConfiguration.rfPerInsert) {
            return stack.field_77994_a;
        }
        ItemStack toInsert = stack.func_77946_l();
        for (BlockPos blockPos : this.inventories) {
            TileEntity te;
            if (blockPos.equals((Object)this.func_174877_v()) || !this.routable.contains(blockPos) || (te = this.field_145850_b.func_175625_s(blockPos)) == null || te instanceof StorageScannerTileEntity || (toInsert = InventoryHelper.insertItem((World)this.field_145850_b, (BlockPos)blockPos, null, (ItemStack)toInsert)) != null) continue;
            return 0;
        }
        this.consumeEnergy(StorageScannerConfiguration.rfPerInsert);
        return toInsert.field_77994_a;
    }

    private ItemStack requestStackFromInv(BlockPos invPos, ItemStack requested, Integer[] todo, ItemStack outSlot) {
        TileEntity tileEntity = this.field_145850_b.func_175625_s(invPos);
        if (tileEntity instanceof StorageScannerTileEntity) {
            return outSlot;
        }
        int size = InventoryHelper.getInventorySize((TileEntity)tileEntity);
        for (int i = 0; i < size; ++i) {
            ItemStack stack = InventoryHelper.getSlot((TileEntity)tileEntity, (int)i);
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)requested, (ItemStack)stack)) continue;
            ItemStack extracted = InventoryHelper.extractItem((TileEntity)tileEntity, (int)i, (int)todo[0]);
            Integer[] integerArray = todo;
            Integer.valueOf(integerArray[0] - extracted.field_77994_a);
            if (outSlot == null) {
                outSlot = extracted;
            } else {
                outSlot.field_77994_a += extracted.field_77994_a;
            }
            if (todo[0] == 0) break;
        }
        return outSlot;
    }

    public void requestStack(BlockPos invPos, ItemStack requested, int amount, EntityPlayer player) {
        int rf = StorageScannerConfiguration.rfPerRequest;
        if (amount >= 0) {
            rf /= 10;
        }
        if (amount == -1) {
            amount = requested.func_77976_d();
        }
        if (this.getEnergyStored(EnumFacing.DOWN) < rf) {
            return;
        }
        Integer[] todo = new Integer[]{amount};
        ItemStack outSlot = this.inventoryHelper.getStackInSlot(1);
        if (outSlot != null) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)outSlot, (ItemStack)requested)) {
                return;
            }
            if (outSlot.field_77994_a >= requested.func_77976_d()) {
                return;
            }
            todo[0] = Math.min(todo[0], requested.func_77976_d() - outSlot.field_77994_a);
        }
        if (invPos.func_177956_o() == -1) {
            for (BlockPos blockPos : this.inventories) {
                if (!this.routable.contains(blockPos)) continue;
                outSlot = this.requestStackFromInv(blockPos, requested, todo, outSlot);
                if (todo[0] != 0) continue;
                break;
            }
        } else {
            outSlot = this.requestStackFromInv(invPos, requested, todo, outSlot);
        }
        if (todo[0] == amount) {
            return;
        }
        this.consumeEnergy(rf);
        this.func_70299_a(1, outSlot);
        if (StorageScannerConfiguration.requestStraightToInventory && player.field_71071_by.func_70441_a(outSlot)) {
            this.func_70299_a(1, null);
        }
    }

    private void addItemStack(List<ItemStack> stacks, Set<Item> foundItems, ItemStack stack) {
        if (stack == null) {
            return;
        }
        if (foundItems.contains(stack.func_77973_b())) {
            for (ItemStack s : stacks) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)s, (ItemStack)stack)) continue;
                s.field_77994_a += stack.field_77994_a;
                return;
            }
        }
        stacks.add(stack.func_77946_l());
        foundItems.add(stack.func_77973_b());
    }

    public List<ItemStack> getInventoryForBlock(BlockPos cpos) {
        HashSet<Item> foundItems = new HashSet<Item>();
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        this.lastSelectedInventory = cpos;
        if (cpos.func_177956_o() == -1) {
            for (BlockPos blockPos : this.inventories) {
                if (!this.routable.contains(blockPos)) continue;
                this.addItemsFromInventory(blockPos, foundItems, stacks);
            }
        } else {
            this.addItemsFromInventory(cpos, foundItems, stacks);
        }
        return stacks;
    }

    private void addItemsFromInventory(BlockPos cpos, Set<Item> foundItems, List<ItemStack> stacks) {
        block3: {
            TileEntity tileEntity;
            block2: {
                tileEntity = this.field_145850_b.func_175625_s(cpos);
                if (!RFToolsTools.hasItemCapabilitySafe(tileEntity)) break block2;
                IItemHandler capability = RFToolsTools.getItemCapabilitySafe(tileEntity);
                for (int i = 0; i < capability.getSlots(); ++i) {
                    this.addItemStack(stacks, foundItems, capability.getStackInSlot(i));
                }
                break block3;
            }
            if (!(tileEntity instanceof IInventory)) break block3;
            IInventory inventory = (IInventory)tileEntity;
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                this.addItemStack(stacks, foundItems, inventory.func_70301_a(i));
            }
        }
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        BlockPos c;
        NBTTagCompound tag;
        int i;
        super.func_145839_a(tagCompound);
        NBTTagList list = tagCompound.func_150295_c("inventories", 10);
        this.inventories.clear();
        for (i = 0; i < list.func_74745_c(); ++i) {
            tag = (NBTTagCompound)list.func_179238_g(i);
            c = BlockPosTools.readFromNBT((NBTTagCompound)tag, (String)"c");
            this.inventories.add(c);
        }
        list = tagCompound.func_150295_c("routable", 10);
        this.routable.clear();
        for (i = 0; i < list.func_74745_c(); ++i) {
            tag = (NBTTagCompound)list.func_179238_g(i);
            c = BlockPosTools.readFromNBT((NBTTagCompound)tag, (String)"c");
            this.routable.add(c);
        }
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
        this.radius = tagCompound.func_74762_e("radius");
        this.exportToCurrent = tagCompound.func_74767_n("exportC");
        this.craftingGrid.readFromNBT(tagCompound.func_74775_l("grid"));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        NBTTagCompound tag;
        super.func_189515_b(tagCompound);
        NBTTagList list = new NBTTagList();
        for (BlockPos c : this.inventories) {
            tag = BlockPosTools.writeToNBT((BlockPos)c);
            list.func_74742_a((NBTBase)tag);
        }
        tagCompound.func_74782_a("inventories", (NBTBase)list);
        list = new NBTTagList();
        for (BlockPos c : this.routable) {
            tag = BlockPosTools.writeToNBT((BlockPos)c);
            list.func_74742_a((NBTBase)tag);
        }
        tagCompound.func_74782_a("routable", (NBTBase)list);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
        tagCompound.func_74768_a("radius", this.radius);
        tagCompound.func_74757_a("exportC", this.exportToCurrent);
        tagCompound.func_74782_a("grid", (NBTBase)this.craftingGrid.writeToNBT());
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_SETRADIUS.equals(command)) {
            this.setRadius(args.get("r").getInteger());
            return true;
        }
        if (CMD_UP.equals(command)) {
            this.moveUp(args.get("index").getInteger());
            return true;
        }
        if (CMD_TOP.equals(command)) {
            this.moveTop(args.get("index").getInteger());
            return true;
        }
        if (CMD_DOWN.equals(command)) {
            this.moveDown(args.get("index").getInteger());
            return true;
        }
        if (CMD_BOTTOM.equals(command)) {
            this.moveBottom(args.get("index").getInteger());
            return true;
        }
        if (CMD_TOGGLEROUTABLE.equals(command)) {
            this.toggleRoutable(args.get("pos").getCoordinate());
            return true;
        }
        if (CMD_TOGGLEEXPORT.equals(command)) {
            this.toggleExportRoutable();
            return true;
        }
        return false;
    }

    public boolean isDummy() {
        return this.monitorDim != null;
    }

    public BlockPos getCraftingGridContainerPos() {
        return this.func_174877_v();
    }

    public CraftingGridProvider getCraftingGridProvider() {
        return this;
    }

    public BlockPos getStorageScannerPos() {
        return this.func_174877_v();
    }

    public int getDimension() {
        if (this.isDummy()) {
            return this.monitorDim;
        }
        return this.field_145850_b.field_73011_w.getDimension();
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index == 2;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return StorageScannerContainer.factory.isOutputSlot(index);
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public int[] func_180463_a(EnumFacing side) {
        return SLOTS;
    }
}

