/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.craftinggrid;

import io.netty.buffer.ByteBuf;
import mcjty.lib.network.NetworkTools;
import mcjty.rftools.craftinggrid.CraftingGrid;
import mcjty.rftools.craftinggrid.CraftingGridInventory;
import mcjty.rftools.craftinggrid.CraftingGridProvider;
import mcjty.rftools.craftinggrid.PacketGridSync;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketGridToServer
extends PacketGridSync
implements IMessage {
    private ItemStack[] stacks = new ItemStack[0];

    public void fromBytes(ByteBuf buf) {
        this.convertFromBytes(buf);
        int len = buf.readInt();
        this.stacks = new ItemStack[len];
        for (int i = 0; i < len; ++i) {
            this.stacks[i] = buf.readBoolean() ? NetworkTools.readItemStack((ByteBuf)buf) : null;
        }
    }

    public void toBytes(ByteBuf buf) {
        this.convertToBytes(buf);
        buf.writeInt(this.stacks.length);
        for (ItemStack stack : this.stacks) {
            if (stack != null) {
                buf.writeBoolean(true);
                NetworkTools.writeItemStack((ByteBuf)buf, (ItemStack)stack);
                continue;
            }
            buf.writeBoolean(false);
        }
    }

    public PacketGridToServer() {
    }

    public PacketGridToServer(BlockPos pos, CraftingGrid grid) {
        this.init(pos, grid);
        this.stacks = new ItemStack[10];
        for (int i = 0; i < 10; ++i) {
            this.stacks[i] = grid.getCraftingGridInventory().func_70301_a(i);
        }
    }

    public static class Handler
    implements IMessageHandler<PacketGridToServer, IMessage> {
        public IMessage onMessage(PacketGridToServer message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketGridToServer message, MessageContext ctx) {
            EntityPlayerMP player;
            World world = player.field_70170_p;
            player = ctx.getServerHandler().field_147369_b;
            CraftingGridProvider provider = message.handleMessage(world, (EntityPlayer)player);
            if (provider != null) {
                CraftingGridInventory inventory = provider.getCraftingGrid().getCraftingGridInventory();
                for (int i = 0; i < 10; ++i) {
                    inventory.func_70299_a(i, message.stacks[i]);
                }
                provider.markInventoryDirty();
            }
        }
    }
}

