/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.builder;

import com.google.common.collect.AbstractIterator;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.varia.Logging;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.builder.BuilderConfiguration;
import mcjty.rftools.blocks.builder.BuilderTileEntity;
import mcjty.rftools.items.GenericRFToolsItem;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.input.Keyboard;

public class ShapeCardItem
extends GenericRFToolsItem {
    public static final int CARD_UNKNOWN = -2;
    public static final int CARD_SPACE = -1;
    public static final int CARD_SHAPE = 0;
    public static final int CARD_VOID = 1;
    public static final int CARD_QUARRY = 2;
    public static final int CARD_QUARRY_SILK = 3;
    public static final int CARD_QUARRY_FORTUNE = 4;
    public static final int CARD_QUARRY_CLEAR = 5;
    public static final int CARD_QUARRY_CLEAR_SILK = 6;
    public static final int CARD_QUARRY_CLEAR_FORTUNE = 7;
    public static final int CARD_PUMP = 8;
    public static final int CARD_PUMP_CLEAR = 9;
    public static final int MAXIMUM_COUNT = 50000000;
    public static final int MODE_NONE = 0;
    public static final int MODE_CORNER1 = 1;
    public static final int MODE_CORNER2 = 2;

    public ShapeCardItem() {
        super("shape_card");
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation("rftools:shape_card_def", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)1, (ModelResourceLocation)new ModelResourceLocation("rftools:shape_card_void", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)2, (ModelResourceLocation)new ModelResourceLocation("rftools:shape_card_quarry", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)3, (ModelResourceLocation)new ModelResourceLocation("rftools:shape_card_quarry_silk", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)4, (ModelResourceLocation)new ModelResourceLocation("rftools:shape_card_quarry_fortune", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)5, (ModelResourceLocation)new ModelResourceLocation("rftools:shape_card_quarry_clear", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)6, (ModelResourceLocation)new ModelResourceLocation("rftools:shape_card_quarry_clear_silk", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)7, (ModelResourceLocation)new ModelResourceLocation("rftools:shape_card_quarry_clear_fortune", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)8, (ModelResourceLocation)new ModelResourceLocation("rftools:shape_card_pump", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)9, (ModelResourceLocation)new ModelResourceLocation("rftools:shape_card_pump_clear", "inventory"));
    }

    public int func_77626_a(ItemStack stack) {
        return 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) return EnumActionResult.SUCCESS;
        int mode = ShapeCardItem.getMode(stack);
        if (mode == 0) {
            if (!player.func_70093_af()) return EnumActionResult.SUCCESS;
            if (world.func_175625_s(pos) instanceof BuilderTileEntity) {
                ShapeCardItem.setCurrentBlock(stack, new GlobalCoordinate(pos, world.field_73011_w.getDimension()));
                Logging.message((EntityPlayer)player, (String)(TextFormatting.GREEN + "Now select the first corner"));
                ShapeCardItem.setMode(stack, 1);
                ShapeCardItem.setCorner1(stack, null);
                return EnumActionResult.SUCCESS;
            } else {
                Logging.message((EntityPlayer)player, (String)(TextFormatting.RED + "You can only do this on a builder!"));
            }
            return EnumActionResult.SUCCESS;
        } else if (mode == 1) {
            GlobalCoordinate currentBlock = ShapeCardItem.getCurrentBlock(stack);
            if (currentBlock.getDimension() != world.field_73011_w.getDimension()) {
                Logging.message((EntityPlayer)player, (String)(TextFormatting.RED + "The Builder is in another dimension!"));
                return EnumActionResult.SUCCESS;
            } else if (currentBlock.getCoordinate().equals((Object)pos)) {
                Logging.message((EntityPlayer)player, (String)(TextFormatting.RED + "Cleared area selection mode!"));
                ShapeCardItem.setMode(stack, 0);
                return EnumActionResult.SUCCESS;
            } else {
                Logging.message((EntityPlayer)player, (String)(TextFormatting.GREEN + "Now select the second corner"));
                ShapeCardItem.setMode(stack, 2);
                ShapeCardItem.setCorner1(stack, pos);
            }
            return EnumActionResult.SUCCESS;
        } else {
            GlobalCoordinate currentBlock = ShapeCardItem.getCurrentBlock(stack);
            if (currentBlock.getDimension() != world.field_73011_w.getDimension()) {
                Logging.message((EntityPlayer)player, (String)(TextFormatting.RED + "The Builder is in another dimension!"));
                return EnumActionResult.SUCCESS;
            } else if (currentBlock.getCoordinate().equals((Object)pos)) {
                Logging.message((EntityPlayer)player, (String)(TextFormatting.RED + "Cleared area selection mode!"));
                ShapeCardItem.setMode(stack, 0);
                return EnumActionResult.SUCCESS;
            } else {
                BlockPos c1;
                NBTTagCompound tag = stack.func_77978_p();
                if (tag == null) {
                    tag = new NBTTagCompound();
                    stack.func_77982_d(tag);
                }
                if ((c1 = ShapeCardItem.getCorner1(stack)) == null) {
                    Logging.message((EntityPlayer)player, (String)(TextFormatting.RED + "Cleared area selection mode!"));
                    ShapeCardItem.setMode(stack, 0);
                    return EnumActionResult.SUCCESS;
                } else {
                    Logging.message((EntityPlayer)player, (String)(TextFormatting.GREEN + "New settings copied to the shape card!"));
                    BlockPos center = new BlockPos((int)Math.ceil((float)(c1.func_177958_n() + pos.func_177958_n()) / 2.0f), (int)Math.ceil((float)(c1.func_177956_o() + pos.func_177956_o()) / 2.0f), (int)Math.ceil((float)(c1.func_177952_p() + pos.func_177952_p()) / 2.0f));
                    tag.func_74768_a("dimX", Math.abs(c1.func_177958_n() - pos.func_177958_n()) + 1);
                    tag.func_74768_a("dimY", Math.abs(c1.func_177956_o() - pos.func_177956_o()) + 1);
                    tag.func_74768_a("dimZ", Math.abs(c1.func_177952_p() - pos.func_177952_p()) + 1);
                    tag.func_74768_a("offsetX", center.func_177958_n() - currentBlock.getCoordinate().func_177958_n());
                    tag.func_74768_a("offsetY", center.func_177956_o() - currentBlock.getCoordinate().func_177956_o());
                    tag.func_74768_a("offsetZ", center.func_177952_p() - currentBlock.getCoordinate().func_177952_p());
                    ShapeCardItem.setMode(stack, 0);
                    ShapeCardItem.setCorner1(stack, null);
                }
            }
        }
        return EnumActionResult.SUCCESS;
    }

    public static void setCorner1(ItemStack itemStack, BlockPos corner) {
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            itemStack.func_77982_d(tagCompound);
        }
        if (corner == null) {
            tagCompound.func_82580_o("corner1x");
            tagCompound.func_82580_o("corner1y");
            tagCompound.func_82580_o("corner1z");
        } else {
            tagCompound.func_74768_a("corner1x", corner.func_177958_n());
            tagCompound.func_74768_a("corner1y", corner.func_177956_o());
            tagCompound.func_74768_a("corner1z", corner.func_177952_p());
        }
    }

    public static BlockPos getCorner1(ItemStack stack1) {
        NBTTagCompound tagCompound = stack1.func_77978_p();
        if (tagCompound == null) {
            return null;
        }
        if (!tagCompound.func_74764_b("corner1x")) {
            return null;
        }
        return new BlockPos(tagCompound.func_74762_e("corner1x"), tagCompound.func_74762_e("corner1y"), tagCompound.func_74762_e("corner1z"));
    }

    public static int getMode(ItemStack itemStack) {
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            return tagCompound.func_74762_e("mode");
        }
        return 0;
    }

    public static void setMode(ItemStack itemStack, int mode) {
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            itemStack.func_77982_d(tagCompound);
        }
        tagCompound.func_74768_a("mode", mode);
    }

    public static void setCurrentBlock(ItemStack itemStack, GlobalCoordinate c) {
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            itemStack.func_77982_d(tagCompound);
        }
        if (c == null) {
            tagCompound.func_82580_o("selectedX");
            tagCompound.func_82580_o("selectedY");
            tagCompound.func_82580_o("selectedZ");
            tagCompound.func_82580_o("selectedDim");
        } else {
            tagCompound.func_74768_a("selectedX", c.getCoordinate().func_177958_n());
            tagCompound.func_74768_a("selectedY", c.getCoordinate().func_177956_o());
            tagCompound.func_74768_a("selectedZ", c.getCoordinate().func_177952_p());
            tagCompound.func_74768_a("selectedDim", c.getDimension());
        }
    }

    public static GlobalCoordinate getCurrentBlock(ItemStack itemStack) {
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null && tagCompound.func_74764_b("selectedX")) {
            int x = tagCompound.func_74762_e("selectedX");
            int y = tagCompound.func_74762_e("selectedY");
            int z = tagCompound.func_74762_e("selectedZ");
            int dim = tagCompound.func_74762_e("selectedDim");
            return new GlobalCoordinate(new BlockPos(x, y, z), dim);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List<String> list, boolean whatIsThis) {
        super.func_77624_a(itemStack, player, list, whatIsThis);
        int type = itemStack.func_77952_i();
        if (!BuilderConfiguration.shapeCardAllowed) {
            list.add(TextFormatting.RED + "Disabled in config!");
        } else if (type != 0) {
            if (!BuilderConfiguration.quarryAllowed) {
                list.add(TextFormatting.RED + "Disabled in config!");
            } else if (ShapeCardItem.isClearingQuarry(type) && !BuilderConfiguration.clearingQuarryAllowed) {
                list.add(TextFormatting.RED + "Disabled in config!");
            }
        }
        Shape shape = ShapeCardItem.getShape(itemStack);
        list.add(TextFormatting.GREEN + "Shape " + shape.getDescription());
        list.add(TextFormatting.GREEN + "Dimension " + BlockPosTools.toString((BlockPos)ShapeCardItem.getDimension(itemStack)));
        list.add(TextFormatting.GREEN + "Offset " + BlockPosTools.toString((BlockPos)ShapeCardItem.getOffset(itemStack)));
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(TextFormatting.YELLOW + "Sneak right click on builder to start mark mode");
            list.add(TextFormatting.YELLOW + "Then right click to mark two corners of wanted area");
            switch (type) {
                case 8: {
                    list.add(TextFormatting.WHITE + "This item will cause the builder to collect");
                    list.add(TextFormatting.WHITE + "all liquids in the configured space.");
                    list.add(TextFormatting.WHITE + "The liquid will be replaced with " + this.getDirtOrCobbleName() + ".");
                    list.add(TextFormatting.GREEN + "Max area: " + BuilderConfiguration.maxBuilderDimension + "x" + Math.min(256, BuilderConfiguration.maxBuilderDimension) + "x" + BuilderConfiguration.maxBuilderDimension);
                    list.add(TextFormatting.GREEN + "Base cost: " + BuilderConfiguration.builderRfPerLiquid + " RF/t per block");
                    list.add(TextFormatting.GREEN + "(final cost depends on infusion level and block hardness)");
                    break;
                }
                case 9: {
                    list.add(TextFormatting.WHITE + "This item will cause the builder to collect");
                    list.add(TextFormatting.WHITE + "all liquids in the configured space.");
                    list.add(TextFormatting.WHITE + "The liquid will be removed from the world");
                    list.add(TextFormatting.GREEN + "Max area: " + BuilderConfiguration.maxBuilderDimension + "x" + Math.min(256, BuilderConfiguration.maxBuilderDimension) + "x" + BuilderConfiguration.maxBuilderDimension);
                    list.add(TextFormatting.GREEN + "Base cost: " + BuilderConfiguration.builderRfPerLiquid + " RF/t per block");
                    list.add(TextFormatting.GREEN + "(final cost depends on infusion level and block hardness)");
                    break;
                }
                case 1: {
                    list.add(TextFormatting.WHITE + "This item will cause the builder to void");
                    list.add(TextFormatting.WHITE + "all blocks in the configured space.");
                    list.add(TextFormatting.GREEN + "Max area: " + BuilderConfiguration.maxBuilderDimension + "x" + Math.min(256, BuilderConfiguration.maxBuilderDimension) + "x" + BuilderConfiguration.maxBuilderDimension);
                    list.add(TextFormatting.GREEN + "Base cost: " + (int)((double)BuilderConfiguration.builderRfPerQuarry * BuilderConfiguration.voidShapeCardFactor) + " RF/t per block");
                    list.add(TextFormatting.GREEN + "(final cost depends on infusion level and block hardness)");
                    break;
                }
                case 0: {
                    list.add(TextFormatting.WHITE + "This item can be configured as a shape. You");
                    list.add(TextFormatting.WHITE + "can then use it in the shield projector to make");
                    list.add(TextFormatting.WHITE + "a shield of that shape or in the builder to");
                    list.add(TextFormatting.WHITE + "actually build the shape");
                    list.add(TextFormatting.GREEN + "Max area: " + BuilderConfiguration.maxBuilderDimension + "x" + Math.min(256, BuilderConfiguration.maxBuilderDimension) + "x" + BuilderConfiguration.maxBuilderDimension);
                    list.add(TextFormatting.GREEN + "Base cost: " + BuilderConfiguration.builderRfPerOperation + " RF/t per block");
                    list.add(TextFormatting.GREEN + "(final cost depends on infusion level)");
                    break;
                }
                case 3: {
                    list.add(TextFormatting.WHITE + "This item will cause the builder to quarry");
                    list.add(TextFormatting.WHITE + "all blocks in the configured space and replace");
                    list.add(TextFormatting.WHITE + "them with " + this.getDirtOrCobbleName() + ".");
                    list.add(TextFormatting.WHITE + "Blocks are harvested with silk touch");
                    list.add(TextFormatting.GREEN + "Max area: " + BuilderConfiguration.maxBuilderDimension + "x" + Math.min(256, BuilderConfiguration.maxBuilderDimension) + "x" + BuilderConfiguration.maxBuilderDimension);
                    list.add(TextFormatting.GREEN + "Base cost: " + (int)((double)BuilderConfiguration.builderRfPerQuarry * BuilderConfiguration.silkquarryShapeCardFactor) + " RF/t per block");
                    list.add(TextFormatting.GREEN + "(final cost depends on infusion level and block hardness)");
                    break;
                }
                case 6: {
                    list.add(TextFormatting.WHITE + "This item will cause the builder to quarry");
                    list.add(TextFormatting.WHITE + "all blocks in the configured space.");
                    list.add(TextFormatting.WHITE + "Blocks are harvested with silk touch");
                    list.add(TextFormatting.GREEN + "Max area: " + BuilderConfiguration.maxBuilderDimension + "x" + Math.min(256, BuilderConfiguration.maxBuilderDimension) + "x" + BuilderConfiguration.maxBuilderDimension);
                    list.add(TextFormatting.GREEN + "Base cost: " + (int)((double)BuilderConfiguration.builderRfPerQuarry * BuilderConfiguration.silkquarryShapeCardFactor) + " RF/t per block");
                    list.add(TextFormatting.GREEN + "(final cost depends on infusion level and block hardness)");
                    break;
                }
                case 4: {
                    list.add(TextFormatting.WHITE + "This item will cause the builder to quarry");
                    list.add(TextFormatting.WHITE + "all blocks in the configured space and replace");
                    list.add(TextFormatting.WHITE + "them with " + this.getDirtOrCobbleName() + ".");
                    list.add(TextFormatting.WHITE + "Blocks are harvested with fortune");
                    list.add(TextFormatting.GREEN + "Max area: " + BuilderConfiguration.maxBuilderDimension + "x" + Math.min(256, BuilderConfiguration.maxBuilderDimension) + "x" + BuilderConfiguration.maxBuilderDimension);
                    list.add(TextFormatting.GREEN + "Base cost: " + (int)((double)BuilderConfiguration.builderRfPerQuarry * BuilderConfiguration.fortunequarryShapeCardFactor) + " RF/t per block");
                    list.add(TextFormatting.GREEN + "(final cost depends on infusion level and block hardness)");
                    break;
                }
                case 7: {
                    list.add(TextFormatting.WHITE + "This item will cause the builder to quarry");
                    list.add(TextFormatting.WHITE + "all blocks in the configured space.");
                    list.add(TextFormatting.WHITE + "Blocks are harvested with fortune");
                    list.add(TextFormatting.GREEN + "Max area: " + BuilderConfiguration.maxBuilderDimension + "x" + Math.min(256, BuilderConfiguration.maxBuilderDimension) + "x" + BuilderConfiguration.maxBuilderDimension);
                    list.add(TextFormatting.GREEN + "Base cost: " + (int)((double)BuilderConfiguration.builderRfPerQuarry * BuilderConfiguration.fortunequarryShapeCardFactor) + " RF/t per block");
                    list.add(TextFormatting.GREEN + "(final cost depends on infusion level and block hardness)");
                    break;
                }
                case 2: {
                    list.add(TextFormatting.WHITE + "This item will cause the builder to quarry");
                    list.add(TextFormatting.WHITE + "all blocks in the configured space and replace");
                    list.add(TextFormatting.WHITE + "them with " + this.getDirtOrCobbleName() + ".");
                    list.add(TextFormatting.GREEN + "Max area: " + BuilderConfiguration.maxBuilderDimension + "x" + Math.min(256, BuilderConfiguration.maxBuilderDimension) + "x" + BuilderConfiguration.maxBuilderDimension);
                    list.add(TextFormatting.GREEN + "Base cost: " + BuilderConfiguration.builderRfPerQuarry + " RF/t per block");
                    list.add(TextFormatting.GREEN + "(final cost depends on infusion level and block hardness)");
                    break;
                }
                case 5: {
                    list.add(TextFormatting.WHITE + "This item will cause the builder to quarry");
                    list.add(TextFormatting.WHITE + "all blocks in the configured space");
                    list.add(TextFormatting.GREEN + "Max area: " + BuilderConfiguration.maxBuilderDimension + "x" + Math.min(256, BuilderConfiguration.maxBuilderDimension) + "x" + BuilderConfiguration.maxBuilderDimension);
                    list.add(TextFormatting.GREEN + "Base cost: " + BuilderConfiguration.builderRfPerQuarry + " RF/t per block");
                    list.add(TextFormatting.GREEN + "(final cost depends on infusion level and block hardness)");
                }
            }
        } else {
            list.add(TextFormatting.WHITE + "<Press Shift>");
        }
    }

    private String getDirtOrCobbleName() {
        return BuilderConfiguration.quarryCobble ? "cobble" : "dirt";
    }

    public static boolean isNormalShapeCard(ItemStack stack) {
        return stack.func_77952_i() == 0;
    }

    public static boolean isClearingQuarry(int type) {
        return type == 5 || type == 7 || type == 6;
    }

    public static boolean isQuarry(int type) {
        return type == 5 || type == 7 || type == 6 || type == 2 || type == 4 || type == 3;
    }

    private static void addBlocks(Set<Block> blocks, Block block, boolean oredict) {
        blocks.add(block);
        if (oredict) {
            int[] iDs;
            for (int id : iDs = OreDictionary.getOreIDs((ItemStack)new ItemStack(block))) {
                String oreName = OreDictionary.getOreName((int)id);
                List ores = OreDictionary.getOres((String)oreName);
                for (ItemStack ore : ores) {
                    if (!(ore.func_77973_b() instanceof ItemBlock)) continue;
                    blocks.add(((ItemBlock)ore.func_77973_b()).func_179223_d());
                }
            }
        }
    }

    public static Set<Block> getVoidedBlocks(ItemStack stack) {
        HashSet<Block> blocks = new HashSet<Block>();
        boolean oredict = ShapeCardItem.isOreDictionary(stack);
        if (ShapeCardItem.isVoiding(stack, "stone")) {
            ShapeCardItem.addBlocks(blocks, Blocks.field_150348_b, oredict);
        }
        if (ShapeCardItem.isVoiding(stack, "cobble")) {
            ShapeCardItem.addBlocks(blocks, Blocks.field_150347_e, oredict);
        }
        if (ShapeCardItem.isVoiding(stack, "dirt")) {
            ShapeCardItem.addBlocks(blocks, Blocks.field_150346_d, oredict);
            ShapeCardItem.addBlocks(blocks, (Block)Blocks.field_150349_c, oredict);
        }
        if (ShapeCardItem.isVoiding(stack, "sand")) {
            ShapeCardItem.addBlocks(blocks, (Block)Blocks.field_150354_m, oredict);
        }
        if (ShapeCardItem.isVoiding(stack, "gravel")) {
            ShapeCardItem.addBlocks(blocks, Blocks.field_150351_n, oredict);
        }
        if (ShapeCardItem.isVoiding(stack, "netherrack")) {
            ShapeCardItem.addBlocks(blocks, Blocks.field_150424_aL, oredict);
        }
        return blocks;
    }

    public static boolean isOreDictionary(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            return false;
        }
        return tagCompound.func_74767_n("oredict");
    }

    public static boolean isVoiding(ItemStack stack, String material) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            return false;
        }
        return tagCompound.func_74767_n("void" + material);
    }

    public static Shape getShape(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            return Shape.SHAPE_SOLIDBOX;
        }
        int shape = tagCompound.func_74762_e("shape");
        Shape s = Shape.getShape(shape);
        if (s == null) {
            return Shape.SHAPE_SOLIDBOX;
        }
        return s;
    }

    public static void setShape(ItemStack stack, Shape shape) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            stack.func_77982_d(tagCompound);
        }
        tagCompound.func_74768_a("shape", shape.getIndex());
    }

    public static BlockPos getDimension(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            return new BlockPos(5, 5, 5);
        }
        if (!tagCompound.func_74764_b("dimX")) {
            return new BlockPos(5, 5, 5);
        }
        int dimX = tagCompound.func_74762_e("dimX");
        int dimY = tagCompound.func_74762_e("dimY");
        int dimZ = tagCompound.func_74762_e("dimZ");
        return new BlockPos(dimX, ShapeCardItem.clampDimension(dimY, 256), dimZ);
    }

    public static BlockPos getClampedDimension(ItemStack stack, int maximum) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            return new BlockPos(5, 5, 5);
        }
        int dimX = tagCompound.func_74762_e("dimX");
        int dimY = tagCompound.func_74762_e("dimY");
        int dimZ = tagCompound.func_74762_e("dimZ");
        return new BlockPos(ShapeCardItem.clampDimension(dimX, maximum), ShapeCardItem.clampDimension(dimY, maximum), ShapeCardItem.clampDimension(dimZ, maximum));
    }

    private static int clampDimension(int o, int maximum) {
        if (o > maximum) {
            o = maximum;
        } else if (o < 0) {
            o = 0;
        }
        return o;
    }

    public static BlockPos getOffset(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            return new BlockPos(0, 0, 0);
        }
        int offsetX = tagCompound.func_74762_e("offsetX");
        int offsetY = tagCompound.func_74762_e("offsetY");
        int offsetZ = tagCompound.func_74762_e("offsetZ");
        return new BlockPos(offsetX, offsetY, offsetZ);
    }

    public static BlockPos getClampedOffset(ItemStack stack, int maximum) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            return new BlockPos(0, 0, 0);
        }
        int offsetX = tagCompound.func_74762_e("offsetX");
        int offsetY = tagCompound.func_74762_e("offsetY");
        int offsetZ = tagCompound.func_74762_e("offsetZ");
        return new BlockPos(ShapeCardItem.clampOffset(offsetX, maximum), ShapeCardItem.clampOffset(offsetY, maximum), ShapeCardItem.clampOffset(offsetZ, maximum));
    }

    private static int clampOffset(int o, int maximum) {
        if (o < -maximum) {
            o = -maximum;
        } else if (o > maximum) {
            o = maximum;
        }
        return o;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (world.field_72995_K) {
            player.openGui((Object)RFTools.instance, RFTools.GUI_SHAPECARD, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public static BlockPos getMinCorner(BlockPos thisCoord, BlockPos dimension, BlockPos offset) {
        int xCoord = thisCoord.func_177958_n();
        int yCoord = thisCoord.func_177956_o();
        int zCoord = thisCoord.func_177952_p();
        int dx = dimension.func_177958_n();
        int dy = dimension.func_177956_o();
        int dz = dimension.func_177952_p();
        return new BlockPos(xCoord - dx / 2 + offset.func_177958_n(), yCoord - dy / 2 + offset.func_177956_o(), zCoord - dz / 2 + offset.func_177952_p());
    }

    public static BlockPos getMaxCorner(BlockPos thisCoord, BlockPos dimension, BlockPos offset) {
        int dx = dimension.func_177958_n();
        int dy = dimension.func_177956_o();
        int dz = dimension.func_177952_p();
        BlockPos minCorner = ShapeCardItem.getMinCorner(thisCoord, dimension, offset);
        return new BlockPos(minCorner.func_177958_n() + dx, minCorner.func_177956_o() + dy, minCorner.func_177952_p() + dz);
    }

    public static int countBlocks(Shape shape, BlockPos dimension) {
        final int[] cnt = new int[]{0};
        BlockPos offset = new BlockPos(0, 128, 0);
        BlockPos clamped = new BlockPos(Math.min(dimension.func_177958_n(), 512), Math.min(dimension.func_177956_o(), 256), Math.min(dimension.func_177952_p(), 512));
        ShapeCardItem.composeShape(shape, null, new BlockPos(0, 0, 0), clamped, offset, (Collection<BlockPos>)new AbstractCollection<BlockPos>(){

            @Override
            public Iterator<BlockPos> iterator() {
                return new AbstractIterator<BlockPos>(){

                    protected BlockPos computeNext() {
                        return null;
                    }
                };
            }

            @Override
            public boolean add(BlockPos coordinate) {
                cnt[0] = cnt[0] + 1;
                return true;
            }

            @Override
            public int size() {
                return 0;
            }
        }, 50000001, false, null);
        return cnt[0];
    }

    public static boolean xInChunk(int x, ChunkPos chunk) {
        if (chunk == null) {
            return true;
        }
        return chunk.field_77276_a == x >> 4;
    }

    public static boolean zInChunk(int z, ChunkPos chunk) {
        if (chunk == null) {
            return true;
        }
        return chunk.field_77275_b == z >> 4;
    }

    public static void composeShape(Shape shape, World worldObj, BlockPos thisCoord, BlockPos dimension, BlockPos offset, Collection<BlockPos> blocks, int maxSize, boolean forquarry, ChunkPos chunk) {
        switch (shape) {
            case SHAPE_BOX: {
                ShapeCardItem.composeBox(worldObj, thisCoord, dimension, offset, blocks, maxSize, false, forquarry, chunk);
                break;
            }
            case SHAPE_SOLIDBOX: {
                ShapeCardItem.composeBox(worldObj, thisCoord, dimension, offset, blocks, maxSize, true, forquarry, chunk);
                break;
            }
            case SHAPE_TOPDOME: {
                ShapeCardItem.composeSphere(worldObj, thisCoord, dimension, offset, blocks, maxSize, 1, false, forquarry, chunk);
                break;
            }
            case SHAPE_BOTTOMDOME: {
                ShapeCardItem.composeSphere(worldObj, thisCoord, dimension, offset, blocks, maxSize, -1, false, forquarry, chunk);
                break;
            }
            case SHAPE_SOLIDTOPDOME: {
                ShapeCardItem.composeSphere(worldObj, thisCoord, dimension, offset, blocks, maxSize, 1, true, forquarry, chunk);
                break;
            }
            case SHAPE_SOLIDBOTTOMDOME: {
                ShapeCardItem.composeSphere(worldObj, thisCoord, dimension, offset, blocks, maxSize, -1, true, forquarry, chunk);
                break;
            }
            case SHAPE_SPHERE: {
                ShapeCardItem.composeSphere(worldObj, thisCoord, dimension, offset, blocks, maxSize, 0, false, forquarry, chunk);
                break;
            }
            case SHAPE_SOLIDSPHERE: {
                ShapeCardItem.composeSphere(worldObj, thisCoord, dimension, offset, blocks, maxSize, 0, true, forquarry, chunk);
                break;
            }
            case SHAPE_CYLINDER: {
                ShapeCardItem.composeCylinder(worldObj, thisCoord, dimension, offset, blocks, maxSize, false, false, forquarry, chunk);
                break;
            }
            case SHAPE_SOLIDCYLINDER: {
                ShapeCardItem.composeCylinder(worldObj, thisCoord, dimension, offset, blocks, maxSize, true, true, forquarry, chunk);
                break;
            }
            case SHAPE_CAPPEDCYLINDER: {
                ShapeCardItem.composeCylinder(worldObj, thisCoord, dimension, offset, blocks, maxSize, true, false, forquarry, chunk);
                break;
            }
            case SHAPE_PRISM: {
                ShapeCardItem.composePrism(worldObj, thisCoord, dimension, offset, blocks, maxSize, forquarry, chunk);
                break;
            }
            case SHAPE_TORUS: {
                ShapeCardItem.composeTorus(worldObj, thisCoord, dimension, offset, blocks, maxSize, false, forquarry, chunk);
                break;
            }
            case SHAPE_SOLIDTORUS: {
                ShapeCardItem.composeTorus(worldObj, thisCoord, dimension, offset, blocks, maxSize, true, forquarry, chunk);
            }
        }
    }

    private static void placeBlockIfPossible(World worldObj, Collection<BlockPos> blocks, int maxSize, int x, int y, int z, boolean forquarry) {
        BlockPos c = new BlockPos(x, y, z);
        if (worldObj == null) {
            blocks.add(c);
            return;
        }
        if (forquarry) {
            if (worldObj.func_175623_d(c)) {
                return;
            }
            blocks.add(c);
        } else if (BuilderTileEntity.isEmptyOrReplacable(worldObj, c) && blocks.size() < maxSize - 1) {
            blocks.add(c);
        }
    }

    private static void composeSphere(World worldObj, BlockPos thisCoord, BlockPos dimension, BlockPos offset, Collection<BlockPos> blocks, int maxSize, int side, boolean solid, boolean forquarry, ChunkPos chunk) {
        int xCoord = thisCoord.func_177958_n();
        int yCoord = thisCoord.func_177956_o();
        int zCoord = thisCoord.func_177952_p();
        int dx = dimension.func_177958_n();
        int dy = dimension.func_177956_o();
        int dz = dimension.func_177952_p();
        float centerx = (float)(xCoord + offset.func_177958_n()) + (dx % 2 != 0 ? 0.0f : -0.5f);
        float centery = (float)(yCoord + offset.func_177956_o()) + (dy % 2 != 0 ? 0.0f : -0.5f);
        float centerz = (float)(zCoord + offset.func_177952_p()) + (dz % 2 != 0 ? 0.0f : -0.5f);
        BlockPos tl = new BlockPos(xCoord - dx / 2 + offset.func_177958_n(), yCoord - dy / 2 + offset.func_177956_o(), zCoord - dz / 2 + offset.func_177952_p());
        float factor = 1.8f;
        float dx2 = dx == 0 ? 0.5f : ((float)dx + factor) * ((float)dx + factor) / 4.0f;
        float dy2 = dy == 0 ? 0.5f : ((float)dy + factor) * ((float)dy + factor) / 4.0f;
        float dz2 = dz == 0 ? 0.5f : ((float)dz + factor) * ((float)dz + factor) / 4.0f;
        int davg = (int)(((float)(dx + dy + dz) + factor * 3.0f) / 3.0f);
        for (int ox = 0; ox < dx; ++ox) {
            int x = tl.func_177958_n() + ox;
            if (!ShapeCardItem.xInChunk(x, chunk)) continue;
            for (int oz = 0; oz < dz; ++oz) {
                int z = tl.func_177952_p() + oz;
                if (!ShapeCardItem.zInChunk(z, chunk)) continue;
                for (int oy = 0; oy < dy; ++oy) {
                    int cnt;
                    int y = tl.func_177956_o() + oy;
                    if (y < 0 || y >= 255 || side != 0 && (side != 1 || y < yCoord + offset.func_177956_o()) && (side != -1 || y > yCoord + offset.func_177956_o()) || ShapeCardItem.isInside3D(centerx, centery, centerz, x, y, z, dx2, dy2, dz2, davg) != 1) continue;
                    if (solid) {
                        cnt = 0;
                    } else {
                        cnt = ShapeCardItem.isInside3D(centerx, centery, centerz, x - 1, y, z, dx2, dy2, dz2, davg);
                        cnt += ShapeCardItem.isInside3D(centerx, centery, centerz, x + 1, y, z, dx2, dy2, dz2, davg);
                        cnt += ShapeCardItem.isInside3D(centerx, centery, centerz, x, y - 1, z, dx2, dy2, dz2, davg);
                        cnt += ShapeCardItem.isInside3D(centerx, centery, centerz, x, y + 1, z, dx2, dy2, dz2, davg);
                        cnt += ShapeCardItem.isInside3D(centerx, centery, centerz, x, y, z - 1, dx2, dy2, dz2, davg);
                        cnt += ShapeCardItem.isInside3D(centerx, centery, centerz, x, y, z + 1, dx2, dy2, dz2, davg);
                    }
                    if (cnt == 6) continue;
                    ShapeCardItem.placeBlockIfPossible(worldObj, blocks, maxSize, x, y, z, forquarry);
                }
            }
        }
    }

    private static float squaredDistance3D(float cx, float cy, float cz, float x1, float y1, float z1, float dx2, float dy2, float dz2) {
        return (x1 - cx) * (x1 - cx) / dx2 + (y1 - cy) * (y1 - cy) / dy2 + (z1 - cz) * (z1 - cz) / dz2;
    }

    private static float squaredDistance2D(float cx, float cz, float x1, float z1, float dx2, float dz2) {
        return (x1 - cx) * (x1 - cx) / dx2 + (z1 - cz) * (z1 - cz) / dz2;
    }

    private static int isInside2D(float centerx, float centerz, int x, int z, float dx2, float dz2, int davg) {
        double distance = Math.sqrt(ShapeCardItem.squaredDistance2D(centerx, centerz, x, z, dx2, dz2));
        return (int)(distance * (double)(davg / 2 + 1)) <= davg / 2 - 1 ? 1 : 0;
    }

    private static int isInside3D(float centerx, float centery, float centerz, int x, int y, int z, float dx2, float dy2, float dz2, int davg) {
        double distance = Math.sqrt(ShapeCardItem.squaredDistance3D(centerx, centery, centerz, x, y, z, dx2, dy2, dz2));
        return (int)(distance * (double)(davg / 2 + 1)) <= davg / 2 - 1 ? 1 : 0;
    }

    private static void composeCylinder(World worldObj, BlockPos thisCoord, BlockPos dimension, BlockPos offset, Collection<BlockPos> blocks, int maxSize, boolean capped, boolean solid, boolean forquarry, ChunkPos chunk) {
        int xCoord = thisCoord.func_177958_n();
        int yCoord = thisCoord.func_177956_o();
        int zCoord = thisCoord.func_177952_p();
        int dx = dimension.func_177958_n();
        int dy = dimension.func_177956_o();
        int dz = dimension.func_177952_p();
        float centerx = (float)(xCoord + offset.func_177958_n()) + (dx % 2 != 0 ? 0.0f : -0.5f);
        float centerz = (float)(zCoord + offset.func_177952_p()) + (dz % 2 != 0 ? 0.0f : -0.5f);
        BlockPos tl = new BlockPos(xCoord - dx / 2 + offset.func_177958_n(), yCoord - dy / 2 + offset.func_177956_o(), zCoord - dz / 2 + offset.func_177952_p());
        float factor = 1.7f;
        float dx2 = dx == 0 ? 0.5f : ((float)dx + factor) * ((float)dx + factor) / 4.0f;
        float dz2 = dz == 0 ? 0.5f : ((float)dz + factor) * ((float)dz + factor) / 4.0f;
        int davg = (int)(((float)(dx + dz) + factor * 2.0f) / 2.0f);
        for (int ox = 0; ox < dx; ++ox) {
            int x = tl.func_177958_n() + ox;
            if (!ShapeCardItem.xInChunk(x, chunk)) continue;
            for (int oz = 0; oz < dz; ++oz) {
                int z = tl.func_177952_p() + oz;
                if (!ShapeCardItem.zInChunk(z, chunk)) continue;
                for (int oy = 0; oy < dy; ++oy) {
                    int cnt;
                    int y = tl.func_177956_o() + oy;
                    if (y < 0 || y >= 255 || ShapeCardItem.isInside2D(centerx, centerz, x, z, dx2, dz2, davg) != 1) continue;
                    if (solid) {
                        cnt = 0;
                    } else {
                        cnt = ShapeCardItem.isInside2D(centerx, centerz, x - 1, z, dx2, dz2, davg);
                        cnt += ShapeCardItem.isInside2D(centerx, centerz, x + 1, z, dx2, dz2, davg);
                        cnt += ShapeCardItem.isInside2D(centerx, centerz, x, z - 1, dx2, dz2, davg);
                        cnt += ShapeCardItem.isInside2D(centerx, centerz, x, z + 1, dx2, dz2, davg);
                    }
                    if (cnt == 4 && (!capped || oy != 0 && oy != dy - 1)) continue;
                    ShapeCardItem.placeBlockIfPossible(worldObj, blocks, maxSize, x, y, z, forquarry);
                }
            }
        }
    }

    private static void composeBox(World worldObj, BlockPos thisCoord, BlockPos dimension, BlockPos offset, Collection<BlockPos> blocks, int maxSize, boolean solid, boolean forquarry, ChunkPos chunk) {
        int xCoord = thisCoord.func_177958_n();
        int yCoord = thisCoord.func_177956_o();
        int zCoord = thisCoord.func_177952_p();
        int dx = dimension.func_177958_n();
        int dy = dimension.func_177956_o();
        int dz = dimension.func_177952_p();
        BlockPos tl = new BlockPos(xCoord - dx / 2 + offset.func_177958_n(), yCoord - dy / 2 + offset.func_177956_o(), zCoord - dz / 2 + offset.func_177952_p());
        for (int ox = 0; ox < dx; ++ox) {
            int x = tl.func_177958_n() + ox;
            if (!ShapeCardItem.xInChunk(x, chunk)) continue;
            for (int oz = 0; oz < dz; ++oz) {
                int z = tl.func_177952_p() + oz;
                if (!ShapeCardItem.zInChunk(z, chunk)) continue;
                for (int oy = 0; oy < dy; ++oy) {
                    int y = tl.func_177956_o() + oy;
                    if (y < 0 || y >= 255 || !solid && ox != 0 && oy != 0 && oz != 0 && ox != dx - 1 && oy != dy - 1 && oz != dz - 1) continue;
                    ShapeCardItem.placeBlockIfPossible(worldObj, blocks, maxSize, x, y, z, forquarry);
                }
            }
        }
    }

    private static void composePrism(World worldObj, BlockPos thisCoord, BlockPos dimension, BlockPos offset, Collection<BlockPos> blocks, int maxSize, boolean forquarry, ChunkPos chunk) {
        int xCoord = thisCoord.func_177958_n();
        int yCoord = thisCoord.func_177956_o();
        int zCoord = thisCoord.func_177952_p();
        int dx = dimension.func_177958_n();
        int dy = dimension.func_177956_o();
        int dz = dimension.func_177952_p();
        BlockPos tl = new BlockPos(xCoord - dx / 2 + offset.func_177958_n(), yCoord - dy / 2 + offset.func_177956_o(), zCoord - dz / 2 + offset.func_177952_p());
        for (int oy = 0; oy < dy; ++oy) {
            int y = tl.func_177956_o() + oy;
            if (y < 0 || y >= 255) continue;
            int yoffset = oy;
            for (int ox = 0; ox < dx; ++ox) {
                int x;
                if (ox < yoffset || ox >= dx - yoffset || !ShapeCardItem.xInChunk(x = tl.func_177958_n() + ox, chunk)) continue;
                for (int oz = yoffset; oz < dz - yoffset; ++oz) {
                    int z = tl.func_177952_p() + oz;
                    if (!ShapeCardItem.zInChunk(z, chunk) || ox != yoffset && oy != 0 && oz != yoffset && ox != dx - yoffset - 1 && oz != dz - yoffset - 1) continue;
                    ShapeCardItem.placeBlockIfPossible(worldObj, blocks, maxSize, x, y, z, forquarry);
                }
            }
        }
    }

    private static int isInsideTorus(float centerx, float centery, float centerz, int x, int y, int z, float bigRadius, float smallRadius) {
        double rr = (double)bigRadius - Math.sqrt(((float)x - centerx) * ((float)x - centerx) + ((float)z - centerz) * ((float)z - centerz));
        double f = rr * rr + (double)(((float)y - centery) * ((float)y - centery)) - (double)(smallRadius * smallRadius);
        if (f < 0.0) {
            return 1;
        }
        return 0;
    }

    private static void composeTorus(World worldObj, BlockPos thisCoord, BlockPos dimension, BlockPos offset, Collection<BlockPos> blocks, int maxSize, boolean solid, boolean forquarry, ChunkPos chunk) {
        int xCoord = thisCoord.func_177958_n();
        int yCoord = thisCoord.func_177956_o();
        int zCoord = thisCoord.func_177952_p();
        int dx = dimension.func_177958_n();
        int dy = dimension.func_177956_o();
        int dz = dimension.func_177952_p();
        float centerx = xCoord + offset.func_177958_n();
        float centery = yCoord + offset.func_177956_o();
        float centerz = zCoord + offset.func_177952_p();
        BlockPos tl = new BlockPos(xCoord - dx / 2 + offset.func_177958_n(), yCoord - dy / 2 + offset.func_177956_o(), zCoord - dz / 2 + offset.func_177952_p());
        float smallRadius = (float)(dy - 2) / 2.0f;
        float bigRadius = (float)(dx - 2) / 2.0f - smallRadius;
        for (int ox = 0; ox < dx; ++ox) {
            int x = tl.func_177958_n() + ox;
            if (!ShapeCardItem.xInChunk(x, chunk)) continue;
            for (int oz = 0; oz < dz; ++oz) {
                int z = tl.func_177952_p() + oz;
                if (!ShapeCardItem.zInChunk(z, chunk)) continue;
                for (int oy = 0; oy < dy; ++oy) {
                    int cnt;
                    int y = tl.func_177956_o() + oy;
                    if (y < 0 || y >= 255 || ShapeCardItem.isInsideTorus(centerx, centery, centerz, x, y, z, bigRadius, smallRadius) != 1) continue;
                    if (solid) {
                        cnt = 0;
                    } else {
                        cnt = ShapeCardItem.isInsideTorus(centerx, centery, centerz, x - 1, y, z, bigRadius, smallRadius);
                        cnt += ShapeCardItem.isInsideTorus(centerx, centery, centerz, x + 1, y, z, bigRadius, smallRadius);
                        cnt += ShapeCardItem.isInsideTorus(centerx, centery, centerz, x, y, z - 1, bigRadius, smallRadius);
                        cnt += ShapeCardItem.isInsideTorus(centerx, centery, centerz, x, y, z + 1, bigRadius, smallRadius);
                        cnt += ShapeCardItem.isInsideTorus(centerx, centery, centerz, x, y - 1, z, bigRadius, smallRadius);
                        cnt += ShapeCardItem.isInsideTorus(centerx, centery, centerz, x, y + 1, z, bigRadius, smallRadius);
                    }
                    if (cnt == 6) continue;
                    ShapeCardItem.placeBlockIfPossible(worldObj, blocks, maxSize, x, y, z, forquarry);
                }
            }
        }
    }

    public String func_77667_c(ItemStack itemStack) {
        if (itemStack.func_77952_i() == 0) {
            return super.func_77667_c(itemStack);
        }
        return super.func_77667_c(itemStack) + itemStack.func_77952_i();
    }

    public void func_150895_a(Item item, CreativeTabs creativeTabs, List<ItemStack> list) {
        for (int i = 0; i <= 9; ++i) {
            list.add(new ItemStack((Item)this, 1, i));
        }
    }

    public static enum Shape {
        SHAPE_BOX(0, "Box"),
        SHAPE_TOPDOME(1, "Top Dome"),
        SHAPE_BOTTOMDOME(2, "Bottom Dome"),
        SHAPE_SPHERE(3, "Sphere"),
        SHAPE_CYLINDER(4, "Cylinder"),
        SHAPE_CAPPEDCYLINDER(5, "Capped Cylinder"),
        SHAPE_PRISM(6, "Prism"),
        SHAPE_TORUS(7, "Torus"),
        SHAPE_SOLIDBOX(100, "Solid Box"),
        SHAPE_SOLIDSPHERE(103, "Solid Sphere"),
        SHAPE_SOLIDCYLINDER(104, "Solid Cylinder"),
        SHAPE_SOLIDTORUS(107, "Solid Torus"),
        SHAPE_SOLIDTOPDOME(101, "Solid Top Dome"),
        SHAPE_SOLIDBOTTOMDOME(102, "Solid Bottom Dome");

        private final int index;
        private final String description;
        private static Map<Integer, Shape> shapes;
        private static Map<String, Shape> shapesByDescription;

        public Shape makeHollow() {
            switch (this) {
                case SHAPE_SOLIDBOX: {
                    return SHAPE_BOX;
                }
                case SHAPE_SOLIDSPHERE: {
                    return SHAPE_SPHERE;
                }
                case SHAPE_SOLIDCYLINDER: {
                    return SHAPE_CAPPEDCYLINDER;
                }
                case SHAPE_SOLIDTORUS: {
                    return SHAPE_TORUS;
                }
                case SHAPE_SOLIDTOPDOME: {
                    return SHAPE_TOPDOME;
                }
                case SHAPE_SOLIDBOTTOMDOME: {
                    return SHAPE_BOTTOMDOME;
                }
            }
            return this;
        }

        private Shape(int index, String description) {
            this.index = index;
            this.description = description;
        }

        public int getIndex() {
            return this.index;
        }

        public String getDescription() {
            return this.description;
        }

        public static Shape getShape(int index) {
            return shapes.get(index);
        }

        public static Shape getShape(String description) {
            return shapesByDescription.get(description);
        }

        static {
            shapesByDescription = new HashMap<String, Shape>();
            shapes = new HashMap<Integer, Shape>();
            for (Shape shape : Shape.values()) {
                shapes.put(shape.getIndex(), shape);
                shapesByDescription.put(shape.getDescription(), shape);
            }
        }
    }
}

