/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.storage;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mcjty.lib.container.InventoryHelper;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.storage.ModularStorageTileEntity;
import mcjty.rftools.items.GenericRFToolsItem;
import mcjty.rftools.items.storage.StorageFilterCache;
import mcjty.rftools.items.storage.StorageFilterInventory;
import mcjty.rftools.items.storage.StorageModuleItem;
import mcjty.rftools.items.storage.StorageTypeItem;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class StorageFilterItem
extends GenericRFToolsItem {
    public StorageFilterItem() {
        super("filter_module");
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List<String> list, boolean whatIsThis) {
        super.func_77624_a(itemStack, player, list, whatIsThis);
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            String blackListMode = tagCompound.func_74779_i("blacklistMode");
            String modeLine = "Mode " + ("Black".equals(blackListMode) ? "blacklist" : "whitelist");
            if (tagCompound.func_74767_n("oredictMode")) {
                modeLine = modeLine + ", Oredict";
            }
            if (tagCompound.func_74767_n("damageMode")) {
                modeLine = modeLine + ", Damage";
            }
            if (tagCompound.func_74767_n("nbtMode")) {
                modeLine = modeLine + ", NBT";
            }
            if (tagCompound.func_74767_n("modMode")) {
                modeLine = modeLine + ", Mod";
            }
            list.add(TextFormatting.BLUE + modeLine);
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(TextFormatting.WHITE + "This filter module is for the Modular Storage block.");
            list.add(TextFormatting.WHITE + "This module can make sure the storage block only accepts");
            list.add(TextFormatting.WHITE + "certain types of items");
            list.add(TextFormatting.YELLOW + "Sneak-right click on an inventory to");
            list.add(TextFormatting.YELLOW + "configure the filter based on contents");
        } else {
            list.add(TextFormatting.WHITE + "<Press Shift>");
        }
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (playerIn.func_70093_af()) {
            if (!worldIn.field_72995_K) {
                TileEntity te = worldIn.func_175625_s(pos);
                if (InventoryHelper.isInventory((TileEntity)te)) {
                    ArrayList stacks = new ArrayList();
                    HashSet registeredItems = new HashSet();
                    InventoryHelper.getItems((TileEntity)te, s -> true).forEach(s -> this.addItem(te, stacks, registeredItems, (ItemStack)s));
                    if (!stack.func_77942_o()) {
                        stack.func_77982_d(new NBTTagCompound());
                    }
                    StorageFilterInventory.convertItemsToNBT(stack.func_77978_p(), stacks.toArray(new ItemStack[stacks.size()]));
                    playerIn.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Stored inventory contents in filter"));
                } else {
                    IBlockState state = worldIn.func_180495_p(pos);
                    ItemStack blockStack = state.func_177230_c().func_185473_a(worldIn, pos, state);
                    if (blockStack != null) {
                        int i;
                        if (!stack.func_77942_o()) {
                            stack.func_77982_d(new NBTTagCompound());
                        }
                        HashSet registeredItems = new HashSet();
                        ItemStack[] stacks = new ItemStack[30];
                        NBTTagList bufferTagList = stack.func_77978_p().func_150295_c("Items", 10);
                        for (i = 0; i < bufferTagList.func_74745_c(); ++i) {
                            NBTTagCompound nbtTagCompound = bufferTagList.func_150305_b(i);
                            stacks[i] = ItemStack.func_77949_a((NBTTagCompound)nbtTagCompound);
                        }
                        for (i = 0; i < 30; ++i) {
                            if (stacks[i] != null) continue;
                            stacks[i] = blockStack;
                            playerIn.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Added " + blockStack.func_82833_r() + " to the filter!"));
                            StorageFilterInventory.convertItemsToNBT(stack.func_77978_p(), stacks);
                            break;
                        }
                    }
                }
            }
            return EnumActionResult.SUCCESS;
        }
        return super.func_180614_a(stack, playerIn, worldIn, pos, hand, facing, hitX, hitY, hitZ);
    }

    private void addItem(TileEntity te, List<ItemStack> stacks, Set<ResourceLocation> registeredItems, ItemStack s) {
        if (registeredItems.contains(s.func_77973_b().getRegistryName())) {
            return;
        }
        if (te instanceof ModularStorageTileEntity && (s.func_77973_b() instanceof StorageModuleItem || s.func_77973_b() instanceof StorageFilterItem || s.func_77973_b() instanceof StorageTypeItem)) {
            return;
        }
        if (stacks.size() < 30) {
            ItemStack copy = s.func_77946_l();
            copy.field_77994_a = 1;
            stacks.add(copy);
            registeredItems.add(s.func_77973_b().getRegistryName());
        }
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K) {
            player.openGui((Object)RFTools.instance, RFTools.GUI_STORAGE_FILTER, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public static StorageFilterCache getCache(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        return new StorageFilterCache(stack);
    }
}

