/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.api.multiblock;

import it.zerono.mods.zerocore.api.multiblock.IMultiblockPart;
import it.zerono.mods.zerocore.api.multiblock.IMultiblockRegistry;
import it.zerono.mods.zerocore.api.multiblock.MultiblockControllerBase;
import it.zerono.mods.zerocore.internal.ZeroCore;
import it.zerono.mods.zerocore.lib.block.ModTileEntity;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLLog;

public abstract class MultiblockTileEntityBase
extends ModTileEntity
implements IMultiblockPart {
    private MultiblockControllerBase controller = null;
    private boolean visited = false;
    private boolean saveMultiblockData = false;
    private NBTTagCompound cachedMultiblockData = null;
    private boolean paused = false;
    private static final IMultiblockRegistry REGISTRY = ZeroCore.getProxy().initMultiblockRegistry();

    @Override
    public Set<MultiblockControllerBase> attachToNeighbors() {
        IMultiblockPart[] partsToCheck;
        HashSet<MultiblockControllerBase> controllers = null;
        MultiblockControllerBase bestController = null;
        for (IMultiblockPart neighborPart : partsToCheck = this.getNeighboringParts()) {
            MultiblockControllerBase candidate;
            if (!neighborPart.isConnected() || !(candidate = neighborPart.getMultiblockController()).getClass().equals(this.getMultiblockControllerType())) continue;
            if (controllers == null) {
                controllers = new HashSet<MultiblockControllerBase>();
                bestController = candidate;
            } else if (!controllers.contains(candidate) && candidate.shouldConsume(bestController)) {
                bestController = candidate;
            }
            controllers.add(candidate);
        }
        if (bestController != null) {
            this.controller = bestController;
            bestController.attachBlock(this);
        }
        return controllers;
    }

    @Override
    public void assertDetached() {
        if (this.controller != null) {
            BlockPos coord = this.getWorldPosition();
            FMLLog.info((String)"[assert] Part @ (%d, %d, %d) should be detached already, but detected that it was not. This is not a fatal error, and will be repaired, but is unusual.", (Object[])new Object[]{coord.func_177958_n(), coord.func_177956_o(), coord.func_177952_p()});
            this.controller = null;
        }
    }

    @Override
    protected void syncDataFrom(NBTTagCompound data, ModTileEntity.SyncReason syncReason) {
        if (ModTileEntity.SyncReason.FullSync == syncReason) {
            if (data.func_74764_b("multiblockData")) {
                this.cachedMultiblockData = data.func_74775_l("multiblockData");
            }
        } else if (data.func_74764_b("multiblockData")) {
            NBTTagCompound tag = data.func_74775_l("multiblockData");
            if (this.isConnected()) {
                this.getMultiblockController().syncDataFrom(tag, syncReason);
            } else {
                this.cachedMultiblockData = tag;
            }
        }
    }

    @Override
    protected void syncDataTo(NBTTagCompound data, ModTileEntity.SyncReason syncReason) {
        if (ModTileEntity.SyncReason.FullSync == syncReason) {
            if (this.isMultiblockSaveDelegate() && this.isConnected()) {
                NBTTagCompound multiblockData = new NBTTagCompound();
                this.controller.syncDataTo(multiblockData, syncReason);
                data.func_74782_a("multiblockData", (NBTBase)multiblockData);
            }
        } else if (this.isMultiblockSaveDelegate() && this.isConnected()) {
            NBTTagCompound tag = new NBTTagCompound();
            this.getMultiblockController().syncDataTo(tag, syncReason);
            data.func_74782_a("multiblockData", (NBTBase)tag);
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.detachSelf(false);
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        this.detachSelf(true);
    }

    public void func_145829_t() {
        super.func_145829_t();
        REGISTRY.onPartAdded(this.field_145850_b, this);
    }

    @Override
    public boolean hasMultiblockSaveData() {
        return this.cachedMultiblockData != null;
    }

    @Override
    public NBTTagCompound getMultiblockSaveData() {
        return this.cachedMultiblockData;
    }

    @Override
    public void onMultiblockDataAssimilated() {
        this.cachedMultiblockData = null;
    }

    @Override
    public abstract void onMachineAssembled(MultiblockControllerBase var1);

    @Override
    public abstract void onMachineBroken();

    @Override
    public abstract void onMachineActivated();

    @Override
    public abstract void onMachineDeactivated();

    @Override
    public boolean isConnected() {
        return this.controller != null;
    }

    @Override
    public MultiblockControllerBase getMultiblockController() {
        return this.controller;
    }

    @Override
    public void becomeMultiblockSaveDelegate() {
        this.saveMultiblockData = true;
    }

    @Override
    public void forfeitMultiblockSaveDelegate() {
        this.saveMultiblockData = false;
    }

    @Override
    public boolean isMultiblockSaveDelegate() {
        return this.saveMultiblockData;
    }

    @Override
    public void setUnvisited() {
        this.visited = false;
    }

    @Override
    public void setVisited() {
        this.visited = true;
    }

    @Override
    public boolean isVisited() {
        return this.visited;
    }

    @Override
    public void onAssimilated(MultiblockControllerBase newController) {
        assert (this.controller != newController);
        this.controller = newController;
    }

    @Override
    public void onAttached(MultiblockControllerBase newController) {
        this.controller = newController;
    }

    @Override
    public void onDetached(MultiblockControllerBase oldController) {
        this.controller = null;
    }

    @Override
    public abstract MultiblockControllerBase createNewMultiblock();

    @Override
    public IMultiblockPart[] getNeighboringParts() {
        ArrayList<IMultiblockPart> neighborParts = new ArrayList<IMultiblockPart>();
        BlockPos partPosition = this.getWorldPosition();
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            BlockPos neighborPosition = partPosition.func_177972_a(facing);
            TileEntity te = this.field_145850_b.func_175625_s(neighborPosition);
            if (!(te instanceof IMultiblockPart)) continue;
            neighborParts.add((IMultiblockPart)te);
        }
        return neighborParts.toArray(new IMultiblockPart[neighborParts.size()]);
    }

    @Override
    public void onOrphaned(MultiblockControllerBase controller, int oldSize, int newSize) {
        this.func_70296_d();
        this.field_145850_b.func_175646_b(this.getWorldPosition(), (TileEntity)this);
    }

    @Override
    public BlockPos getWorldPosition() {
        return this.field_174879_c;
    }

    @Override
    public boolean isPartInvalid() {
        return this.func_145837_r();
    }

    protected void notifyNeighborsOfBlockChange() {
        this.field_145850_b.func_175685_c(this.getWorldPosition(), this.func_145838_q());
    }

    @Deprecated
    protected void notifyNeighborsOfTileChange() {
    }

    protected void detachSelf(boolean chunkUnloading) {
        if (this.controller != null) {
            this.controller.detachBlock(this, chunkUnloading);
            this.controller = null;
        }
        REGISTRY.onPartRemovedFromWorld(this.field_145850_b, this);
    }

    protected void markMultiblockForRenderUpdate() {
        MultiblockControllerBase controller = this.getMultiblockController();
        if (null != controller) {
            controller.markMultiblockForRenderUpdate();
        }
    }
}

