/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.internal.common;

import it.zerono.mods.zerocore.api.multiblock.IMultiblockPart;
import it.zerono.mods.zerocore.api.multiblock.MultiblockControllerBase;
import it.zerono.mods.zerocore.util.WorldHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.fml.common.FMLLog;

final class MultiblockWorldRegistry {
    private World worldObj;
    private final Set<MultiblockControllerBase> controllers;
    private final Set<MultiblockControllerBase> dirtyControllers;
    private final Set<MultiblockControllerBase> deadControllers;
    private Set<IMultiblockPart> orphanedParts;
    private final Set<IMultiblockPart> detachedParts;
    private final HashMap<Long, Set<IMultiblockPart>> partsAwaitingChunkLoad;
    private final Object partsAwaitingChunkLoadMutex;
    private final Object orphanedPartsMutex;

    public MultiblockWorldRegistry(World world) {
        this.worldObj = world;
        this.controllers = new HashSet<MultiblockControllerBase>();
        this.deadControllers = new HashSet<MultiblockControllerBase>();
        this.dirtyControllers = new HashSet<MultiblockControllerBase>();
        this.detachedParts = new HashSet<IMultiblockPart>();
        this.orphanedParts = new HashSet<IMultiblockPart>();
        this.partsAwaitingChunkLoad = new HashMap();
        this.partsAwaitingChunkLoadMutex = new Object();
        this.orphanedPartsMutex = new Object();
    }

    public void tickStart() {
        if (this.controllers.size() > 0) {
            for (MultiblockControllerBase controller : this.controllers) {
                if (controller.WORLD != this.worldObj || controller.WORLD.field_72995_K != this.worldObj.field_72995_K) continue;
                if (controller.isEmpty()) {
                    this.deadControllers.add(controller);
                    continue;
                }
                controller.updateMultiblockEntity();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMultiblockChanges() {
        ArrayList<Set<MultiblockControllerBase>> mergePools = null;
        if (this.orphanedParts.size() > 0) {
            Object orphansToProcess = null;
            Object object = this.orphanedPartsMutex;
            synchronized (object) {
                if (this.orphanedParts.size() > 0) {
                    orphansToProcess = this.orphanedParts;
                    this.orphanedParts = new HashSet<IMultiblockPart>();
                }
            }
            if (orphansToProcess != null && orphansToProcess.size() > 0) {
                IChunkProvider iChunkProvider = this.worldObj.func_72863_F();
                Iterator iterator = orphansToProcess.iterator();
                while (iterator.hasNext()) {
                    IMultiblockPart orphan = (IMultiblockPart)iterator.next();
                    BlockPos coord = orphan.getWorldPosition();
                    if (!this.worldObj.func_175667_e(coord) || orphan.isPartInvalid() || this.getMultiblockPartFromWorld(this.worldObj, coord) != orphan) continue;
                    Set<MultiblockControllerBase> compatibleControllers = orphan.attachToNeighbors();
                    if (compatibleControllers == null) {
                        MultiblockControllerBase newController = orphan.createNewMultiblock();
                        newController.attachBlock(orphan);
                        this.controllers.add(newController);
                        continue;
                    }
                    if (compatibleControllers.size() <= 1) continue;
                    if (mergePools == null) {
                        mergePools = new ArrayList<Set<MultiblockControllerBase>>();
                    }
                    boolean hasAddedToPool = false;
                    ArrayList<Set> candidatePools = new ArrayList<Set>();
                    for (Set set : mergePools) {
                        if (Collections.disjoint(set, compatibleControllers)) continue;
                        candidatePools.add(set);
                    }
                    if (candidatePools.size() <= 0) {
                        mergePools.add(compatibleControllers);
                        continue;
                    }
                    if (candidatePools.size() == 1) {
                        ((Set)candidatePools.get(0)).addAll(compatibleControllers);
                        continue;
                    }
                    Set masterPool = (Set)candidatePools.get(0);
                    for (int i = 1; i < candidatePools.size(); ++i) {
                        Set set = (Set)candidatePools.get(i);
                        masterPool.addAll(set);
                        mergePools.remove(set);
                    }
                    masterPool.addAll(compatibleControllers);
                }
            }
        }
        if (mergePools != null && mergePools.size() > 0) {
            for (Set set : mergePools) {
                MultiblockControllerBase newMaster = null;
                for (MultiblockControllerBase controller : set) {
                    if (newMaster != null && !controller.shouldConsume(newMaster)) continue;
                    newMaster = controller;
                }
                if (newMaster == null) {
                    FMLLog.severe((String)"Multiblock system checked a merge pool of size %d, found no master candidates. This should never happen.", (Object[])new Object[]{set.size()});
                    continue;
                }
                this.addDirtyController(newMaster);
                for (MultiblockControllerBase controller : set) {
                    if (controller == newMaster) continue;
                    newMaster.assimilate(controller);
                    this.addDeadController(controller);
                    this.addDirtyController(newMaster);
                }
            }
        }
        if (this.dirtyControllers.size() > 0) {
            Set<IMultiblockPart> newlyDetachedParts = null;
            for (MultiblockControllerBase controller : this.dirtyControllers) {
                newlyDetachedParts = controller.checkForDisconnections();
                if (!controller.isEmpty()) {
                    controller.recalculateMinMaxCoords();
                    controller.checkIfMachineIsWhole();
                } else {
                    this.addDeadController(controller);
                }
                if (newlyDetachedParts == null || newlyDetachedParts.size() <= 0) continue;
                this.detachedParts.addAll(newlyDetachedParts);
            }
            this.dirtyControllers.clear();
        }
        if (this.deadControllers.size() > 0) {
            for (MultiblockControllerBase multiblockControllerBase : this.deadControllers) {
                if (!multiblockControllerBase.isEmpty()) {
                    FMLLog.severe((String)"Found a non-empty controller. Forcing it to shed its blocks and die. This should never happen!", (Object[])new Object[0]);
                    this.detachedParts.addAll(multiblockControllerBase.detachAllBlocks());
                }
                this.controllers.remove(multiblockControllerBase);
            }
            this.deadControllers.clear();
        }
        for (IMultiblockPart iMultiblockPart : this.detachedParts) {
            iMultiblockPart.assertDetached();
        }
        this.addAllOrphanedPartsThreadsafe(this.detachedParts);
        this.detachedParts.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPartAdded(IMultiblockPart part) {
        BlockPos worldLocation = part.getWorldPosition();
        if (!this.worldObj.func_175667_e(worldLocation)) {
            long chunkHash = WorldHelper.getChunkXZHashFromBlock(worldLocation);
            Object object = this.partsAwaitingChunkLoadMutex;
            synchronized (object) {
                Set<Object> partSet;
                if (!this.partsAwaitingChunkLoad.containsKey(chunkHash)) {
                    partSet = new HashSet();
                    this.partsAwaitingChunkLoad.put(chunkHash, partSet);
                } else {
                    partSet = this.partsAwaitingChunkLoad.get(chunkHash);
                }
                partSet.add(part);
            }
        } else {
            this.addOrphanedPartThreadsafe(part);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPartRemovedFromWorld(IMultiblockPart part) {
        long hash;
        BlockPos coord = part.getWorldPosition();
        if (coord != null && this.partsAwaitingChunkLoad.containsKey(hash = WorldHelper.getChunkXZHashFromBlock(coord))) {
            Object object = this.partsAwaitingChunkLoadMutex;
            synchronized (object) {
                if (this.partsAwaitingChunkLoad.containsKey(hash)) {
                    this.partsAwaitingChunkLoad.get(hash).remove(part);
                    if (this.partsAwaitingChunkLoad.get(hash).size() <= 0) {
                        this.partsAwaitingChunkLoad.remove(hash);
                    }
                }
            }
        }
        this.detachedParts.remove(part);
        if (this.orphanedParts.contains(part)) {
            Object object = this.orphanedPartsMutex;
            synchronized (object) {
                this.orphanedParts.remove(part);
            }
        }
        part.assertDetached();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWorldUnloaded() {
        this.controllers.clear();
        this.deadControllers.clear();
        this.dirtyControllers.clear();
        this.detachedParts.clear();
        Object object = this.partsAwaitingChunkLoadMutex;
        synchronized (object) {
            this.partsAwaitingChunkLoad.clear();
        }
        object = this.orphanedPartsMutex;
        synchronized (object) {
            this.orphanedParts.clear();
        }
        this.worldObj = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChunkLoaded(int chunkX, int chunkZ) {
        long chunkHash = ChunkPos.func_77272_a((int)chunkX, (int)chunkZ);
        if (this.partsAwaitingChunkLoad.containsKey(chunkHash)) {
            Object object = this.partsAwaitingChunkLoadMutex;
            synchronized (object) {
                if (this.partsAwaitingChunkLoad.containsKey(chunkHash)) {
                    this.addAllOrphanedPartsThreadsafe((Collection<? extends IMultiblockPart>)this.partsAwaitingChunkLoad.get(chunkHash));
                    this.partsAwaitingChunkLoad.remove(chunkHash);
                }
            }
        }
    }

    public void addDeadController(MultiblockControllerBase deadController) {
        this.deadControllers.add(deadController);
    }

    public void addDirtyController(MultiblockControllerBase dirtyController) {
        this.dirtyControllers.add(dirtyController);
    }

    public Set<MultiblockControllerBase> getControllers() {
        return Collections.unmodifiableSet(this.controllers);
    }

    protected IMultiblockPart getMultiblockPartFromWorld(World world, BlockPos position) {
        TileEntity te = world.func_175625_s(position);
        return te instanceof IMultiblockPart ? (IMultiblockPart)te : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOrphanedPartThreadsafe(IMultiblockPart part) {
        Object object = this.orphanedPartsMutex;
        synchronized (object) {
            this.orphanedParts.add(part);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAllOrphanedPartsThreadsafe(Collection<? extends IMultiblockPart> parts) {
        Object object = this.orphanedPartsMutex;
        synchronized (object) {
            this.orphanedParts.addAll(parts);
        }
    }
}

