/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc.api.event;

import li.cil.oc.api.network.Node;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;

@Cancelable
public class FileSystemAccessEvent
extends Event {
    protected String sound;
    protected World world;
    protected double x;
    protected double y;
    protected double z;
    protected TileEntity tileEntity;
    protected NBTTagCompound data;

    protected FileSystemAccessEvent(String sound, TileEntity tileEntity, NBTTagCompound data) {
        this.sound = sound;
        this.world = tileEntity.func_145831_w();
        this.x = (double)tileEntity.func_174877_v().func_177958_n() + 0.5;
        this.y = (double)tileEntity.func_174877_v().func_177956_o() + 0.5;
        this.z = (double)tileEntity.func_174877_v().func_177952_p() + 0.5;
        this.tileEntity = tileEntity;
        this.data = data;
    }

    protected FileSystemAccessEvent(String sound, World world, double x, double y, double z, NBTTagCompound data) {
        this.sound = sound;
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.tileEntity = null;
        this.data = data;
    }

    public String getSound() {
        return this.sound;
    }

    public World getWorld() {
        return this.world;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public TileEntity getTileEntity() {
        return this.tileEntity;
    }

    public NBTTagCompound getData() {
        return this.data;
    }

    public static final class Client
    extends FileSystemAccessEvent {
        public Client(String sound, TileEntity tileEntity, NBTTagCompound data) {
            super(sound, tileEntity, data);
        }

        public Client(String sound, World world, double x, double y, double z, NBTTagCompound data) {
            super(sound, world, x, y, z, data);
        }
    }

    public static final class Server
    extends FileSystemAccessEvent {
        private Node node;

        public Server(String sound, TileEntity tileEntity, Node node) {
            super(sound, tileEntity, new NBTTagCompound());
            this.node = node;
        }

        public Server(String sound, World world, double x, double y, double z, Node node) {
            super(sound, world, x, y, z, new NBTTagCompound());
            this.node = node;
        }

        public Node getNode() {
            return this.node;
        }
    }
}

