/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers;

import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import teamroots.embers.Embers;
import teamroots.embers.RegistryManager;
import teamroots.embers.block.IDial;
import teamroots.embers.item.IEmberChargedTool;
import teamroots.embers.item.ItemEmberGauge;
import teamroots.embers.item.ItemGrandhammer;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageEmberBurstFX;
import teamroots.embers.network.message.MessageEmberDataRequest;
import teamroots.embers.network.message.MessageEmberGeneration;
import teamroots.embers.proxy.ClientProxy;
import teamroots.embers.util.FluidTextureUtil;
import teamroots.embers.util.Misc;
import teamroots.embers.util.RenderUtil;
import teamroots.embers.world.EmberWorldData;

public class EventManager {
    double gaugeAngle = 0.0;
    public static boolean hasRenderedParticles = false;
    Random random = new Random();
    static EntityPlayer clientPlayer = null;

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTextureStitchPre(TextureStitchEvent.Pre event) {
        FluidTextureUtil.initTextures(event.getMap());
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent event) {
        ResourceLocation particleGlow = new ResourceLocation("embers:entity/particleMote");
        event.getMap().func_174942_a(particleGlow);
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        EmberWorldData.get(event.getWorld());
    }

    @SubscribeEvent
    public void onChunkGeneration(ChunkEvent.Load event) {
        EmberWorldData data = EmberWorldData.get(event.getWorld());
        if (!data.emberData.containsKey("" + event.getChunk().field_76635_g + " " + event.getChunk().field_76647_h)) {
            Biome biome = event.getWorld().func_72959_q().func_180631_a(new BlockPos(event.getChunk().field_76635_g * 16, 64, event.getChunk().field_76647_h * 16));
            int baseAmount = 40000;
            int bonusAmount = 40000;
            double mult = 1.0;
            if (Misc.isHills(biome)) {
                mult = 1.5;
            }
            if (Misc.isExtremeHills(biome)) {
                mult = 2.0;
            }
            baseAmount = (int)((double)baseAmount * mult);
            bonusAmount = (int)((double)bonusAmount * mult);
            double value = 4.0 * ((double)baseAmount + this.random.nextDouble() * (double)bonusAmount);
            if (this.random.nextInt(20 / (int)mult) == 0 && !event.getWorld().field_72995_K) {
                data.emberData.put("" + event.getChunk().field_76635_g + " " + event.getChunk().field_76647_h, value);
                data.func_76185_a();
                if (!event.getWorld().field_72995_K) {
                    PacketHandler.INSTANCE.sendToAll((IMessage)new MessageEmberGeneration("" + event.getChunk().field_76635_g + " " + event.getChunk().field_76647_h, value));
                }
            } else {
                data.emberData.put("" + event.getChunk().field_76635_g + " " + event.getChunk().field_76647_h, 0.0);
                data.func_76185_a();
                if (!event.getWorld().field_72995_K) {
                    PacketHandler.INSTANCE.sendToAll((IMessage)new MessageEmberGeneration("" + event.getChunk().field_76635_g + " " + event.getChunk().field_76647_h, 0.0));
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onPlayerLogin(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityPlayer && event.getWorld().field_72995_K) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageEmberDataRequest(((EntityPlayer)event.getEntity()).func_110124_au()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onGameOverlayRender(RenderGameOverlayEvent.Post e) {
        IBlockState state;
        World world;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        boolean showBar = false;
        int w = e.getResolution().func_78326_a();
        int h = e.getResolution().func_78328_b();
        int x = w / 2;
        int y = h / 2 - 20;
        if (player.func_184614_ca() != null && player.func_184614_ca().func_77973_b() instanceof ItemEmberGauge) {
            showBar = true;
        }
        if (player.func_184592_cb() != null && player.func_184592_cb().func_77973_b() instanceof ItemEmberGauge) {
            showBar = true;
        }
        if (showBar) {
            world = player.func_130014_f_();
            if (e.getType() == RenderGameOverlayEvent.ElementType.TEXT) {
                GlStateManager.func_179097_i();
                GlStateManager.func_179129_p();
                GlStateManager.func_179094_E();
                Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("embers:textures/gui/emberMeterOverlay.png"));
                Tessellator tess = Tessellator.func_178181_a();
                VertexBuffer b = tess.func_178180_c();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                boolean offsetX = false;
                b.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                RenderUtil.drawQuadGui(b, x - 16, y + 16, x + 16, y + 16, x + 16, y - 16, x - 16, y - 16, 0, 0, 1, 1);
                tess.func_78381_a();
                double angle = 195.0;
                EmberWorldData data = EmberWorldData.get(world);
                if (data != null && player != null && data.emberData != null && data.emberData.containsKey("" + (int)player.field_70165_t / 16 + " " + (int)player.field_70161_v / 16)) {
                    double value = data.emberData.get("" + (int)player.field_70165_t / 16 + " " + (int)player.field_70161_v / 16);
                    double ratio = value / 640000.0;
                    this.gaugeAngle = this.gaugeAngle == 0.0 ? 165.0 + 210.0 * ratio : this.gaugeAngle * 0.99 + 0.01 * (165.0 + 210.0 * ratio);
                }
                Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("embers:textures/gui/emberMeterPointer.png"));
                GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
                GlStateManager.func_179114_b((float)((float)this.gaugeAngle), (float)0.0f, (float)0.0f, (float)1.0f);
                b.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                RenderUtil.drawQuadGui(b, -2.5f, 13.5f, 13.5f, 13.5f, 13.5f, -2.5f, -2.5f, -2.5f, 0, 0, 1, 1);
                tess.func_78381_a();
                GlStateManager.func_179121_F();
                GlStateManager.func_179089_o();
                GlStateManager.func_179126_j();
            }
        }
        world = player.func_130014_f_();
        RayTraceResult result = player.func_174822_a(6.0, e.getPartialTicks());
        if (result != null && result.field_72313_a == RayTraceResult.Type.BLOCK && (state = world.func_180495_p(result.func_178782_a())).func_177230_c() instanceof IDial) {
            List<String> text = ((IDial)state.func_177230_c()).getDisplayInfo(world, result.func_178782_a(), state);
            for (int i = 0; i < text.size(); ++i) {
                Minecraft.func_71410_x().field_71466_p.func_175063_a(text.get(i), (float)(x - Minecraft.func_71410_x().field_71466_p.func_78256_a(text.get(i)) / 2), (float)(y + 40 + 11 * i), 0xFFFFFF);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.side == Side.CLIENT) {
            ClientProxy cfr_ignored_0 = (ClientProxy)Embers.proxy;
            ClientProxy.particleRenderer.updateParticles();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onEntityDamaged(LivingHurtEvent event) {
        if (event.getSource().field_76373_n == RegistryManager.damageEmber.field_76373_n && event.getEntityLiving().func_70644_a(Potion.func_180142_b((String)"fire_resistance"))) {
            event.setAmount(event.getAmount() * 0.5f);
        }
        if (event.getSource().func_76346_g() != null && event.getSource().func_76346_g() instanceof EntityPlayer && ((EntityPlayer)event.getSource().func_76346_g()).func_184614_ca() != null && ((EntityPlayer)event.getSource().func_76346_g()).func_184614_ca().func_77973_b() instanceof IEmberChargedTool) {
            if (IEmberChargedTool.hasEmber(((EntityPlayer)event.getSource().func_76346_g()).func_184614_ca())) {
                event.getEntityLiving().func_70015_d(1);
                if (!event.getEntityLiving().func_130014_f_().field_72995_K) {
                    PacketHandler.INSTANCE.sendToAll((IMessage)new MessageEmberBurstFX(event.getEntityLiving().field_70165_t, event.getEntityLiving().field_70163_u + (double)event.getEntityLiving().func_70047_e() / 1.5, event.getEntityLiving().field_70161_v));
                    ((EntityPlayer)event.getSource().func_76346_g()).func_184614_ca().func_77978_p().func_74757_a("didUse", true);
                }
            } else {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        if (event.getPlayer() != null && event.getPlayer().func_184614_ca() != null && event.getPlayer().func_184614_ca().func_77973_b() instanceof ItemGrandhammer) {
            event.setCanceled(true);
            event.getWorld().func_175698_g(event.getPos());
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onRenderAfterWorld(RenderWorldLastEvent event) {
        if (Embers.proxy instanceof ClientProxy) {
            ClientProxy cfr_ignored_0 = (ClientProxy)Embers.proxy;
            ClientProxy.particleRenderer.renderParticles(clientPlayer, event.getPartialTicks());
        }
    }
}

