/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.compat.jei;

import java.util.ArrayList;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import teamroots.embers.RegistryManager;
import teamroots.embers.item.EnumStampType;
import teamroots.embers.recipe.ItemStampingOreRecipe;
import teamroots.embers.recipe.ItemStampingRecipe;

public class StampingRecipeWrapper
extends BlankRecipeWrapper {
    public ItemStampingRecipe recipe = null;
    public ItemStampingOreRecipe oreRecipe = null;
    boolean isOreRecipe = false;

    public StampingRecipeWrapper(ItemStampingRecipe recipe) {
        this.recipe = recipe;
        this.isOreRecipe = false;
    }

    public StampingRecipeWrapper(ItemStampingOreRecipe recipe) {
        this.oreRecipe = recipe;
        this.isOreRecipe = true;
    }

    public void getIngredients(IIngredients ingredients) {
        if (!this.isOreRecipe) {
            ItemStack stampStack = new ItemStack(RegistryManager.stampFlat, 1);
            if (this.recipe.getStamp() == EnumStampType.TYPE_BAR) {
                stampStack = new ItemStack(RegistryManager.stampBar, 1);
            }
            if (this.recipe.getStamp() == EnumStampType.TYPE_PLATE) {
                stampStack = new ItemStack(RegistryManager.stampPlate, 1);
            }
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            stacks.add(this.recipe.getStack());
            stacks.add(stampStack);
            ingredients.setInputs(ItemStack.class, stacks);
            ingredients.setInput(FluidStack.class, (Object)this.recipe.getFluid());
            ingredients.setOutput(ItemStack.class, (Object)this.recipe.result);
        } else {
            ArrayList validStacks = new ArrayList(OreDictionary.getOres((String)this.oreRecipe.getOre()));
            ArrayList<ItemStack> stampStacks = new ArrayList<ItemStack>();
            ItemStack stampStack = new ItemStack(RegistryManager.stampFlat, 1);
            if (this.recipe.getStamp() == EnumStampType.TYPE_BAR) {
                stampStack = new ItemStack(RegistryManager.stampBar, 1);
            }
            if (this.recipe.getStamp() == EnumStampType.TYPE_PLATE) {
                stampStack = new ItemStack(RegistryManager.stampPlate, 1);
            }
            stampStacks.add(stampStack);
            ArrayList recipeItems = new ArrayList();
            recipeItems.add(validStacks);
            recipeItems.add(stampStacks);
            ingredients.setInputLists(ItemStack.class, recipeItems);
            ingredients.setInput(FluidStack.class, (Object)this.oreRecipe.getFluid());
            ingredients.setOutput(ItemStack.class, (Object)this.oreRecipe.result);
        }
    }
}

