/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.item;

import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import teamroots.embers.Embers;
import teamroots.embers.item.IEmberChargedTool;
import teamroots.embers.item.IModeledItem;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageEmberBurstFX;
import teamroots.embers.util.EmberInventoryUtil;

public class ItemClockworkAxe
extends ItemTool
implements IModeledItem,
IEmberChargedTool {
    public static Item.ToolMaterial materialClockworkAxe = EnumHelper.addToolMaterial((String)"embers:clockworkAxe", (int)3, (int)-1, (float)12.0f, (float)5.0f, (int)15);

    public ItemClockworkAxe(String name, boolean addToTab) {
        super(materialClockworkAxe, (Set)Sets.newHashSet((Object[])new Block[]{Blocks.field_150344_f}));
        this.func_77655_b(name);
        this.setRegistryName("embers:" + name);
        if (addToTab) {
            this.func_77637_a(Embers.tab);
        }
        this.setHarvestLevel("axe", this.field_77862_b.func_77996_d());
        this.field_77865_bY = 8.0f;
        this.field_185065_c = -2.7f;
        GameRegistry.register((IForgeRegistryEntry)this);
    }

    public float getProperEfficiency() {
        return this.field_77864_a;
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        Material material = state.func_185904_a();
        if (stack.func_77942_o() && !stack.func_77978_p().func_74767_n("poweredOn")) {
            return 0.0f;
        }
        return material != Material.field_151575_d && material != Material.field_151585_k && material != Material.field_151582_l && material != Material.field_151570_A && material != Material.field_151593_r && material != Material.field_151580_n && material != Material.field_151569_G && material != Material.field_151572_C ? super.func_150893_a(stack, state) : this.field_77864_a;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (EmberInventoryUtil.getEmberTotal(player) >= 25.0 && stack.func_77978_p().func_74762_e("cooldown") <= 0) {
            double posX = player.field_70165_t;
            double posY = player.field_70163_u + (double)player.func_70047_e();
            double posZ = player.field_70161_v;
            boolean doContinue = true;
            for (double i = 0.0; i < 40.0 && doContinue; i += 1.0) {
                for (int j = 0; j < 5; ++j) {
                    posX += (double)0.1f * player.func_70040_Z().field_72450_a;
                    posY += (double)0.1f * player.func_70040_Z().field_72448_b;
                    posZ += (double)0.1f * player.func_70040_Z().field_72449_c;
                }
                IBlockState state = world.func_180495_p(new BlockPos(posX, posY, posZ));
                if (!state.func_185917_h() || !state.func_185914_p()) continue;
                doContinue = false;
                BlockPos pos = new BlockPos(posX, posY, posZ);
                if (!world.field_72995_K) {
                    PacketHandler.INSTANCE.sendToAll((IMessage)new MessageEmberBurstFX((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5));
                }
                for (int xx = -3; xx < 4; ++xx) {
                    for (int yy = -3; yy < 4; ++yy) {
                        for (int zz = -3; zz < 4; ++zz) {
                            BlockPos newPos = pos.func_177982_a(xx, yy, zz);
                            if (world.func_180495_p(newPos).func_185904_a() != Material.field_151575_d) continue;
                            IBlockState tempState = world.func_180495_p(newPos);
                            world.func_175655_b(newPos, true);
                            world.func_184138_a(newPos, state, Blocks.field_150350_a.func_176223_P(), 3);
                        }
                    }
                }
                stack.func_77978_p().func_74768_a("cooldown", 80);
                EmberInventoryUtil.removeEmber(player, 25.0);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74762_e("cooldown") > 0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74762_e("cooldown") > 0) {
            return (float)stack.func_77978_p().func_74762_e("cooldown") / 80.0f;
        }
        return 0.0;
    }

    public boolean func_179218_a(ItemStack stack, World world, IBlockState state, BlockPos pos, EntityLivingBase living) {
        stack.func_77978_p().func_74757_a("didUse", true);
        return true;
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        return this.getHarvestLevel(stack, state.func_177230_c().getHarvestTool(state)) >= state.func_177230_c().getHarvestLevel(state);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (oldStack.func_77942_o() && newStack.func_77942_o()) {
            return slotChanged || oldStack.func_77978_p().func_74767_n("poweredOn") != newStack.func_77978_p().func_74767_n("poweredOn");
        }
        return slotChanged;
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        if (oldStack.func_77942_o() && newStack.func_77942_o()) {
            return oldStack.func_77978_p().func_74767_n("poweredOn") != newStack.func_77978_p().func_74767_n("poweredOn");
        }
        return false;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
            stack.func_77978_p().func_74768_a("tickCount", 0);
            stack.func_77978_p().func_74768_a("cooldown", 0);
            stack.func_77978_p().func_74757_a("poweredOn", false);
            stack.func_77978_p().func_74757_a("didUse", false);
        } else {
            if (stack.func_77978_p().func_74762_e("cooldown") > 0) {
                stack.func_77978_p().func_74768_a("cooldown", stack.func_77978_p().func_74762_e("cooldown") - 1);
            }
            if (entity instanceof EntityPlayer) {
                stack.func_77978_p().func_74768_a("tickCount", stack.func_77978_p().func_74762_e("tickCount") + 1);
                if (stack.func_77978_p().func_74762_e("tickCount") >= 5) {
                    stack.func_77978_p().func_74768_a("tickCount", 0);
                    if (EmberInventoryUtil.getEmberTotal((EntityPlayer)entity) > 5.0) {
                        if (!stack.func_77978_p().func_74767_n("poweredOn")) {
                            stack.func_77978_p().func_74757_a("poweredOn", true);
                        }
                    } else if (stack.func_77978_p().func_74767_n("poweredOn")) {
                        stack.func_77978_p().func_74757_a("poweredOn", false);
                    }
                }
                if (stack.func_77978_p().func_74767_n("didUse")) {
                    stack.func_77978_p().func_74757_a("didUse", false);
                    EmberInventoryUtil.removeEmber((EntityPlayer)entity, 5.0);
                    if (EmberInventoryUtil.getEmberTotal((EntityPlayer)entity) < 5.0) {
                        stack.func_77978_p().func_74757_a("poweredOn", false);
                    }
                }
            }
        }
    }

    @Override
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName().toString()));
    }
}

